/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shaper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.bindings.DefaultAction;
import mcjty.lib.bindings.DefaultValue;
import mcjty.lib.bindings.IAction;
import mcjty.lib.bindings.IValue;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.container.SlotType;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftools.blocks.builder.BuilderSetup;
import mcjty.rftools.blocks.shaper.ScannerConfiguration;
import mcjty.rftools.blocks.storage.ModularStorageSetup;
import mcjty.rftools.items.ModItems;
import mcjty.rftools.items.builder.ShapeCardItem;
import mcjty.rftools.items.modifier.ModifierEntry;
import mcjty.rftools.items.modifier.ModifierFilterOperation;
import mcjty.rftools.items.modifier.ModifierItem;
import mcjty.rftools.items.storage.StorageFilterCache;
import mcjty.rftools.items.storage.StorageFilterItem;
import mcjty.rftools.shapes.ScanDataManager;
import mcjty.rftools.shapes.Shape;
import mcjty.rftools.shapes.StatePalette;
import mcjty.rftools.varia.RLE;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ScannerTileEntity
extends GenericEnergyReceiverTileEntity
implements DefaultSidedInventory,
ITickable {
    public static final String ACTION_SCAN = "scan";
    public static Key<BlockPos> VALUE_OFFSET = new Key("offset", Type.BLOCKPOS);
    public static final int SLOT_IN = 0;
    public static final int SLOT_OUT = 1;
    public static final int SLOT_FILTER = 2;
    public static final int SLOT_MODIFIER = 3;
    public static final ContainerFactory CONTAINER_FACTORY = new ContainerFactory(){

        protected void setup() {
            this.addSlot(new SlotDefinition(SlotType.SLOT_SPECIFICITEM, new ItemStack[]{new ItemStack((Item)BuilderSetup.shapeCardItem)}), "container", 0, 15, 7);
            this.addSlot(new SlotDefinition(SlotType.SLOT_SPECIFICITEM, new ItemStack[]{new ItemStack((Item)BuilderSetup.shapeCardItem)}), "container", 1, 15, 200);
            this.addSlot(new SlotDefinition(SlotType.SLOT_SPECIFICITEM, new ItemStack[]{new ItemStack((Item)ModularStorageSetup.storageFilterItem)}), "container", 2, 35, 7);
            this.addSlot(new SlotDefinition(SlotType.SLOT_SPECIFICITEM, new ItemStack[]{new ItemStack((Item)ModItems.modifierItem)}), "container", 3, 55, 7);
            this.layoutPlayerInventorySlots(85, 142);
        }
    };
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, CONTAINER_FACTORY, 4);
    private StorageFilterCache filterCache = null;
    private int scanId = 0;
    private ItemStack renderStack = ItemStack.field_190927_a;
    private BlockPos dataDim;
    private BlockPos dataOffset = new BlockPos(0, 0, 0);
    private ScanProgress progress = null;
    private int progressBusy = -1;

    public IValue<?>[] getValues() {
        return new IValue[]{new DefaultValue(VALUE_RSMODE, () -> ((ScannerTileEntity)this).getRSModeInt(), arg_0 -> ((ScannerTileEntity)this).setRSModeInt(arg_0)), new DefaultValue(VALUE_OFFSET, this::getDataOffset, this::setDataOffset)};
    }

    public IAction[] getActions() {
        return new IAction[]{new DefaultAction(ACTION_SCAN, this::scan)};
    }

    public ScannerTileEntity() {
        super((long)ScannerConfiguration.SCANNER_MAXENERGY.get(), (long)ScannerConfiguration.SCANNER_RECEIVEPERTICK.get());
        this.setRSMode(RedstoneMode.REDSTONE_ONREQUIRED);
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            if (this.progress != null) {
                if (this.getStoredPower() >= this.getEnergyPerTick()) {
                    this.consumeEnergy(this.getEnergyPerTick());
                    for (int done = 0; this.progress != null && done < ScannerConfiguration.surfaceAreaPerTick.get(); done += this.dataDim.func_177952_p() * this.dataDim.func_177956_o()) {
                        this.progressScan();
                    }
                }
            } else if (this.isMachineEnabled()) {
                this.scan();
            }
        }
    }

    protected long getEnergyPerTick() {
        return ScannerConfiguration.SCANNER_PERTICK.get();
    }

    public int getScanProgress() {
        return this.progressBusy;
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index == 2) {
            this.filterCache = null;
        }
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
        if (index == 1 && !stack.func_190926_b()) {
            this.updateScanCard(stack);
            this.func_70296_d();
        }
        if (index == 0 && !stack.func_190926_b()) {
            this.dataDim = ShapeCardItem.getDimension(stack);
            if (this.renderStack.func_190926_b()) {
                this.renderStack = new ItemStack((Item)BuilderSetup.shapeCardItem);
            }
            this.updateScanCard(this.renderStack);
            this.func_70296_d();
        }
    }

    public ItemStack func_70298_a(int index, int count) {
        if (index == 2) {
            this.filterCache = null;
        }
        return this.getInventoryHelper().decrStackSize(index, count);
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean func_191420_l() {
        return false;
    }

    public int getScanId() {
        if (this.scanId == 0 && !this.field_145850_b.field_72995_K) {
            this.scanId = ScanDataManager.getScans().newScan(this.field_145850_b);
            this.markDirtyQuick();
        }
        return this.scanId;
    }

    public BlockPos getDataDim() {
        return this.dataDim;
    }

    public BlockPos getDataOffset() {
        return this.dataOffset;
    }

    private void getFilterCache() {
        if (this.filterCache == null) {
            this.filterCache = StorageFilterItem.getCache(this.inventoryHelper.getStackInSlot(2));
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() == BuilderSetup.shapeCardItem;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.renderStack = tagCompound.func_74764_b("render") ? new ItemStack(tagCompound.func_74775_l("render")) : ItemStack.field_190927_a;
        this.scanId = tagCompound.func_74762_e("scanid");
        this.dataDim = new BlockPos(tagCompound.func_74762_e("scandimx"), tagCompound.func_74762_e("scandimy"), tagCompound.func_74762_e("scandimz"));
        this.dataOffset = new BlockPos(tagCompound.func_74762_e("scanoffx"), tagCompound.func_74762_e("scanoffy"), tagCompound.func_74762_e("scanoffz"));
        this.progressBusy = tagCompound.func_74762_e("progress");
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        if (!this.renderStack.func_190926_b()) {
            NBTTagCompound tc = new NBTTagCompound();
            this.renderStack.func_77955_b(tc);
            tagCompound.func_74782_a("render", (NBTBase)tc);
        }
        tagCompound.func_74768_a("scanid", this.getScanId());
        if (this.dataDim != null) {
            tagCompound.func_74768_a("scandimx", this.dataDim.func_177958_n());
            tagCompound.func_74768_a("scandimy", this.dataDim.func_177956_o());
            tagCompound.func_74768_a("scandimz", this.dataDim.func_177952_p());
        }
        if (this.dataOffset != null) {
            tagCompound.func_74768_a("scanoffx", this.dataOffset.func_177958_n());
            tagCompound.func_74768_a("scanoffy", this.dataOffset.func_177956_o());
            tagCompound.func_74768_a("scanoffz", this.dataOffset.func_177952_p());
        }
        if (this.progress == null || this.progress.dimX == 0) {
            tagCompound.func_74768_a("progress", -1);
        } else {
            tagCompound.func_74768_a("progress", (this.progress.x - this.progress.tl.func_177958_n()) * 100 / this.progress.dimX);
        }
    }

    public ItemStack getRenderStack() {
        ItemStack stack = this.inventoryHelper.getStackInSlot(1);
        if (!stack.func_190926_b()) {
            return stack;
        }
        if (this.renderStack.func_190926_b()) {
            this.renderStack = new ItemStack((Item)BuilderSetup.shapeCardItem);
            this.updateScanCard(this.renderStack);
        }
        return this.renderStack;
    }

    private void setOffset(int offsetX, int offsetY, int offsetZ) {
        this.dataOffset = new BlockPos(offsetX, offsetY, offsetZ);
        this.markDirtyClient();
    }

    public void setDataOffset(BlockPos dataOffset) {
        this.dataOffset = dataOffset;
    }

    private void updateScanCard(ItemStack cardOut) {
        if (!cardOut.func_190926_b()) {
            if (!ShapeCardItem.getShape(cardOut).isScan()) {
                boolean solid = ShapeCardItem.isSolid(cardOut);
                ShapeCardItem.setShape(cardOut, Shape.SHAPE_SCAN, solid);
            }
            NBTTagCompound tagOut = cardOut.func_77978_p();
            if (this.dataDim != null) {
                ShapeCardItem.setDimension(cardOut, this.dataDim.func_177958_n(), this.dataDim.func_177956_o(), this.dataDim.func_177952_p());
                ShapeCardItem.setData(tagOut, this.getScanId());
            }
        }
    }

    private void scan() {
        if (this.progress != null) {
            return;
        }
        if (this.func_70301_a(0).func_190926_b()) {
            return;
        }
        BlockPos machinePos = this.getScanPos();
        if (machinePos == null) {
            return;
        }
        int dimX = this.dataDim.func_177958_n();
        int dimY = this.dataDim.func_177956_o();
        int dimZ = this.dataDim.func_177952_p();
        this.startScanArea(this.getScanCenter(), this.getScanDimension(), dimX, dimY, dimZ);
    }

    public World getScanWorld(int dimension) {
        WorldServer w = DimensionManager.getWorld((int)dimension);
        if (w == null) {
            w = this.func_145831_w().func_73046_m().func_71218_a(dimension);
        }
        return w;
    }

    protected BlockPos getScanPos() {
        return this.func_174877_v();
    }

    public int getScanDimension() {
        return this.func_145831_w().field_73011_w.getDimension();
    }

    public BlockPos getScanCenter() {
        if (this.getScanPos() == null) {
            return null;
        }
        return this.getScanPos().func_177982_a(this.dataOffset.func_177958_n(), this.dataOffset.func_177956_o(), this.dataOffset.func_177952_p());
    }

    public BlockPos getFirstCorner() {
        if (this.getScanPos() == null) {
            return null;
        }
        return this.getScanPos().func_177982_a(this.dataOffset.func_177958_n() - this.dataDim.func_177958_n() / 2, this.dataOffset.func_177956_o() - this.dataDim.func_177956_o() / 2, this.dataOffset.func_177952_p() - this.dataDim.func_177952_p() / 2);
    }

    public BlockPos getLastCorner() {
        if (this.getScanPos() == null) {
            return null;
        }
        return this.getScanPos().func_177982_a(this.dataOffset.func_177958_n() + this.dataDim.func_177958_n() / 2, this.dataOffset.func_177956_o() + this.dataDim.func_177956_o() / 2, this.dataOffset.func_177952_p() + this.dataDim.func_177952_p() / 2);
    }

    private IBlockState mapState(List<ModifierEntry> modifiers, Map<IBlockState, IBlockState> modifierMapping, BlockPos pos, IBlockState inState) {
        if (modifiers.isEmpty()) {
            return inState;
        }
        if (!modifierMapping.containsKey(inState)) {
            IBlockState outState = inState;
            boolean stop = false;
            block6: for (ModifierEntry modifier : modifiers) {
                if (stop) break;
                block0 : switch (modifier.getType()) {
                    case FILTER_SLOT: {
                        ItemStack inputItem = inState.func_177230_c().func_185473_a(this.func_145831_w(), pos, inState);
                        if (!modifier.getIn().func_190926_b() && modifier.getIn().func_77973_b() == ModularStorageSetup.storageFilterItem) {
                            StorageFilterCache filter = StorageFilterItem.getCache(modifier.getIn());
                            if (!filter.match(inputItem)) continue block6;
                            outState = this.getOutput(inState, modifier);
                            stop = true;
                            break;
                        }
                        if (!modifier.getIn().func_190926_b() && !ItemStack.func_179545_c((ItemStack)inputItem, (ItemStack)modifier.getIn())) break;
                        outState = this.getOutput(inState, modifier);
                        stop = true;
                        break;
                    }
                    case FILTER_ORE: {
                        int[] oreIDs;
                        ItemStack inputItem = inState.func_177230_c().func_185473_a(this.func_145831_w(), pos, inState);
                        if (inputItem.func_190926_b()) break;
                        for (int id : oreIDs = OreDictionary.getOreIDs((ItemStack)inputItem)) {
                            if (!OreDictionary.getOreName((int)id).startsWith("ore")) continue;
                            outState = this.getOutput(inState, modifier);
                            stop = true;
                            break block0;
                        }
                        continue block6;
                    }
                    case FILTER_LIQUID: {
                        if (!(inState.func_177230_c() instanceof BlockLiquid)) break;
                        outState = this.getOutput(inState, modifier);
                        stop = true;
                        break;
                    }
                    case FILTER_TILEENTITY: {
                        if (this.func_145831_w().func_175625_s(pos) == null) break;
                        outState = this.getOutput(inState, modifier);
                        stop = true;
                    }
                }
            }
            modifierMapping.put(inState, outState);
        }
        return modifierMapping.get(inState);
    }

    private IBlockState getOutput(IBlockState input, ModifierEntry modifier) {
        if (modifier.getOp() == ModifierFilterOperation.OPERATION_VOID) {
            return Blocks.field_150350_a.func_176223_P();
        }
        ItemStack outputItem = modifier.getOut();
        if (outputItem.func_190926_b()) {
            return input;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(outputItem.func_77973_b().getRegistryName());
        if (block == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return block.func_176203_a(outputItem.func_77960_j());
    }

    private void startScanArea(BlockPos center, int dimension, int dimX, int dimY, int dimZ) {
        this.progress = new ScanProgress();
        this.progress.modifiers = ModifierItem.getModifiers(this.func_70301_a(3));
        this.progress.modifierMapping = new HashMap<IBlockState, IBlockState>();
        this.progress.rle = new RLE();
        this.progress.tl = new BlockPos(center.func_177958_n() - dimX / 2, center.func_177956_o() - dimY / 2, center.func_177952_p() - dimZ / 2);
        this.progress.materialPalette = new StatePalette();
        this.progress.materialPalette.alloc(BuilderSetup.supportBlock.func_176223_P(), 0);
        this.progress.x = this.progress.tl.func_177958_n();
        this.progress.dimX = dimX;
        this.progress.dimY = dimY;
        this.progress.dimZ = dimZ;
        this.progress.dimension = dimension;
        this.markDirtyClient();
    }

    private void progressScan() {
        if (this.progress == null) {
            return;
        }
        BlockPos tl = this.progress.tl;
        int dimX = this.progress.dimX;
        int dimY = this.progress.dimY;
        int dimZ = this.progress.dimZ;
        World world = this.getScanWorld(this.progress.dimension);
        BlockPos.MutableBlockPos mpos = this.progress.mpos;
        for (int z = tl.func_177952_p(); z < tl.func_177952_p() + dimZ; ++z) {
            for (int y = tl.func_177956_o(); y < tl.func_177956_o() + dimY; ++y) {
                int c;
                mpos.func_181079_c(this.progress.x, y, z);
                if (world.func_175623_d((BlockPos)mpos)) {
                    c = 0;
                } else {
                    ItemStack item;
                    IBlockState state = world.func_180495_p((BlockPos)mpos);
                    this.getFilterCache();
                    if (this.filterCache != null && !this.filterCache.match(item = state.func_177230_c().func_185473_a(world, (BlockPos)mpos, state))) {
                        state = null;
                    }
                    if (state != null && state != Blocks.field_150350_a.func_176223_P()) {
                        state = this.mapState(this.progress.modifiers, this.progress.modifierMapping, (BlockPos)mpos, state);
                    }
                    c = state != null && state != Blocks.field_150350_a.func_176223_P() ? this.progress.materialPalette.alloc(state, 0) + 1 : 0;
                }
                this.progress.rle.add(c);
            }
        }
        ++this.progress.x;
        if (this.progress.x >= tl.func_177958_n() + dimX) {
            this.stopScanArea();
        } else {
            this.markDirtyClient();
        }
    }

    private void stopScanArea() {
        this.dataDim = new BlockPos(this.progress.dimX, this.progress.dimY, this.progress.dimZ);
        ScanDataManager scan = ScanDataManager.getScans();
        scan.getOrCreateScan(this.getScanId()).setData(this.progress.rle.getData(), this.progress.materialPalette.getPalette(), this.dataDim, this.dataOffset);
        scan.save(this.getScanId());
        if (this.renderStack.func_190926_b()) {
            this.renderStack = new ItemStack((Item)BuilderSetup.shapeCardItem);
        }
        this.updateScanCard(this.renderStack);
        this.markDirtyClient();
        this.progress = null;
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        probeInfo.text(TextStyleClass.LABEL + "Scan id: " + TextStyleClass.INFO + this.getScanId());
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public void addWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.addWailaBody(itemStack, currenttip, accessor, config);
        currenttip.add("Scan id: " + TextFormatting.WHITE + this.getScanId());
    }

    private static class ScanProgress {
        List<ModifierEntry> modifiers;
        Map<IBlockState, IBlockState> modifierMapping;
        RLE rle;
        BlockPos tl;
        StatePalette materialPalette;
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        int dimX;
        int dimY;
        int dimZ;
        int x;
        int dimension;

        private ScanProgress() {
        }
    }
}

