/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.environmental;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.WorldTools;
import mcjty.rftools.blocks.environmental.EnvironmentalControllerTileEntity;
import mcjty.rftools.blocks.environmental.modules.EnvironmentModule;
import mcjty.rftools.blocks.environmental.modules.PeacefulEModule;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class PeacefulAreaManager {
    private static final Map<GlobalCoordinate, PeacefulArea> areas = new HashMap<GlobalCoordinate, PeacefulArea>();

    public static void markArea(GlobalCoordinate coordinate, int radius, int miny, int maxy) {
        if (areas.containsKey(coordinate)) {
            areas.get(coordinate).touch().setArea(radius, miny, maxy);
        } else {
            PeacefulArea area = new PeacefulArea(radius, miny, maxy);
            areas.put(coordinate, area);
        }
    }

    public static boolean isPeaceful(GlobalCoordinate coordinate) {
        if (areas.isEmpty()) {
            return false;
        }
        ArrayList<GlobalCoordinate> toRemove = new ArrayList<GlobalCoordinate>();
        boolean peaceful = false;
        long curtime = System.currentTimeMillis() - 10000L;
        for (Map.Entry<GlobalCoordinate, PeacefulArea> entry : areas.entrySet()) {
            BlockPos c;
            WorldServer world;
            GlobalCoordinate entryCoordinate;
            PeacefulArea area = entry.getValue();
            if (area.in(coordinate, entryCoordinate = entry.getKey())) {
                peaceful = true;
            }
            if (area.getLastTouched() >= curtime || (world = DimensionManager.getWorld((int)entryCoordinate.getDimension())) == null || !WorldTools.chunkLoaded((World)world, (BlockPos)(c = entryCoordinate.getCoordinate()))) continue;
            boolean removeArea = true;
            TileEntity te = world.func_175625_s(c);
            if (te instanceof EnvironmentalControllerTileEntity) {
                EnvironmentalControllerTileEntity controllerTileEntity = (EnvironmentalControllerTileEntity)te;
                for (EnvironmentModule module : controllerTileEntity.getEnvironmentModules()) {
                    if (!(module instanceof PeacefulEModule) || !((PeacefulEModule)module).isActive()) continue;
                    removeArea = false;
                    break;
                }
            }
            if (!removeArea) continue;
            toRemove.add(entryCoordinate);
        }
        for (GlobalCoordinate globalCoordinate : toRemove) {
            areas.remove(globalCoordinate);
        }
        return peaceful;
    }

    public static class PeacefulArea {
        private float sqradius;
        private int miny;
        private int maxy;
        private long lastTouched;

        public PeacefulArea(float radius, int miny, int maxy) {
            this.sqradius = radius * radius;
            this.miny = miny;
            this.maxy = maxy;
            this.touch();
        }

        public PeacefulArea setArea(float radius, int miny, int maxy) {
            this.sqradius = radius * radius;
            this.miny = miny;
            this.maxy = maxy;
            return this;
        }

        public String toString() {
            return "PeacefulArea{sqradius=" + this.sqradius + ", miny=" + this.miny + ", maxy=" + this.maxy + ", lastTouched=" + this.lastTouched + '}';
        }

        public long getLastTouched() {
            return this.lastTouched;
        }

        public PeacefulArea touch() {
            this.lastTouched = System.currentTimeMillis();
            return this;
        }

        public boolean in(GlobalCoordinate coordinate, GlobalCoordinate thisCoordinate) {
            double pz;
            if (coordinate.getDimension() != thisCoordinate.getDimension()) {
                return false;
            }
            double py = coordinate.getCoordinate().func_177956_o();
            if (py < (double)this.miny || py > (double)this.maxy) {
                return false;
            }
            double px = coordinate.getCoordinate().func_177958_n() - thisCoordinate.getCoordinate().func_177958_n();
            double sqdist = px * px + (pz = (double)(coordinate.getCoordinate().func_177952_p() - thisCoordinate.getCoordinate().func_177952_p())) * pz;
            return sqdist < (double)this.sqradius;
        }
    }
}

