/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.endergen;

import mcjty.lib.thirteen.ConfigSpec;

public class EndergenicConfiguration {
    public static final String CATEGORY_ENDERGENIC = "endergenic";
    public static ConfigSpec.IntValue chanceLost;
    public static ConfigSpec.IntValue rfToHoldPearl;
    public static ConfigSpec.IntValue keepRfInBuffer;
    public static ConfigSpec.IntValue rfOutput;
    public static ConfigSpec.IntValue goodParticleCount;
    public static ConfigSpec.IntValue badParticleCount;
    public static ConfigSpec.DoubleValue powergenFactor;

    public static void init(ConfigSpec.Builder SERVER_BUILDER, ConfigSpec.Builder CLIENT_BUILDER) {
        SERVER_BUILDER.comment("Settings for the endergenic generator").push(CATEGORY_ENDERGENIC);
        CLIENT_BUILDER.comment("Settings for the endergenic generator").push(CATEGORY_ENDERGENIC);
        chanceLost = SERVER_BUILDER.comment("The chance (in 1/10 percent, so 1000 = 100%) that an endergenic pearl is lost while trying to hold it").defineInRange("endergenicChanceLost", 5, 0, 1000);
        rfToHoldPearl = SERVER_BUILDER.comment("The amount of RF that is consumed every tick to hold the endergenic pearl").defineInRange("endergenicRfHolding", 500, 0, Integer.MAX_VALUE);
        keepRfInBuffer = SERVER_BUILDER.comment("The amount of RF that every endergenic will keep itself (so that it can hold pearls)").defineInRange("endergenicKeepRf", 2000, 0, Integer.MAX_VALUE);
        rfOutput = SERVER_BUILDER.comment("The amount of RF per tick that this generator can give from its internal buffer to adjacent blocks").defineInRange("endergenicRfOutput", 20000, 0, Integer.MAX_VALUE);
        goodParticleCount = SERVER_BUILDER.comment("The amount of particles to spawn whenever energy is generated (use 0 to disable)").defineInRange("endergenicGoodParticles", 10, 0, 1000);
        badParticleCount = SERVER_BUILDER.comment("The amount of particles to spawn whenever a pearl is lost (use 0 to disable)").defineInRange("endergenicBadParticles", 10, 0, 1000);
        powergenFactor = SERVER_BUILDER.comment("Multiplier for power generation").defineInRange("powergenFactor", 2.0, 0.0, 1.0E9);
        SERVER_BUILDER.pop();
        CLIENT_BUILDER.pop();
    }
}

