/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.handler;

import com.therandomlabs.randomportals.api.config.ActivationData;
import com.therandomlabs.randomportals.api.config.PortalTypes;
import com.therandomlabs.randomportals.api.netherportal.NetherPortal;
import com.therandomlabs.randomportals.api.netherportal.NetherPortalActivator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public final class NetherPortalActivationHandler {
    private static final NetherPortalActivator PORTAL_ACTIVATOR = new NetherPortalActivator().setActivationDelayed(true);
    private static final Map<BlockPos, EntityPlayer> potentialFirePositions = new HashMap<BlockPos, EntityPlayer>();
    private static final List<DelayedActivation> delayedActivations = new ArrayList<DelayedActivation>();

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        ItemStack stack = event.getItemStack();
        BlockPos pos = event.getPos();
        EntityPlayer player = event.getEntityPlayer();
        EnumFacing face = event.getFace();
        if (face == null) {
            return;
        }
        BlockPos portalPos = pos.func_177972_a(face);
        if (stack.func_77973_b() == Items.field_151033_d) {
            potentialFirePositions.put(portalPos, player);
        }
        if (!(PortalTypes.getValidActivators().test(stack) && PortalTypes.getValidBlocks().test(world, pos, world.func_180495_p(pos)) && player.func_175151_a(pos, face, stack))) {
            return;
        }
        NetherPortal portal = PORTAL_ACTIVATOR.activate(world, portalPos, stack);
        if (portal == null) {
            return;
        }
        event.setCanceled(true);
        event.setCancellationResult(EnumActionResult.SUCCESS);
        if (world.field_72995_K) {
            return;
        }
        ActivationData activation = portal.getType().activation;
        ActivationData.ConsumeBehavior behavior = activation.activatorConsumeBehavior;
        if (!player.field_71075_bZ.field_75098_d) {
            if (behavior == ActivationData.ConsumeBehavior.CONSUME) {
                stack.func_190918_g(1);
            } else if (behavior == ActivationData.ConsumeBehavior.DAMAGE) {
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
        }
        if (activation.spawnFireBeforeActivating) {
            world.func_180501_a(portalPos, Blocks.field_150480_ab.func_176223_P(), 2);
            return;
        }
        DelayedActivation delayedActivation = delayedActivations.remove(delayedActivations.size() - 1);
        for (BlockPos portalPosition : delayedActivation.portalPositions) {
            world.func_180501_a(portalPosition, delayedActivation.portalState, 2);
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        for (DelayedActivation delayedActivation : delayedActivations) {
            if (delayedActivation.world != event.world) continue;
            for (BlockPos portalPosition : delayedActivation.portalPositions) {
                event.world.func_180501_a(portalPosition, delayedActivation.portalState, 2);
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            potentialFirePositions.clear();
            delayedActivations.clear();
        }
    }

    public static EntityPlayer getPotentialFireActivator(BlockPos pos) {
        return potentialFirePositions.get(pos);
    }

    public static void queueDelayedActivation(World world, List<BlockPos> portalPositions, IBlockState portalState) {
        delayedActivations.add(new DelayedActivation(world, portalPositions, portalState));
    }

    public static boolean isDelayedActivationQueued(World world, BlockPos pos) {
        for (DelayedActivation delayedActivation : delayedActivations) {
            if (delayedActivation.world != world || !delayedActivation.portalPositions.contains(pos)) continue;
            return true;
        }
        return false;
    }

    private static class DelayedActivation {
        final World world;
        final List<BlockPos> portalPositions;
        final IBlockState portalState;

        DelayedActivation(World world, List<BlockPos> portalPositions, IBlockState portalState) {
            this.world = world;
            this.portalPositions = portalPositions;
            this.portalState = portalState;
        }
    }
}

