/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.frame.endportal;

import com.therandomlabs.randomportals.api.config.FrameSize;
import com.therandomlabs.randomportals.api.frame.Frame;
import com.therandomlabs.randomportals.api.frame.FrameType;
import com.therandomlabs.randomportals.api.frame.detector.SidedFrameDetector;
import com.therandomlabs.randomportals.block.RPOBlocks;
import com.therandomlabs.randomportals.frame.endportal.EndPortalFrames;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEndPortalFrame;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public final class VerticalInwardsEndPortalDetector
extends SidedFrameDetector {
    VerticalInwardsEndPortalDetector() {
        super(FrameType.VERTICAL);
    }

    @Override
    public Function<FrameType, FrameSize> getDefaultSize() {
        return EndPortalFrames.VERTICAL_INWARDS_FACING_SIZE;
    }

    @Override
    protected boolean test(Frame frame) {
        return true;
    }

    @Override
    protected boolean testTop(FrameType type, BlockPos pos, IBlockState state, int position) {
        return this.test(type, state, (Block)RPOBlocks.upside_down_end_portal_frame, null, null);
    }

    @Override
    protected boolean testRight(FrameType type, BlockPos pos, IBlockState state, int position) {
        return this.test(type, state, (Block)RPOBlocks.vertical_end_portal_frame, EnumFacing.WEST, EnumFacing.SOUTH);
    }

    @Override
    protected boolean testBottom(FrameType type, BlockPos pos, IBlockState state, int position) {
        return this.test(type, state, Blocks.field_150378_br, null, null);
    }

    @Override
    protected boolean testLeft(FrameType type, BlockPos pos, IBlockState state, int position) {
        return this.test(type, state, (Block)RPOBlocks.vertical_end_portal_frame, EnumFacing.EAST, EnumFacing.NORTH);
    }

    private boolean test(FrameType type, IBlockState state, Block block, EnumFacing facingX, EnumFacing facingY) {
        boolean result;
        boolean bl = result = state.func_177230_c() == block && (Boolean)state.func_177229_b((IProperty)BlockEndPortalFrame.field_176507_b) != false;
        if (facingX == null) {
            return result;
        }
        EnumFacing facing = type == FrameType.VERTICAL_X ? facingX : facingY;
        return result && state.func_177229_b((IProperty)BlockHorizontal.field_185512_D) == facing;
    }
}

