/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.frame;

import com.therandomlabs.randomportals.api.config.PortalTypes;
import com.therandomlabs.randomportals.api.frame.Frame;
import com.therandomlabs.randomportals.api.frame.FrameDetector;
import com.therandomlabs.randomportals.api.frame.FrameType;
import com.therandomlabs.randomportals.api.frame.RequiredCorner;
import com.therandomlabs.randomportals.api.frame.detector.BasicFrameDetector;
import com.therandomlabs.randomportals.api.netherportal.PortalBlockRegistry;
import com.therandomlabs.randomportals.api.util.FrameStatePredicate;
import com.therandomlabs.randomportals.block.BlockNetherPortal;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class NetherPortalFrames {
    public static final FrameDetector FRAMES = new BasicFrameDetector(PortalTypes::getMaximumSize, PortalTypes::getValidBlocks, RequiredCorner.ANY, frame -> true, (world, pos, state, type) -> true);
    public static final FrameDetector EMPTY_FRAMES = new BasicFrameDetector(PortalTypes::getMaximumSize, PortalTypes::getValidBlocks, RequiredCorner.ANY, frame -> frame.testInnerBlocks(NetherPortalFrames::isEmpty), NetherPortalFrames::isEmpty);
    public static final FrameDetector ACTIVATED_FRAMES = new BasicFrameDetector(PortalTypes::getMaximumSize, PortalTypes::getValidBlocks, RequiredCorner.ANY, NetherPortalFrames::isActivated, PortalBlockRegistry::isPortal);

    private NetherPortalFrames() {
    }

    public static boolean isEmpty(World world, BlockPos pos, IBlockState state, FrameType type) {
        BlockNetherPortal portalBlock;
        Material material = state.func_185904_a();
        if (material == Material.field_151579_a || material == Material.field_151581_o) {
            return true;
        }
        Block block = state.func_177230_c();
        if (block instanceof BlockNetherPortal && (portalBlock = (BlockNetherPortal)block).getEffectiveAxis(state) == type.getAxis()) {
            return true;
        }
        return block.func_176200_f((IBlockAccess)world, pos);
    }

    public static boolean isActivated(Frame frame) {
        return NetherPortalFrames.isActivated(frame, BlockNetherPortal.Matcher::ofType);
    }

    public static boolean isActivated(Frame frame, FrameStatePredicate lateralPortal, FrameStatePredicate verticalXPortal, FrameStatePredicate verticalZPortal) {
        return NetherPortalFrames.isActivated(frame, type -> type.get(lateralPortal, verticalXPortal, verticalZPortal));
    }

    public static boolean isActivated(Frame frame, Function<FrameType, FrameStatePredicate> portalFunction) {
        FrameType type = frame.getType();
        FrameStatePredicate portal = portalFunction.apply(type);
        World world = frame.getWorld();
        for (BlockPos pos : frame.getInnerBlockPositions()) {
            if (portal.test(world, pos, world.func_180495_p(pos), type)) continue;
            return false;
        }
        return true;
    }
}

