/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.block;

import com.therandomlabs.randomportals.api.config.FrameSize;
import com.therandomlabs.randomportals.api.event.EndPortalEvent;
import com.therandomlabs.randomportals.api.frame.Frame;
import com.therandomlabs.randomportals.api.frame.FrameDetector;
import com.therandomlabs.randomportals.api.frame.FrameType;
import com.therandomlabs.randomportals.api.util.FrameStatePredicate;
import com.therandomlabs.randomportals.block.RPOBlocks;
import com.therandomlabs.randomportals.frame.endportal.EndPortalFrames;
import com.therandomlabs.randomportals.handler.EndPortalActivationHandler;
import com.therandomlabs.randomportals.world.storage.RPOSavedData;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEndPortal;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlockLateralEndPortal
extends BlockEndPortal {
    public BlockLateralEndPortal() {
        this("minecraft:end_portal");
    }

    protected BlockLateralEndPortal(String registryName) {
        super(Material.field_151567_E);
        this.func_149711_c(-1.0f);
        this.func_149752_b(6000000.0f);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149663_c("endPortalLateral");
        this.setRegistryName(registryName);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (world.field_72995_K || entity.func_184218_aH() || entity.func_184207_aI() || !entity.func_184222_aU()) {
            return;
        }
        AxisAlignedBB aabb = entity.func_174813_aQ();
        if (!aabb.func_72326_a(state.func_185900_c((IBlockAccess)world, pos).func_186670_a(pos))) {
            return;
        }
        Frame frame = BlockLateralEndPortal.findFrame(world, pos);
        if (MinecraftForge.EVENT_BUS.post((Event)new EndPortalEvent.Teleport.Pre(frame, entity, pos))) {
            return;
        }
        if (world.field_73011_w.func_186058_p() == DimensionType.THE_END) {
            entity.func_184204_a(DimensionType.OVERWORLD.func_186068_a());
        } else {
            entity.func_184204_a(DimensionType.THE_END.func_186068_a());
        }
        MinecraftForge.EVENT_BUS.post((Event)new EndPortalEvent.Teleport.Post(frame, entity, pos));
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        boolean actuallyRemoved = super.removedByPlayer(state, world, pos, player, willHarvest);
        if (actuallyRemoved && !world.field_72995_K) {
            RPOSavedData.get(world).removeEndPortalByInner(pos);
        }
        return actuallyRemoved;
    }

    public static Frame findFrame(World world, BlockPos portalPos) {
        FrameType type;
        EnumFacing frameDirection;
        FrameStatePredicate portalMatcher;
        EnumFacing facing;
        RPOSavedData savedData = RPOSavedData.get(world);
        Frame frame = savedData.getEndPortalByInner(portalPos);
        if (frame != null) {
            return frame;
        }
        IBlockState state = world.func_180495_p(portalPos);
        Block block = state.func_177230_c();
        if (block == Blocks.field_150384_bq || block == RPOBlocks.upside_down_end_portal) {
            facing = null;
            portalMatcher = FrameStatePredicate.of(block);
            frameDirection = EnumFacing.NORTH;
            type = FrameType.LATERAL;
        } else {
            facing = (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
            portalMatcher = FrameStatePredicate.of(block).with(BlockHorizontal.field_185512_D, facing);
            frameDirection = EnumFacing.DOWN;
            type = facing.func_176740_k() == EnumFacing.Axis.X ? FrameType.VERTICAL_Z : FrameType.VERTICAL_X;
        }
        int maxSize = 0;
        for (Function sizeFunction : EndPortalFrames.SIZES) {
            int size;
            FrameSize frameSize = (FrameSize)sizeFunction.apply(type);
            if (frameSize == null || (size = frameSize.getMaxSize(frameDirection == EnumFacing.DOWN)) <= maxSize) continue;
            maxSize = size;
        }
        BlockPos framePos = null;
        Block frameBlock = null;
        BlockPos checkPos = portalPos;
        for (int offset = 1; offset < maxSize - 1; ++offset) {
            IBlockState checkState = world.func_180495_p(checkPos = checkPos.func_177972_a(frameDirection));
            frameBlock = checkState.func_177230_c();
            if (EndPortalActivationHandler.isFrameBlock(frameBlock)) {
                framePos = checkPos;
                break;
            }
            if (!portalMatcher.test(world, checkPos, checkState)) break;
        }
        if (framePos == null) {
            return null;
        }
        Predicate<Frame> condition = potentialFrame -> potentialFrame.isInnerBlock(portalPos);
        frame = frameBlock == Blocks.field_150378_br ? EndPortalFrames.LATERAL.detectWithCondition(world, framePos, condition) : (frameBlock == RPOBlocks.vertical_end_portal_frame ? EndPortalFrames.LATERAL_WITH_VERTICAL_FRAMES.detectWithCondition(world, framePos, condition) : EndPortalFrames.UPSIDE_DOWN.detectWithCondition(world, framePos, condition));
        if (frame != null) {
            savedData.addEndPortal(frame);
            return frame;
        }
        if (frameBlock == RPOBlocks.vertical_end_portal_frame && (frame = ((FrameDetector)EndPortalFrames.VERTICAL.get((Object)facing)).detectWithCondition(world, framePos, condition)) != null) {
            savedData.addEndPortal(frame);
            return frame;
        }
        frame = EndPortalFrames.VERTICAL_INWARDS_FACING.detectWithCondition(world, framePos, condition);
        if (frame != null) {
            savedData.addEndPortal(frame);
        }
        return frame;
    }
}

