/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.api.config;

import com.therandomlabs.randomportals.api.config.EntitySpawns;
import com.therandomlabs.randomportals.api.config.PortalType;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public final class PortalTypeGroup {
    public boolean blacklistAllUndefinedDimensions = true;
    public int[] activationDimensionIDBlacklist = new int[0];
    public int defaultDimensionID;
    public Map<Integer, EntitySpawns> entitySpawns = new HashMap<Integer, EntitySpawns>();
    public transient Map<Integer, PortalType> types = new HashMap<Integer, PortalType>();
    transient String id = "unknown_portal";

    public PortalTypeGroup() {
        this(null);
    }

    public PortalTypeGroup(String id) {
        if (id != null) {
            this.id = id;
        }
        this.entitySpawns.put(0, new EntitySpawns());
    }

    public String toString() {
        return this.id;
    }

    public void ensureCorrect() {
        this.entitySpawns.values().forEach(EntitySpawns::ensureCorrect);
    }

    public boolean isValid() {
        return this.types.containsKey(this.defaultDimensionID);
    }

    public boolean canActivateInDimension(int dimensionID) {
        if (this.blacklistAllUndefinedDimensions) {
            if (this.types.containsKey(dimensionID)) {
                return true;
            }
            for (PortalType type : this.types.values()) {
                if (type.destination.dimensionID != dimensionID) continue;
                return true;
            }
            return false;
        }
        return !ArrayUtils.contains((int[])this.activationDimensionIDBlacklist, (int)dimensionID);
    }

    public PortalType getType(int dimensionID) {
        PortalType type = this.types.get(dimensionID);
        return type == null ? this.getDefaultType() : type;
    }

    public PortalType getDefaultType() {
        return this.types.get(this.defaultDimensionID);
    }
}

