/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.api.config;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;

public final class FrameBlock {
    private static final IForgeRegistry<Block> BLOCK_REGISTRY = GameRegistry.findRegistry(Block.class);
    public String registryName;
    public int meta = Short.MAX_VALUE;
    public int minimumAmount;
    private transient boolean blockRetrieved;
    private transient Block block;
    private transient FrameBlock[] blocks;

    public FrameBlock() {
    }

    public FrameBlock(Block block) {
        this(block, 0);
    }

    public FrameBlock(Block block, int minimumAmount) {
        this(block, Short.MAX_VALUE, minimumAmount);
    }

    public FrameBlock(Block block, int meta, int minimumAmount) {
        this.registryName = block.getRegistryName().toString();
        this.meta = meta;
        this.minimumAmount = minimumAmount;
        this.blockRetrieved = true;
        this.block = block;
        this.blocks = new FrameBlock[]{this};
    }

    public String toString() {
        return "FrameBlock[registryName=" + this.registryName + ",meta=" + this.meta + ",minimumAmount=" + this.minimumAmount + "]";
    }

    public Block getBlock() {
        if (!this.blockRetrieved && !this.registryName.startsWith("ore:")) {
            this.block = (Block)BLOCK_REGISTRY.getValue(new ResourceLocation(this.registryName));
            if (this.block == Blocks.field_150350_a) {
                this.block = null;
            } else if (this.block != null) {
                this.registryName = this.block.getRegistryName().toString();
            }
            this.blockRetrieved = true;
        }
        return this.block;
    }

    public FrameBlock getActualBlock() {
        return this.getBlocks().length == 0 ? null : this.blocks[0];
    }

    public IBlockState getActualState() {
        FrameBlock block = this.getActualBlock();
        if (block == null) {
            return null;
        }
        if (block.meta == Short.MAX_VALUE) {
            return block.getBlock().func_176223_P();
        }
        return block.getBlock().func_176203_a(block.meta);
    }

    public boolean isValid() {
        return this.getBlocks().length != 0;
    }

    public void ensureCorrect() {
        if (this.minimumAmount < 0) {
            this.minimumAmount = 0;
        }
    }

    public boolean test(IBlockState state) {
        Block block = state.func_177230_c();
        int meta = block.func_176201_c(state);
        for (FrameBlock frameBlock : this.getBlocks()) {
            if (frameBlock.getBlock() != block || frameBlock.meta != Short.MAX_VALUE && frameBlock.meta != meta) continue;
            return true;
        }
        return false;
    }

    private FrameBlock[] getBlocks() {
        if (this.blocks != null) {
            return this.blocks;
        }
        if (!this.registryName.startsWith("ore:")) {
            if (this.getBlock() == null) {
                this.blocks = new FrameBlock[0];
                return this.blocks;
            }
            this.blocks = new FrameBlock[]{this};
            return this.blocks;
        }
        NonNullList ores = OreDictionary.getOres((String)this.registryName.substring(4));
        if (ores.isEmpty()) {
            this.blocks = new FrameBlock[0];
            return this.blocks;
        }
        ArrayList<FrameBlock> blocks = new ArrayList<FrameBlock>(ores.size());
        for (ItemStack ore : ores) {
            Item item = ore.func_77973_b();
            if (!(item instanceof ItemBlock)) continue;
            blocks.add(new FrameBlock(((ItemBlock)item).func_179223_d(), ore.func_77960_j()));
        }
        this.blocks = blocks.toArray(new FrameBlock[0]);
        return this.blocks;
    }
}

