/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.api.config;

import com.therandomlabs.randomportals.api.config.SpawnRate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.EntityList;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.ArrayUtils;

public final class EntitySpawns {
    public int rate = 2000;
    public Map<String, SpawnRate> entities = new HashMap<String, SpawnRate>();
    public transient double totalWeight;

    public EntitySpawns() {
        this.entities.put("minecraft:zombie_pigman", new SpawnRate());
    }

    public void ensureCorrect() {
        if (this.rate < 3) {
            this.rate = 2000;
        }
        HashMap<String, SpawnRate> newEntities = new HashMap<String, SpawnRate>(this.entities.size());
        Object[] entityNames = EntityList.func_180124_b().toArray(new ResourceLocation[0]);
        this.totalWeight = 0.0;
        ArrayList<String> registryNames = new ArrayList<String>(this.entities.keySet());
        ArrayList<SpawnRate> spawnRates = new ArrayList<SpawnRate>(this.entities.values());
        for (int i = 0; i < registryNames.size(); ++i) {
            int index = ArrayUtils.indexOf((Object[])entityNames, (Object)new ResourceLocation((String)registryNames.get(i)));
            if (index == -1) continue;
            String key = entityNames[index].toString();
            SpawnRate spawnRate = (SpawnRate)spawnRates.get(i);
            spawnRate.key = key;
            this.totalWeight += spawnRate.weight;
            newEntities.put(key, spawnRate);
        }
        this.entities = newEntities;
    }

    public SpawnRate getRandom(Random random) {
        double result = random.nextDouble() * this.totalWeight;
        double weight = 0.0;
        for (SpawnRate spawnRate : this.entities.values()) {
            if (!((weight += spawnRate.weight) >= result)) continue;
            return spawnRate;
        }
        return null;
    }
}

