/*
 * Decompiled with CFR 0.152.
 */
package presents.common.misc;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemLingeringPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class PotionHelper {
    public static void spawnPotion(ItemStack stack, World world, BlockPos pos) {
        if (!world.field_72995_K) {
            PotionType potionType = PotionUtils.func_185191_c((ItemStack)stack);
            List potionEffectList = PotionUtils.func_185189_a((ItemStack)stack);
            AxisAlignedBB boundingBox = new AxisAlignedBB((double)pos.func_177958_n() + 0.5 - 2.0, (double)pos.func_177956_o() + 0.5 - 1.0, (double)pos.func_177952_p() + 0.5 - 2.0, (double)pos.func_177958_n() + 0.5 + 2.0, (double)pos.func_177956_o() + 0.5 + 1.0, (double)pos.func_177952_p() + 0.5 + 2.0);
            if (potionType == PotionTypes.field_185230_b && potionEffectList.isEmpty()) {
                List entities = world.func_175647_a(EntityLivingBase.class, boundingBox, EntityPotion.field_190546_d);
                if (!entities.isEmpty()) {
                    for (EntityLivingBase entity : entities) {
                        if (!(pos.func_177954_c(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v) < 16.0) || !(entity instanceof EntityEnderman) && !(entity instanceof EntityBlaze)) continue;
                        entity.func_70097_a(DamageSource.field_76369_e, 1.0f);
                    }
                }
            } else if (!potionEffectList.isEmpty()) {
                PotionHelper.doPotionEffects(world, pos, stack, potionType, potionEffectList);
            }
            world.func_175718_b(potionType.func_185172_c() ? 2007 : 2002, pos, PotionUtils.func_190932_c((ItemStack)stack));
        }
    }

    private static void doPotionEffects(World world, BlockPos pos, ItemStack stack, PotionType potionType, List<PotionEffect> potionEffectList) {
        if (stack.func_77973_b() instanceof ItemLingeringPotion) {
            EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            entityareaeffectcloud.func_184483_a(3.0f);
            entityareaeffectcloud.func_184495_b(-0.5f);
            entityareaeffectcloud.func_184485_d(10);
            entityareaeffectcloud.func_184487_c(-entityareaeffectcloud.func_184490_j() / (float)entityareaeffectcloud.func_184489_o());
            entityareaeffectcloud.func_184484_a(potionType);
            for (PotionEffect potioneffect : PotionUtils.func_185190_b((ItemStack)stack)) {
                entityareaeffectcloud.func_184496_a(new PotionEffect(potioneffect));
            }
            NBTTagCompound nbttagcompound = stack.func_77978_p();
            if (nbttagcompound != null && nbttagcompound.func_150297_b("CustomPotionColor", 99)) {
                entityareaeffectcloud.func_184482_a(nbttagcompound.func_74762_e("CustomPotionColor"));
            }
            world.func_72838_d((Entity)entityareaeffectcloud);
        } else {
            List entities = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)pos.func_177958_n() + 0.5 - 2.0, (double)pos.func_177956_o() + 0.5 - 1.0, (double)pos.func_177952_p() + 0.5 - 2.0, (double)pos.func_177958_n() + 0.5 + 2.0, (double)pos.func_177956_o() + 0.5 + 1.0, (double)pos.func_177952_p() + 0.5 + 2.0));
            for (EntityLivingBase entity : entities) {
                double distance = pos.func_177954_c(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                if (!entity.func_184603_cC() || !(distance < 16.0)) continue;
                double health = 1.0 - Math.sqrt(distance) / 4.0;
                for (PotionEffect potioneffect : potionEffectList) {
                    Potion potion = potioneffect.func_188419_a();
                    if (potion.func_76403_b()) {
                        potion.func_180793_a(null, null, entity, potioneffect.func_76458_c(), health);
                        continue;
                    }
                    int time = (int)(health * (double)potioneffect.func_76459_b() + 0.5);
                    if (time <= 20) continue;
                    entity.func_70690_d(new PotionEffect(potion, time, potioneffect.func_76458_c(), potioneffect.func_82720_e(), potioneffect.func_188418_e()));
                }
            }
        }
    }
}

