/*
 * Decompiled with CFR 0.152.
 */
package presents.common.item.recipe;

import java.util.ArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.DyeUtils;
import net.minecraftforge.registries.IForgeRegistryEntry;
import presents.common.block.BlockPresent;
import presents.common.block.BlockPresentEmpty;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RecipePresentDye
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public RecipePresentDye() {
        this.setRegistryName("recipe_present_dye");
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        ItemStack presentStack = ItemStack.field_190927_a;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockPresentEmpty) {
                presentStack = stack;
                continue;
            }
            if (!DyeUtils.isDye((ItemStack)stack)) {
                return false;
            }
            list.add(stack);
        }
        return !presentStack.func_190926_b() && !list.isEmpty();
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack presentStack = ItemStack.field_190927_a;
        int[] colorValues = new int[3];
        int largestValueSum = 0;
        int dyeAmount = 0;
        for (int k = 0; k < inv.func_70302_i_(); ++k) {
            ItemStack stack = inv.func_70301_a(k);
            if (stack.func_190926_b()) continue;
            if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockPresentEmpty) {
                presentStack = stack.func_77946_l();
                presentStack.func_190920_e(1);
                int colour = RecipePresentDye.getColor(presentStack);
                if (colour == 0xF9FFFE) continue;
                float red = (float)(colour >> 16 & 0xFF) / 255.0f;
                float green = (float)(colour >> 8 & 0xFF) / 255.0f;
                float blue = (float)(colour & 0xFF) / 255.0f;
                largestValueSum = (int)((float)largestValueSum + Math.max(red, Math.max(green, blue)) * 255.0f);
                colorValues[0] = (int)((float)colorValues[0] + red * 255.0f);
                colorValues[1] = (int)((float)colorValues[1] + green * 255.0f);
                colorValues[2] = (int)((float)colorValues[2] + blue * 255.0f);
                ++dyeAmount;
                continue;
            }
            if (!DyeUtils.isDye((ItemStack)stack)) {
                return ItemStack.field_190927_a;
            }
            float[] afloat = ((EnumDyeColor)DyeUtils.colorFromStack((ItemStack)stack).get()).func_193349_f();
            int red = (int)(afloat[0] * 255.0f);
            int green = (int)(afloat[1] * 255.0f);
            int blue = (int)(afloat[2] * 255.0f);
            largestValueSum += Math.max(red, Math.max(green, blue));
            colorValues[0] = colorValues[0] + red;
            colorValues[1] = colorValues[1] + green;
            colorValues[2] = colorValues[2] + blue;
            ++dyeAmount;
        }
        if (presentStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int red = colorValues[0] / dyeAmount;
        int green = colorValues[1] / dyeAmount;
        int blue = colorValues[2] / dyeAmount;
        float f3 = (float)largestValueSum / (float)dyeAmount;
        float largestValue = Math.max(red, Math.max(green, blue));
        red = (int)((float)red * f3 / largestValue);
        green = (int)((float)green * f3 / largestValue);
        blue = (int)((float)blue * f3 / largestValue);
        int color = (red << 8) + green;
        color = (color << 8) + blue;
        RecipePresentDye.setColor(presentStack, color);
        return presentStack;
    }

    private static int getColor(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null && compound.func_74764_b("BlockEntityTag")) {
            compound = compound.func_74775_l("BlockEntityTag");
            if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockPresent) {
                return compound.func_74764_b("RibbonColor") ? compound.func_74762_e("RibbonColor") : 0xF9FFFE;
            }
            if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockPresentEmpty) {
                return compound.func_74764_b("Color") ? compound.func_74762_e("Color") : 0xF9FFFE;
            }
        }
        return 0xF9FFFE;
    }

    private static void setColor(ItemStack stack, int color) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null) {
            if (!compound.func_74764_b("BlockEntityTag")) {
                compound.func_74782_a("BlockEntityTag", (NBTBase)new NBTTagCompound());
            }
        } else {
            compound = new NBTTagCompound();
            stack.func_77982_d(compound);
            compound.func_74782_a("BlockEntityTag", (NBTBase)new NBTTagCompound());
        }
        compound = compound.func_74775_l("BlockEntityTag");
        if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockPresent) {
            compound.func_74768_a("RibbonColor", color);
        } else if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockPresentEmpty) {
            compound.func_74768_a("Color", color);
        }
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList list = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            list.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return list;
    }

    public boolean func_192399_d() {
        return true;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }
}

