/*
 * Decompiled with CFR 0.152.
 */
package presents.client.entity;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import presents.common.entity.EntityPresentPrimed;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class RenderPresentPrimed
extends Render<EntityPresentPrimed> {
    public static final Factory FACTORY = new Factory();
    private static final ResourceLocation TEXTURES = new ResourceLocation("presents", "textures/entity/present_primed.png");
    private final ModelBase MODEL = new ModelPresentPrimed();

    @Nullable
    protected ResourceLocation getEntityTexture(EntityPresentPrimed entity) {
        return TEXTURES;
    }

    private RenderPresentPrimed(RenderManager rendermanager) {
        super(rendermanager);
        this.field_76989_e = 0.4f;
    }

    public void doRender(EntityPresentPrimed entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.func_179094_E();
        this.func_180548_c((Entity)entity);
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        if ((float)entity.func_184536_l() - partialTicks + 1.0f < 10.0f) {
            float f = 1.0f - ((float)entity.func_184536_l() - partialTicks + 1.0f) / 10.0f;
            f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
            f *= f;
            f *= f;
            float f1 = 1.0f + f * 0.3f;
            GlStateManager.func_179152_a((float)f1, (float)f1, (float)f1);
        }
        float f2 = (1.0f - ((float)entity.func_184536_l() - partialTicks + 1.0f) / 100.0f) * 0.8f;
        this.MODEL.func_78088_a((Entity)entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        if (entity.func_184536_l() / 5 % 2 == 0) {
            GlStateManager.func_179090_x();
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.DST_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)f2);
            GlStateManager.func_179136_a((float)-3.0f, (float)-3.0f);
            GlStateManager.func_179088_q();
            this.MODEL.func_78088_a((Entity)entity, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
            GlStateManager.func_179113_r();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            GlStateManager.func_179098_w();
        }
        GlStateManager.func_179121_F();
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
    }

    private static class ModelPresentPrimed
    extends ModelBase {
        private final ModelRenderer box;
        private final ModelRenderer boxRibbon;
        private final ModelRenderer lid;
        private final ModelRenderer lidRibbon;
        private final ModelRenderer ribbon1;
        private final ModelRenderer ribbon2;

        ModelPresentPrimed() {
            this.field_78090_t = 128;
            this.field_78089_u = 64;
            this.box = new ModelRenderer((ModelBase)this, 0, 0);
            this.boxRibbon = new ModelRenderer((ModelBase)this, 0, 20);
            this.lid = new ModelRenderer((ModelBase)this, 40, 0);
            this.lidRibbon = new ModelRenderer((ModelBase)this, 40, 15);
            this.ribbon1 = new ModelRenderer((ModelBase)this, 0, 40);
            this.ribbon2 = new ModelRenderer((ModelBase)this, 0, 40);
            this.box.func_78789_a(-5.0f, 0.0f, -5.0f, 10, 10, 10);
            this.boxRibbon.func_78789_a(-5.0f, 0.0f, -5.0f, 10, 10, 10);
            this.lid.func_78789_a(-6.0f, 8.0f, -6.0f, 12, 3, 12);
            this.lidRibbon.func_78789_a(-6.0f, 8.0f, -6.0f, 12, 3, 12);
            this.ribbon1.func_78789_a(-8.0f, 11.0f, 0.0f, 16, 4, 0);
            this.ribbon2.func_78789_a(-8.0f, 11.0f, 0.0f, 16, 4, 0);
        }

        public void func_78088_a(@Nullable Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            float[] c1;
            GlStateManager.func_179094_E();
            float[] c2 = c1 = EnumDyeColor.WHITE.func_193349_f();
            if (entity instanceof EntityPresentPrimed) {
                int color = ((EntityPresentPrimed)entity).getColor();
                int r = (color & 0xFF0000) >> 16;
                int g = (color & 0xFF00) >> 8;
                int b = color & 0xFF;
                c1 = new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
                color = ((EntityPresentPrimed)entity).getRibbonColor();
                r = (color & 0xFF0000) >> 16;
                g = (color & 0xFF00) >> 8;
                b = color & 0xFF;
                c2 = new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
            }
            GlStateManager.func_179124_c((float)c1[0], (float)c1[1], (float)c1[2]);
            this.box.func_78785_a(scale);
            if (limbSwing == 0.0f) {
                GlStateManager.func_179124_c((float)c2[0], (float)c2[1], (float)c2[2]);
                this.boxRibbon.func_78785_a(scale);
            }
            GlStateManager.func_179152_a((float)0.9166667f, (float)1.0f, (float)0.9166667f);
            GlStateManager.func_179124_c((float)c1[0], (float)c1[1], (float)c1[2]);
            this.lid.func_78785_a(scale);
            if (limbSwing == 0.0f) {
                GlStateManager.func_179124_c((float)c2[0], (float)c2[1], (float)c2[2]);
                this.lidRibbon.func_78785_a(scale);
            }
            GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
            if (limbSwing == 0.0f) {
                GlStateManager.func_179124_c((float)c2[0], (float)c2[1], (float)c2[2]);
                GlStateManager.func_179139_a((double)Math.sqrt(2.0), (double)1.0, (double)Math.sqrt(2.0));
                GlStateManager.func_179140_f();
                GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                this.ribbon1.func_78785_a(scale);
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                this.ribbon2.func_78785_a(scale);
                GlStateManager.func_179145_e();
            }
            GlStateManager.func_179121_F();
        }
    }

    public static class Factory
    implements IRenderFactory<EntityPresentPrimed> {
        public Render<? super EntityPresentPrimed> createRenderFor(RenderManager manager) {
            return new RenderPresentPrimed(manager);
        }
    }
}

