/*
 * Decompiled with CFR 0.152.
 */
package presents;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import presents.common.CommonEventHandler;
import presents.common.CommonProxy;
import presents.common.block.BlockPresent;
import presents.common.block.BlockPresentEmpty;
import presents.common.item.recipe.RecipePresent;
import presents.common.item.recipe.RecipePresentDye;
import presents.common.tileentity.TileEntityPresent;

@Mod(modid="presents", name="Presents", version="1.12.2-1.3.4", updateJSON="https://github.com/ochotonida/presents/blob/master/update.json", acceptedMinecraftVersions="[1.12.2]")
public class Presents {
    public static final String MODID = "presents";
    public static final String MODNAME = "Presents";
    public static final String MODVERSION = "1.12.2-1.3.4";
    public static final Block PRESENT_BLOCK = new BlockPresent("present");
    public static final Block EMPTY_PRESENT_BLOCK = new BlockPresentEmpty("present_empty");
    public static final Item PRESENT_ITEM = (Item)new ItemBlock(PRESENT_BLOCK).setRegistryName("present");
    public static final Item EMPTY_PRESENT_ITEM = (Item)new ItemBlock(EMPTY_PRESENT_BLOCK).setRegistryName("present_empty");
    public static final ResourceLocation LOOTTABLE_PRESENT_REGULAR = new ResourceLocation("presents", "present_regular");
    public static final ResourceLocation LOOTTABLE_PRESENT_SPECIAL = new ResourceLocation("presents", "present_special");
    @Mod.Instance
    public static Presents instance;
    @SidedProxy(serverSide="presents.common.CommonProxy", clientSide="presents.client.ClientProxy")
    public static CommonProxy proxy;

    public Presents() {
        MinecraftForge.TERRAIN_GEN_BUS.register(CommonEventHandler.class);
        MinecraftForge.EVENT_BUS.register(CommonEventHandler.class);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit(event);
        LootTableList.func_186375_a((ResourceLocation)LOOTTABLE_PRESENT_REGULAR);
        LootTableList.func_186375_a((ResourceLocation)LOOTTABLE_PRESENT_SPECIAL);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
    }

    @Mod.EventBusSubscriber
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{PRESENT_BLOCK, EMPTY_PRESENT_BLOCK});
            GameRegistry.registerTileEntity(TileEntityPresent.class, (ResourceLocation)new ResourceLocation(Presents.MODID, "present"));
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{PRESENT_ITEM, EMPTY_PRESENT_ITEM});
        }

        @SubscribeEvent
        public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new IRecipe[]{new RecipePresent(), new RecipePresentDye()});
        }

        @SubscribeEvent
        public static void registerModels(ModelRegistryEvent event) {
            proxy.registerItemRenderers();
        }
    }
}

