/*
 * Decompiled with CFR 0.152.
 */
package us.bemrose.mc.pitweaks;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="pitweaks")
public class TweakConfig {
    @Config.Comment(value={"Tweaks to anvils"})
    public static AnvilTweakConfig anvil = new AnvilTweakConfig();
    @Config.Comment(value={"Tweaks to vanilla furnaces"})
    public static FurnaceTweakConfig furnace = new FurnaceTweakConfig();
    @Config.Comment(value={"Tweaks to vanilla brewing stands"})
    public static BrewingTweakConfig brewing = new BrewingTweakConfig();
    @Config.Comment(value={"Tweaks to vanilla boats"})
    public static BoatTweakConfig boats = new BoatTweakConfig();
    @Config.Comment(value={"Tweaks to recipes"})
    public static RecipeTweakConfig recipes = new RecipeTweakConfig();
    @Config.Comment(value={"Tweaks to mob spawning"})
    public static SpawnTweakConfig spawn = new SpawnTweakConfig();
    @Config.Comment(value={"Tweaks to players"})
    public static PlayerTweakConfig player = new PlayerTweakConfig();

    @Mod.EventBusSubscriber(modid="pitweaks")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("pitweaks")) {
                ConfigManager.sync((String)"pitweaks", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class PlayerTweakConfig {
        @Config.Comment(value={"Remove food cap that limits food value to 20. Useful with modded foods"})
        public boolean uncapFood = true;
        @Config.Comment(value={"Remove saturation cap that limits saturation to current food level"})
        public boolean uncapSaturation = false;
    }

    public static class SpawnTweakConfig {
        @Config.Comment(value={"Mobs can only spawn on full-cube blocks.  Prevents spawning on partial blocks like top-slabs, upside-down-stairs, and hoppers."})
        public boolean spawnRequiresFullCube = false;
    }

    public static class RecipeTweakConfig {
        @Config.Comment(value={"Enables 2x2 versions of stair and slab recipes, and adds recipes to recombine them into their base blocks."})
        @Config.RequiresMcRestart
        public boolean recipes2x2 = false;
        @Config.Comment(value={"Removes 3x3 version of slab and stair recipes when recipes2x2=true"})
        @Config.RequiresMcRestart
        public boolean remove3x3Recipes = false;
        @Config.Comment(value={"How to handle conflicts with 2x2 stone and wooden pressure plates when recipes2x2=true. 0 = do nothing (use another recipe mod like minetweaker).  1 = change plate recipes to use slabs."})
        @Config.RequiresMcRestart
        public int pressurePlateHandling = 0;
    }

    public static class BoatTweakConfig {
        @Config.Comment(value={"Boats float up flowing water instead of sinking.  If you toggle this, you must break and re-place any boats."})
        public boolean buoyantBoats = true;
        @Config.Comment(value={"Disables vanilla behavior of ejecting passengers from a boat after 3 seconds underwater. Requires buoyantBoats = true"})
        public boolean dontEjectPassengers = false;
    }

    public static class BrewingTweakConfig {
        @Config.Comment(value={"Brewing stands are faster.  If you toggle this, you must break and re-place any brewing stands."})
        public boolean fastBrewing = true;
        @Config.Comment(value={"Number of ticks to brew a potion.  Vanilla = 400."})
        @Config.RangeInt(min=1, max=400)
        public int brewTicks = 20;
    }

    public static class FurnaceTweakConfig {
        @Config.Comment(value={"Vanilla furnaces are faster.  If you toggle this, you must break and re-place any furnaces."})
        public boolean fastFurnace = true;
        @Config.Comment(value={"Cook speed multiplier. Time per item is (10/multiplier) seconds. Valid values (2,4,5,8,10,20,25,40,50,100)"})
        @Config.RangeInt(min=1, max=100)
        public int multiplier = 20;
    }

    public static class AnvilTweakConfig {
        @Config.Comment(value={"Removes additional cost from repairing/enchanting items in an anvil multiple times"})
        public boolean noRepairCost = true;
        @Config.Comment(value={"Allow books to be combined over the enchantment max level"})
        public boolean allowOverlevelBooks = true;
        @Config.Comment(value={"Always allow enchantments from books to be applied in an anvil, regardless of item type or other enchantments"})
        public boolean alwaysAllowBooks = false;
    }
}

