/*
 * Decompiled with CFR 0.152.
 */
package us.bemrose.mc.pitweaks;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import us.bemrose.mc.pitweaks.NullRecipe;
import us.bemrose.mc.pitweaks.Tweak;
import us.bemrose.mc.pitweaks.TweakConfig;

public class StairSlabTweak
extends Tweak {
    @Override
    public void postInit(FMLPostInitializationEvent event) {
        if (!TweakConfig.recipes.recipes2x2) {
            return;
        }
        System.out.println("PiStairSlab: Searching for stair/slab recipes");
        LinkedList<IRecipe> recipesToAdd = new LinkedList<IRecipe>();
        LinkedList<IRecipe> recipesToRemove = new LinkedList<IRecipe>();
        if (TweakConfig.recipes.pressurePlateHandling > 0) {
            ResourceLocation rl = new ResourceLocation("pitweaks:recipe_stone_pressure_plate");
            ShapedOreRecipe r = new ShapedOreRecipe(rl, Blocks.field_150456_au, new Object[]{"ss", Character.valueOf('s'), new ItemStack((Block)Blocks.field_150333_U, 1, 0)});
            r.setRegistryName(rl);
            recipesToAdd.add((IRecipe)r);
            rl = new ResourceLocation("pitweaks:recipe_wooden_pressure_plate");
            r = new ShapedOreRecipe(rl, Blocks.field_150452_aw, new Object[]{"ss", Character.valueOf('s'), "slabWood"});
            r.setRegistryName(rl);
            recipesToAdd.add((IRecipe)r);
        }
        for (IRecipe ir : ForgeRegistries.RECIPES) {
            if (ir instanceof ShapedRecipes) {
                ItemStack[] inputStacks;
                Ingredient input;
                ShapedRecipes sr = (ShapedRecipes)ir;
                if (sr.field_77574_d.size() <= 0 || (input = (Ingredient)sr.field_77574_d.get(0)).equals(Ingredient.field_193370_a) || (inputStacks = input.func_193365_a()).length <= 0 || !(inputStacks[0].func_77973_b() instanceof ItemBlock)) continue;
                if (sr.field_77576_b == 3 && sr.field_77577_c == 1 && ((Ingredient)sr.field_77574_d.get(1)).equals(input) && ((Ingredient)sr.field_77574_d.get(2)).equals(input)) {
                    StairSlabTweak.addSlabRecipe(input, sr.func_77571_b(), recipesToAdd);
                }
                if (sr.field_77576_b == 3 && sr.field_77577_c == 3 && ((Ingredient)sr.field_77574_d.get(1)).equals(Ingredient.field_193370_a) && ((Ingredient)sr.field_77574_d.get(2)).equals(Ingredient.field_193370_a) && ((Ingredient)sr.field_77574_d.get(3)).equals(input) && ((Ingredient)sr.field_77574_d.get(4)).equals(input) && ((Ingredient)sr.field_77574_d.get(5)).equals(Ingredient.field_193370_a) && ((Ingredient)sr.field_77574_d.get(6)).equals(input) && ((Ingredient)sr.field_77574_d.get(7)).equals(input) && ((Ingredient)sr.field_77574_d.get(8)).equals(input)) {
                    StairSlabTweak.addStairRecipe(input, sr.func_77571_b(), recipesToAdd);
                }
            }
            if (TweakConfig.recipes.pressurePlateHandling <= 0) continue;
            if (ir.func_77571_b().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150452_aw)) {
                System.out.println("PiStairSlab: Removing vanilla recipe for wooden pressure plate");
                recipesToRemove.add(ir);
            }
            if (ir.func_77571_b().func_77973_b() != Item.func_150898_a((Block)Blocks.field_150456_au)) continue;
            System.out.println("PiStairSlab: Removing vanilla recipe for stone pressure plate");
            recipesToRemove.add(ir);
        }
        for (IRecipe ir : recipesToAdd) {
            ForgeRegistries.RECIPES.register((IForgeRegistryEntry)ir);
        }
        if (TweakConfig.recipes.remove3x3Recipes) {
            for (IRecipe ir : recipesToRemove) {
                ((IForgeRegistryModifiable)ForgeRegistries.RECIPES).register((IForgeRegistryEntry)new NullRecipe(ir.getRegistryName()));
            }
        }
    }

    protected static void addSlabRecipe(Ingredient input, ItemStack output, List<IRecipe> recipeList) {
        String itemName = output.func_77977_a().replace(":", "_");
        ItemStack slab4 = output.func_77946_l();
        slab4.func_190920_e(4);
        String recipeName = "pitweaks:recipe_slab_" + itemName;
        ShapedRecipes r = new ShapedRecipes(recipeName, 2, 1, NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{input, input}), slab4);
        r.setRegistryName(new ResourceLocation(recipeName));
        recipeList.add((IRecipe)r);
        ItemStack slab1stack = output.func_77946_l();
        slab1stack.func_190920_e(1);
        Ingredient slab1 = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{slab1stack});
        ItemStack raw = input.func_193365_a()[0].func_77946_l();
        raw.func_190920_e(1);
        if (raw.func_77952_i() == Short.MAX_VALUE) {
            raw.func_77964_b(0);
        }
        recipeName = "pitweaks:recipe_xslab_" + itemName;
        r = new ShapelessRecipes(recipeName, raw, NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{slab1, slab1}));
        r.setRegistryName(new ResourceLocation(recipeName));
        recipeList.add((IRecipe)r);
        System.out.println("PiStairSlab: Found slab recipe for " + raw.toString() + " => " + slab1.toString());
    }

    protected static void addStairRecipe(Ingredient input, ItemStack output, List<IRecipe> recipeList) {
        String itemName = output.func_77977_a().replace(":", "_");
        ItemStack stair4 = output.func_77946_l();
        stair4.func_190920_e(4);
        String recipeName = "pitweaks:recipe_stair_" + itemName;
        ShapedRecipes r = new ShapedRecipes(recipeName, 2, 2, NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{input, Ingredient.field_193370_a, input, input}), stair4);
        r.setRegistryName(new ResourceLocation(recipeName));
        recipeList.add((IRecipe)r);
        ItemStack stair1stack = output.func_77946_l();
        stair1stack.func_190920_e(1);
        Ingredient stair1 = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stair1stack});
        ItemStack raw = input.func_193365_a()[0].func_77946_l();
        raw.func_190920_e(3);
        if (raw.func_77952_i() == Short.MAX_VALUE) {
            raw.func_77964_b(0);
        }
        recipeName = "pitweaks:recipe_xstair_" + itemName;
        r = new ShapelessRecipes(recipeName + itemName, raw, NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{stair1, stair1, stair1, stair1}));
        r.setRegistryName(new ResourceLocation(recipeName));
        recipeList.add((IRecipe)r);
        System.out.println("PiStairSlab: Found stair recipe for " + raw.toString() + " => " + stair1.toString());
    }
}

