/*
 * Decompiled with CFR 0.152.
 */
package us.bemrose.mc.pitweaks;

import java.lang.reflect.Field;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.FoodStats;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import us.bemrose.mc.pitweaks.PiTweaks;
import us.bemrose.mc.pitweaks.Tweak;
import us.bemrose.mc.pitweaks.TweakConfig;

public class FoodCapTweak
extends Tweak {
    @Override
    public void init(FMLInitializationEvent event) {
        if (Loader.isModLoaded((String)"applecore")) {
            if (TweakConfig.player.uncapFood || TweakConfig.player.uncapSaturation) {
                PiTweaks.LOGGER.warn("AppleCore detected.  Disabling food uncapper tweak.");
            }
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        EntityPlayer player;
        FoodStats oldStats;
        if (!TweakConfig.player.uncapFood && !TweakConfig.player.uncapSaturation) {
            return;
        }
        if (event.getEntity() instanceof EntityPlayer && null != (oldStats = (player = (EntityPlayer)event.getEntity()).func_71024_bL()) && !(oldStats instanceof TweakFoodStats)) {
            TweakFoodStats newStats = new TweakFoodStats();
            NBTTagCompound foodnbt = new NBTTagCompound();
            oldStats.func_75117_b(foodnbt);
            newStats.func_75112_a(foodnbt);
            try {
                Field foodStats_field = EntityPlayer.class.getDeclaredField("field_71100_bB");
                foodStats_field.setAccessible(true);
                foodStats_field.set(player, (Object)newStats);
            }
            catch (IllegalAccessException e) {
                System.out.println("Can't set foodStats. This should not have happened.");
            }
            catch (NoSuchFieldException e) {
                System.out.println("Unable to find foodStats field on player!");
            }
        }
    }

    public class TweakFoodStats
    extends FoodStats {
        final int foodLevel_field = 0;
        final int foodSat_field = 1;
        Field[] fields = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredFields();

        TweakFoodStats() {
            this.fields[0].setAccessible(true);
            this.fields[1].setAccessible(true);
        }

        public void func_75122_a(int foodLevelIn, float foodSaturationModifier) {
            try {
                int food = (Integer)this.fields[0].get((Object)this);
                float sat = ((Float)this.fields[1].get((Object)this)).floatValue();
                food += foodLevelIn;
                sat += (float)foodLevelIn * foodSaturationModifier * 2.0f;
                if (!TweakConfig.player.uncapFood) {
                    food = Math.min(food, 20);
                }
                if (!TweakConfig.player.uncapSaturation) {
                    sat = Math.min(sat, (float)food);
                }
                this.fields[0].setInt((Object)this, food);
                this.fields[1].setFloat((Object)this, sat);
            }
            catch (IllegalAccessException e) {
                System.out.println("This didn't happen.");
            }
        }
    }
}

