/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.RegistryManager;
import openmods.OpenMods;

public abstract class CommonRegistryCallbacks<T, E extends IForgeRegistryEntry<E>>
implements IForgeRegistry.AddCallback<E>,
IForgeRegistry.ClearCallback<E>,
IForgeRegistry.CreateCallback<E> {
    private static final ResourceLocation OBJECT_TO_ENTRY = OpenMods.location("object_to_entry");
    private static final ResourceLocation ENTRY_TO_ID = OpenMods.location("entry_to_id");

    protected abstract T getWrappedObject(E var1);

    public void onCreate(IForgeRegistryInternal<E> owner, RegistryManager stage) {
        HashMap classToEntryMap = Maps.newHashMap();
        owner.setSlaveMap(OBJECT_TO_ENTRY, (Object)classToEntryMap);
        HashBiMap entryToId = HashBiMap.create();
        owner.setSlaveMap(ENTRY_TO_ID, (Object)entryToId);
    }

    public void onClear(IForgeRegistryInternal<E> owner, RegistryManager stage) {
        CommonRegistryCallbacks.getObjectToEntryMap(owner).clear();
        CommonRegistryCallbacks.getEntryIdMap(owner).clear();
    }

    public void onAdd(IForgeRegistryInternal<E> owner, RegistryManager stage, int id, E obj, @Nullable E oldObj) {
        CommonRegistryCallbacks.getObjectToEntryMap(owner).put(this.getWrappedObject(obj), obj);
        CommonRegistryCallbacks.getEntryIdMap(owner).put(obj, (Object)id);
    }

    public static <T, E extends IForgeRegistryEntry<E>> Map<T, E> getObjectToEntryMap(IForgeRegistry<E> registry) {
        return (Map)registry.getSlaveMap(OBJECT_TO_ENTRY, Map.class);
    }

    public static <E extends IForgeRegistryEntry<E>> BiMap<E, Integer> getEntryIdMap(IForgeRegistry<E> registry) {
        return (BiMap)registry.getSlaveMap(ENTRY_TO_ID, BiMap.class);
    }

    public static <T, E extends IForgeRegistryEntry<E>> Integer mapObjectToId(IForgeRegistry<E> registry, T object) {
        Map<T, E> objectToEntryMap = CommonRegistryCallbacks.getObjectToEntryMap(registry);
        IForgeRegistryEntry entry = (IForgeRegistryEntry)objectToEntryMap.get(object);
        BiMap<E, Integer> entryIdMap = CommonRegistryCallbacks.getEntryIdMap(registry);
        return (Integer)entryIdMap.get((Object)entry);
    }
}

