/*
 * Decompiled with CFR 0.152.
 */
package openmods.reflection;

import java.lang.reflect.Field;
import openmods.reflection.ReflectionHelper;
import openmods.reflection.ReflectionLog;

public class InstanceFieldAccess<T> {
    public final Object target;
    public final Field field;

    public InstanceFieldAccess(Object parent, Field field) {
        this(parent, field, true);
    }

    private InstanceFieldAccess(Object parent, Field field, boolean log) {
        if (log) {
            ReflectionLog.logLoad(field);
        }
        this.target = parent;
        this.field = field;
        field.setAccessible(true);
    }

    public T get() {
        try {
            return (T)this.field.get(this.target);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void set(T value) {
        try {
            this.field.set(this.target, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> InstanceFieldAccess<T> create(Class<?> cls, Object target, String ... names) {
        Field f = ReflectionHelper.getField(cls, names);
        return new InstanceFieldAccess<T>(target, f, false);
    }

    public static <T> InstanceFieldAccess<T> create(Class<?> cls, String ... names) {
        return InstanceFieldAccess.create(cls, null, names);
    }

    public static <T> InstanceFieldAccess<T> create(Object target, String ... names) {
        return InstanceFieldAccess.create(target.getClass(), target, names);
    }
}

