/*
 * Decompiled with CFR 0.152.
 */
package openmods.model.eval;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import jline.internal.Log;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import openmods.model.BakedModelAdapter;
import openmods.model.ModelUpdater;
import openmods.model.eval.EvalModelBase;
import openmods.model.eval.EvalModelState;
import openmods.model.eval.EvaluatorFactory;
import openmods.model.eval.IVarExpander;

public class EvalExpandModel
extends EvalModelBase {
    public static final IModel EMPTY = new EvalExpandModel(Optional.empty(), Optional.empty(), new EvaluatorFactory());
    private final Optional<ResourceLocation> defaultBlockState;

    private EvalExpandModel(Optional<ResourceLocation> defaultBlockState, Optional<ResourceLocation> baseModel, EvaluatorFactory evaluator) {
        super(baseModel, evaluator);
        this.defaultBlockState = defaultBlockState;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IModel model = this.loadBaseModel(state, format, bakedTextureGetter);
        IBlockState blockState = null;
        if (this.defaultBlockState.isPresent()) {
            Block defaultBlock = (Block)Block.field_149771_c.func_82594_a((Object)this.defaultBlockState.get());
            if (defaultBlock != Blocks.field_150350_a) {
                blockState = defaultBlock.func_176223_P();
                if (!(blockState instanceof IExtendedBlockState) || !((IExtendedBlockState)blockState).getUnlistedNames().contains(EvalModelState.PROPERTY)) {
                    Log.warn((Object[])new Object[]{"State %s does not contain eval state property", blockState});
                }
            } else {
                Log.warn((Object[])new Object[]{"Can't find default block: %s", this.defaultBlockState.get()});
            }
        }
        IVarExpander expander = this.evaluatorFactory.createExpander();
        return new BakedEvalExpandModel(model, state, format, bakedTextureGetter, blockState, expander);
    }

    @Override
    protected IModel update(Map<String, String> customData, ModelUpdater updater, Optional<ResourceLocation> baseModel, EvaluatorFactory evaluator) {
        Optional<ResourceLocation> defaultStateBlock = updater.get("default_state", ModelUpdater.RESOURCE_LOCATION, this.defaultBlockState);
        return updater.hasChanged() ? new EvalExpandModel(defaultStateBlock, baseModel, evaluator) : this;
    }

    private static class BakedEvalExpandModel
    extends BakedModelAdapter {
        private final IVarExpander expander;
        private final IBlockState defaultBlockState;

        public BakedEvalExpandModel(IModel model, IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, IBlockState defaultBlockState, IVarExpander expander) {
            super(model.bake(state, format, bakedTextureGetter), (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)PerspectiveMapWrapper.getTransforms((IModelState)state));
            this.expander = expander;
            this.defaultBlockState = defaultBlockState;
        }

        @Override
        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            if (state == null) {
                state = this.defaultBlockState;
            }
            if (state instanceof IExtendedBlockState) {
                IExtendedBlockState extState = (IExtendedBlockState)state;
                EvalModelState originalArgs = (EvalModelState)MoreObjects.firstNonNull((Object)extState.getValue(EvalModelState.PROPERTY), (Object)EvalModelState.EMPTY);
                EvalModelState updatedArgs = EvalModelState.create(this.expander.expand(originalArgs.getArgs()), originalArgs.isShortLived());
                state = extState.withProperty(EvalModelState.PROPERTY, (Object)updatedArgs);
            }
            return super.func_188616_a(state, side, rand);
        }
    }
}

