/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import openmods.gui.component.BaseComponent;
import openmods.gui.component.BaseComposite;
import openmods.gui.component.GuiComponentTab;

public class GuiComponentTabWrapper
extends BaseComposite {
    protected final BaseComponent mainComponent;
    protected GuiComponentTab activeTab;

    public GuiComponentTabWrapper(int x, int y, BaseComponent mainComponent) {
        super(x, y);
        this.mainComponent = mainComponent;
        this.addComponent(mainComponent);
    }

    @Override
    public BaseComposite addComponent(BaseComponent component) {
        super.addComponent(component);
        if (component instanceof GuiComponentTab) {
            GuiComponentTab tab = (GuiComponentTab)component;
            component.setX(component.getX() + this.mainComponent.getWidth());
            component.setListener((BaseComponent self, int x, int y, int button) -> {
                if (this.activeTab != tab) {
                    if (this.activeTab != null) {
                        this.activeTab.setActive(false);
                    }
                    this.activeTab = tab;
                    this.activeTab.setActive(true);
                } else if (this.activeTab != null && this.activeTab.isOrigin(x, y)) {
                    tab.setActive(false);
                    this.activeTab = null;
                }
            });
        }
        return this;
    }

    @Override
    protected void renderComponentBackground(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.realignTabsVertically();
    }

    private int realignTabsVertically() {
        int oY = this.mainComponent.getY() + 4;
        for (BaseComponent component : this.components) {
            if (!(component instanceof GuiComponentTab)) continue;
            component.setY(oY);
            oY += ((GuiComponentTab)component).getHeight() - 1;
        }
        return oY;
    }

    public void onTabClicked(GuiComponentTab tab) {
        if (tab != this.activeTab) {
            if (this.activeTab != null) {
                this.activeTab.setActive(false);
            }
            tab.setActive(true);
            this.activeTab = tab;
        } else {
            tab.setActive(false);
            this.activeTab = null;
        }
    }

    @Override
    public int getWidth() {
        int maxTabWidth = 0;
        for (BaseComponent component : this.components) {
            if (component.getX() + component.getWidth() <= maxTabWidth) continue;
            maxTabWidth = component.getX() + component.getWidth();
        }
        return this.mainComponent.getWidth() + maxTabWidth;
    }

    @Override
    public int getHeight() {
        int maxTabHeight = 0;
        for (BaseComponent component : this.components) {
            if (component.getY() + component.getHeight() <= maxTabHeight) continue;
            maxTabHeight = component.getY() + component.getHeight();
        }
        return this.mainComponent.getHeight() + maxTabHeight;
    }
}

