/*
 * Decompiled with CFR 0.152.
 */
package openmods.access;

import com.google.common.reflect.TypeToken;
import openmods.access.ApiProviderRegistry;

public abstract class ApiProviderBase<A> {
    private final Class<? super A> markerType = new TypeToken<A>(this.getClass()){}.getRawType();
    private final ApiProviderRegistry<A> apiRegistry;

    public ApiProviderBase(ApiProviderRegistry<A> apiRegistry) {
        this.apiRegistry = apiRegistry;
    }

    public ApiProviderBase() {
        this.apiRegistry = new ApiProviderRegistry<A>(this.markerType);
    }

    public void registerClass(Class<? extends A> cls) {
        this.apiRegistry.registerClass(cls);
    }

    public <T extends A> void registerInstance(T obj) {
        this.apiRegistry.registerInstance(obj);
    }

    public <T extends A> T getApi(Class<T> cls) {
        return this.apiRegistry.getApi(cls);
    }

    public <T extends A> boolean isApiPresent(Class<T> cls) {
        return this.apiRegistry.isApiPresent(cls);
    }
}

