# Быстрый старт

Или как собрать первый компьютер. Для запуска компьютера [компьютера](computer.md) его нужно корректно собрать. В OpenComputers есть различные типы компьютеров, но мы начнем с самого простого и обычного.

**Примечание**: это пошаговая инструкция, которая позволит вам понять базовые принципы мода, так что она довольно длинная. Если вы никогда не собирали компьютер в реальной жизни или вы совсем не знаете этот мод, прочитайте ее всю.

Вначале вам понадобится [системный блок](../block/case1.md). Этот блок будет содержать все компоненты, определяющие поведение собираемого компьютера.

![Системный блок второго уровня.](oredict:oc:case2)

Например, вам потребуется выбрать, какого уровня [видеокарту](../item/graphicsCard1.md) вы будете использовать, нужна ли вам [сетевая](../item/lanCard.md) карта, [плата на красном камне](../item/redstoneCard1.md) или даже [карта отладки](../item/debugCard.md), если вы играете в творческом режиме.

Когда вы откроете интерфейс [системного блока](../block/case1.md), вы увидите несколько слотов справа. Количество слотов и уровень компонентов, которые могут быть установлены (показано римскими цифрами в слотах), зависит от уровня системного блока.
![Интерфейс системного блока второго уровня.](opencomputers:doc/img/configuration_case1.png)
Пустые [системные блоки](../block/case1.md) бесполезны. Вы можете попытаться включить [компьютер](computer.md), но он сразу же выключится, написав сообщение об ошибке в чат, а также выразит свое неудовольствие звуковым сигналом. Хорошо, что сообщение об ошибке говорит, что нужно делать: ему нужна энергия для работы. Подключите ваш [компьютер](computer.md) к источнику энергии - напрямую или через [конвертер энергии](../block/powerConverter.md).

Если вы попробуете запустите его сейчас, он скажет, что ему нужен [процессор](../item/cpu1.md). Они бывают разных уровней - эта тенденция прослеживается во всем OpenComputers. Чем выше уровень [процессора](../item/cpu1.md), тем больше компонентов он сможет использовать и тем быстрее он работает. Определитесь с уровнем процессора и поместите его в [системный блок](../block/case1.md).

Затем вас попросят вставить [планки памяти](../item/ram1.md). Звуковой сигнал, подаваемый при попытке включения, будет другим: 1 длинный гудок и 1 короткий. Чем выше уровень [планок памяти](../item/ram1.md), тем больше памяти будет доступно для использования программами на вашем [компьютере](computer.md). Для запуска полной версии [OpenOS](openOS.md) требуется как минимум две [планки памяти](../item/ram1.md) первого уровня, хотя упрощенная запустится и на одной.

Так уже гораздо лучше. Теперь ваш [системный блок](../block/case1.md) выглядит примерно так:
![Частично собранный компьютер.](opencomputers:doc/img/configuration_case2.png)
Теперь попытка включения не выдает никаких сообщений! Но увы, он не запускается. При этом компьютер подаст двойной звуковой сигнал. Это означает, что не удалось само выполнение программы [компьютером](computer.md). То есть технически он работает. На помощь приходит замечательный инструмент - [анализатор](../item/analyzer.md). Данный инструмент позволяет получать информацию о блоках OpenComputers, а также о некоторых блоках из других модов. Для использования [анализатора](../item/analyzer.md) на [компьютере](computer.md) кликните по нему (с зажатой клавишей Shift).

Вы получите сообщение, почему не запускается [компьютер](computer.md):
`no bios found; install configured EEPROM`

Подчеркнем, что EEPROM нужен именно *настроенный* (configured). Создать [EEPROM](../item/eeprom.md) довольно просто. Но чтобы настроить, обычно используется [компьютер](computer.md), что сложновато в данной ситуации, поэтому будем использовать рецепт для крафта уже сконфигурированный [EEPROM](../item/eeprom.md) с "Lua BIOS". Обычно достаточно объеденить [EEPROM](../item/eeprom.md) и [реководство](../item/manual.md) на верстаке. Поместите настроенный [EEPROM](../item/eeprom.md) в ваш [компьютер](computer.md), и...

Ничего. Совсем ничего. Но мы знаем, что делать: использовать [анализатор](../item/analyzer.md)! В результате получаем другое сообщение:
`no bootable medium found; file not found`

Ну что же. Это означает, что BIOS работает. Но не находит файловую систему, с которой бы он мог запускаться, - [дискету](../item/floppy.md) или [жесткий диск](../item/hdd1.md). Конкретно Lua BIOS хочет, чтобы на файловой системе в корневой директории был файл `init.lua`. Как и в случае с [EEPROM](../item/eeprom.md), обычно для записи на файловую систему нужен компьютер. Как вы, скорее всего, догадались, нам нужно скрафтить дискету с операционной системой. Соедините пустую [дискету](../item/floppy.md) и [руководство](../item/manual.md) на верстаке, и вы получите дискету с [OpenOS](openOS.md).

Если вы использовали [системный блок](../block/case2.md) второго уровня, как на рисунках выше, вам некуда будет вставить дискету. Если вы будете использовать [системный блок](../block/case3.md) третьего уровня или творческий, вы сможете вставить дискету прямо в [системный блок](../block/case1.md). В противном случае нужно установить [дисковод](../block/diskDrive.md) рядом с системным блоком (или подключить с помощью [кабеля](../block/cable.md)). После вставки дискеты включите компьютер.

Он ожил! В любом случае, должен был. Если этого не произошло, значит, что-то пошло не так, и нужно искать ошибку с помощью [анализатора](../item/analyzer.md). Но предпологая, что компьютер заработал, вы почти закончили. Самая сложная часть позади. Теперь осталось заставить его принимать ввод и выводить какой-то результат.

Чтобы [компьютер](computer.md) мог выводить информацию, вы должны установить [монитор](../block/screen1.md) и [видеокарту](../item/graphicsCard1.md).
![Нет, это не плоский экран.](oredict:oc:screen2)

Установите [монитор](../block/screen1.md) рядом с [системным блоком](../block/case1.md) или, опять же, подключите его с помощью [кабеля](../block/cable.md). После чего установите [видеокарту](../item/graphicsCard1.md) по вашему выбору в [системный блок](../block/case1.md). Теперь вы должны увидеть мигающий курсор на [мониторе](../block/screen1.md). Наконец, поставьте [клавиатуру](../block/keyboard.md) перед [монитором](../block/screen1.md) или на одну из его сторон, чтобы получить возможность вводить текст с [клавиатуры](../block/keyboard.md).

На этом все. Теперь ваш [компьютер](computer.md) запущен, работает и ожидает команд. Попробуйте что-нибудь напечатать! Введите `lua` и нажмите Enter, после чего вы получите приветственное сообщение интерпретатора Lua. Здесь вы можете выполнять простые команды Lua. Для более подробной информации прочтите страницу о [Lua](lua.md).

![Оно живое!](opencomputers:doc/img/configuration_done.png)

Получайте удовольствие от создания сложных [компьютеров](computer.md), [серверов](../item/server1.md) и сборки [роботов](../block/robot.md), [дронов](../item/drone.md), [микроконтроллеров](../block/microcontroller.md) и [планшетов](../item/tablet.md) в [сборщике](../block/assembler.md).

Удачи!
