/*
 * Decompiled with CFR 0.152.
 */
package openblocks.shapes;

import java.nio.ByteBuffer;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openmods.renderer.shaders.BufferHelper;
import org.lwjgl.BufferUtils;

public class CoordShape {
    @SideOnly(value=Side.CLIENT)
    private int vbo;
    private final List<BlockPos> coords;

    public CoordShape(List<BlockPos> coords) {
        this.coords = coords;
    }

    @SideOnly(value=Side.CLIENT)
    public int bindVBO() {
        if (this.vbo == 0) {
            ByteBuffer data = BufferUtils.createByteBuffer((int)(this.coords.size() * 3 * 4));
            for (BlockPos c : this.coords) {
                data.putFloat((float)c.func_177958_n() - 0.5f).putFloat(c.func_177956_o()).putFloat((float)c.func_177952_p() - 0.5f);
            }
            data.flip();
            this.vbo = BufferHelper.methods().glGenBuffers();
            BufferHelper.methods().glBindBuffer(34962, this.vbo);
            BufferHelper.methods().glBufferData(34962, data, 35044);
        } else {
            BufferHelper.methods().glBindBuffer(34962, this.vbo);
        }
        return this.vbo;
    }

    public List<BlockPos> getCoords() {
        return this.coords;
    }

    public int size() {
        return this.coords.size();
    }

    @SideOnly(value=Side.CLIENT)
    public void destroy() {
        if (this.vbo != 0) {
            BufferHelper.methods().glDeleteBuffers(this.vbo);
        }
        this.vbo = 0;
    }
}

