/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import openblocks.OpenBlocks;
import openblocks.client.gui.GuiDrawingTable;
import openblocks.common.StencilPattern;
import openblocks.common.container.ContainerDrawingTable;
import openblocks.common.item.ItemGlyph;
import openblocks.common.item.ItemStencil;
import openblocks.common.item.MetasGeneric;
import openblocks.rpc.IStencilCrafter;
import openmods.api.ICustomBreakDrops;
import openmods.api.IHasGui;
import openmods.api.IValueProvider;
import openmods.fixers.GenericInventoryTeFixerWalker;
import openmods.fixers.RegisterFixer;
import openmods.inventory.GenericInventory;
import openmods.inventory.IInventoryProvider;
import openmods.inventory.TileEntityInventory;
import openmods.sync.SyncMap;
import openmods.sync.SyncableEnum;
import openmods.sync.SyncableInt;
import openmods.sync.SyncableString;
import openmods.tileentity.SyncedTileEntity;
import org.apache.commons.lang3.ArrayUtils;

@RegisterFixer(value=GenericInventoryTeFixerWalker.class)
public class TileEntityDrawingTable
extends SyncedTileEntity
implements IHasGui,
IInventoryProvider,
IStencilCrafter,
ICustomBreakDrops {
    private static final int MAX_PRINT_SIZE = 32;
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 1;
    private SyncableEnum<StencilPattern> selectedPattern;
    private SyncableInt selectedGlyph;
    private SyncableEnum<IStencilCrafter.Mode> selectedMode;
    private SyncableString textToPrint;
    private final GenericInventory inventory = this.registerInventoryCallback((GenericInventory)new TileEntityInventory((TileEntity)this, "drawingtable", true, 2){

        public boolean func_94041_b(int slotId, ItemStack itemstack) {
            return itemstack.func_190926_b() || slotId == 0 && MetasGeneric.unpreparedStencil.isA(itemstack);
        }

        public void onInventoryChanged(int slotNumber) {
            if (MetasGeneric.unpreparedStencil.isAvailable()) {
                if (slotNumber == 0) {
                    ItemStack input = (ItemStack)this.inventoryContents.get(0);
                    if (MetasGeneric.unpreparedStencil.isA(input)) {
                        ItemStack output = this.createOutput(input.func_190916_E());
                        this.inventoryContents.set(1, (Object)output);
                    } else {
                        this.inventoryContents.set(1, (Object)ItemStack.field_190927_a);
                    }
                } else if (slotNumber == 1) {
                    ItemStack output = (ItemStack)this.inventoryContents.get(1);
                    if (this.isValidOutput(output)) {
                        ItemStack input = MetasGeneric.unpreparedStencil.newItemStack(output.func_190916_E());
                        this.inventoryContents.set(0, (Object)input);
                    } else {
                        this.inventoryContents.set(0, (Object)ItemStack.field_190927_a);
                    }
                }
            }
        }

        private boolean isValidOutput(ItemStack item) {
            switch ((IStencilCrafter.Mode)TileEntityDrawingTable.this.selectedMode.get()) {
                case GLYPHS: {
                    return item.func_77973_b() instanceof ItemGlyph;
                }
                case STENCILS: {
                    return item.func_77973_b() instanceof ItemStencil;
                }
            }
            return false;
        }

        private ItemStack createOutput(int count) {
            switch ((IStencilCrafter.Mode)TileEntityDrawingTable.this.selectedMode.get()) {
                case GLYPHS: {
                    if (OpenBlocks.Items.glyph == null) break;
                    return new ItemStack(OpenBlocks.Items.glyph, count, TileEntityDrawingTable.this.selectedGlyph.get());
                }
                case STENCILS: {
                    if (OpenBlocks.Items.stencil == null) break;
                    return new ItemStack(OpenBlocks.Items.stencil, count, ((StencilPattern)TileEntityDrawingTable.this.selectedPattern.get()).ordinal());
                }
            }
            return ItemStack.field_190927_a;
        }
    });

    protected void onSyncMapCreate(SyncMap syncMap) {
        syncMap.addSyncListener(changes -> this.inventory.onInventoryChanged(0));
    }

    protected void createSyncedFields() {
        this.selectedMode = SyncableEnum.create((Enum)IStencilCrafter.Mode.STENCILS);
        this.selectedGlyph = new SyncableInt(ArrayUtils.indexOf((char[])ItemGlyph.ALMOST_ASCII, (char)'A'));
        this.selectedPattern = SyncableEnum.create((Enum)StencilPattern.CREEPER_FACE);
        this.textToPrint = new SyncableString();
    }

    @Override
    public void selectionUp() {
        switch ((IStencilCrafter.Mode)this.selectedMode.get()) {
            case GLYPHS: {
                int glyph = this.selectedGlyph.get();
                this.selectedGlyph.set((glyph + 1) % ItemGlyph.ALMOST_ASCII.length);
                break;
            }
            case STENCILS: {
                this.selectedPattern.increment();
            }
        }
        this.sync();
    }

    @Override
    public void selectionDown() {
        switch ((IStencilCrafter.Mode)this.selectedMode.get()) {
            case GLYPHS: {
                int glyph = this.selectedGlyph.get();
                this.selectedGlyph.set(Math.floorMod(glyph - 1, ItemGlyph.ALMOST_ASCII.length));
                break;
            }
            case STENCILS: {
                this.selectedPattern.decrement();
            }
        }
        this.sync();
    }

    @Override
    public void cycleMode() {
        this.selectedMode.increment();
        this.sync();
    }

    @Override
    public void printGlyphs(String text) {
        char ch;
        int glyph;
        int i;
        if (OpenBlocks.Items.glyph == null) {
            return;
        }
        ItemStack resources = this.inventory.func_70301_a(0);
        int resourceCount = resources.func_190916_E();
        int letterCount = text.length();
        float dropX = (float)this.field_174879_c.func_177958_n() + 0.5f;
        float dropY = (float)this.field_174879_c.func_177956_o() + 1.0f;
        float dropZ = (float)this.field_174879_c.func_177952_p() + 0.5f;
        int opCount = Math.min(32, Math.min(resourceCount, letterCount));
        for (i = 0; i < opCount && (glyph = ArrayUtils.indexOf((char[])ItemGlyph.ALMOST_ASCII, (char)(ch = text.charAt(i)))) != -1; ++i) {
            ItemStack drop = ItemGlyph.createStack(OpenBlocks.Items.glyph, glyph);
            EntityItem entityitem = new EntityItem(this.func_145831_w(), (double)dropX, (double)dropY, (double)dropZ, drop);
            entityitem.func_174869_p();
            this.func_145831_w().func_72838_d((Entity)entityitem);
        }
        if (i > 0) {
            resources.func_190920_e(resourceCount - i);
            this.inventory.func_70299_a(0, resources);
        }
        if (letterCount > i) {
            this.textToPrint.setValue(text.substring(i));
        } else {
            this.textToPrint.setValue("");
        }
        this.sync();
    }

    public IValueProvider<IStencilCrafter.Mode> getMode() {
        return this.selectedMode;
    }

    public IValueProvider<String> getTextToPrint() {
        return this.textToPrint;
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerDrawingTable((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiDrawingTable(new ContainerDrawingTable((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        this.inventory.writeToNBT(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag);
    }

    public List<ItemStack> getDrops(List<ItemStack> originalDrops) {
        ArrayList drops = Lists.newArrayList();
        drops.add(this.inventory.func_70301_a(0));
        return drops;
    }
}

