/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity.tank;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import openblocks.client.renderer.tileentity.tank.TankRenderUtils;
import openblocks.common.tileentity.TileEntityTank;
import openmods.model.variant.VariantModelState;

public class NeighbourMap {
    private final VariantModelState state;

    private static void testNeighbour(Set<String> result, World world, FluidStack ownFluid, int x, int y, int z, String id) {
        TileEntity te = TankRenderUtils.getTileEntitySafe(world, new BlockPos(x, y, z));
        if (te instanceof TileEntityTank && ((TileEntityTank)te).accepts(ownFluid)) {
            result.add(id);
        }
    }

    public NeighbourMap(World world, BlockPos pos, FluidStack fluid) {
        if (world == null) {
            this.state = VariantModelState.EMPTY;
        } else {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            HashSet neighbours = Sets.newHashSet();
            NeighbourMap.testNeighbour(neighbours, world, fluid, x + 0, y + 1, z + 0, "n_t");
            NeighbourMap.testNeighbour(neighbours, world, fluid, x + 0, y - 1, z + 0, "n_b");
            NeighbourMap.testNeighbour(neighbours, world, fluid, x + 1, y + 0, z + 0, "n_e");
            NeighbourMap.testNeighbour(neighbours, world, fluid, x - 1, y + 0, z + 0, "n_w");
            NeighbourMap.testNeighbour(neighbours, world, fluid, x + 0, y + 0, z + 1, "n_s");
            NeighbourMap.testNeighbour(neighbours, world, fluid, x + 0, y + 0, z - 1, "n_n");
            NeighbourMap.testNeighbour(neighbours, world, fluid, x + 1, y + 1, z + 0, "n_te");
            NeighbourMap.testNeighbour(neighbours, world, fluid, x - 1, y + 1, z + 0, "n_tw");
            NeighbourMap.testNeighbour(neighbours, world, fluid, x + 0, y + 1, z + 1, "n_ts");
            NeighbourMap.testNeighbour(neighbours, world, fluid, x + 0, y + 1, z - 1, "n_tn");
            NeighbourMap.testNeighbour(neighbours, world, fluid, x + 1, y - 1, z + 0, "n_be");
            NeighbourMap.testNeighbour(neighbours, world, fluid, x - 1, y - 1, z + 0, "n_bw");
            NeighbourMap.testNeighbour(neighbours, world, fluid, x + 0, y - 1, z + 1, "n_bs");
            NeighbourMap.testNeighbour(neighbours, world, fluid, x + 0, y - 1, z - 1, "n_bn");
            NeighbourMap.testNeighbour(neighbours, world, fluid, x - 1, y + 0, z - 1, "n_nw");
            NeighbourMap.testNeighbour(neighbours, world, fluid, x - 1, y + 0, z + 1, "n_sw");
            NeighbourMap.testNeighbour(neighbours, world, fluid, x + 1, y + 0, z + 1, "n_se");
            NeighbourMap.testNeighbour(neighbours, world, fluid, x + 1, y + 0, z - 1, "n_ne");
            this.state = VariantModelState.create().withKeys((Set)neighbours);
        }
    }

    public VariantModelState getState() {
        return this.state;
    }
}

