/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.util;

import com.chaosthedude.naturescompass.NaturesCompass;
import com.chaosthedude.naturescompass.config.ConfigHandler;
import com.chaosthedude.naturescompass.items.ItemNaturesCompass;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.WorldWorkerManager;

public class BiomeSearchWorker
implements WorldWorkerManager.IWorker {
    public final int sampleSpace;
    public final int maxDistance;
    public World world;
    public Biome biome;
    public BlockPos startPos;
    public int samples;
    public int nextLength;
    public EnumFacing direction;
    public ItemStack stack;
    public EntityPlayer player;
    public int x;
    public int z;
    public int length;
    public boolean finished;

    public BiomeSearchWorker(World world, EntityPlayer player, ItemStack stack, Biome biome, BlockPos startPos) {
        this.world = world;
        this.player = player;
        this.stack = stack;
        this.biome = biome;
        this.startPos = startPos;
        this.x = startPos.func_177958_n();
        this.z = startPos.func_177952_p();
        this.sampleSpace = ConfigHandler.sampleSpaceModifier * BiomeUtils.getBiomeSize(world);
        this.maxDistance = ConfigHandler.distanceModifier * BiomeUtils.getBiomeSize(world);
        this.nextLength = this.sampleSpace;
        this.length = 0;
        this.samples = 0;
        this.direction = EnumFacing.UP;
        this.finished = false;
    }

    public void start() {
        if (!this.stack.func_190926_b() && this.stack.func_77973_b() == NaturesCompass.naturesCompass) {
            if (this.maxDistance > 0 && this.sampleSpace > 0) {
                NaturesCompass.logger.info("Starting search: " + this.sampleSpace + " sample space, " + this.maxDistance + " max distance");
                WorldWorkerManager.addWorker((WorldWorkerManager.IWorker)this);
            } else {
                this.finish(false);
            }
        }
    }

    public boolean hasWork() {
        return !this.finished && this.getRadius() < this.maxDistance && this.samples < ConfigHandler.maxSamples;
    }

    public boolean doWork() {
        if (this.hasWork()) {
            if (this.direction == EnumFacing.NORTH) {
                this.z -= this.sampleSpace;
            } else if (this.direction == EnumFacing.EAST) {
                this.x += this.sampleSpace;
            } else if (this.direction == EnumFacing.SOUTH) {
                this.z += this.sampleSpace;
            } else if (this.direction == EnumFacing.WEST) {
                this.x -= this.sampleSpace;
            }
            BlockPos pos = new BlockPos(this.x, this.world.func_72800_K(), this.z);
            Biome biomeAtPos = this.world.getBiomeForCoordsBody(pos);
            if (biomeAtPos == this.biome) {
                this.finish(true);
                return false;
            }
            ++this.samples;
            this.length += this.sampleSpace;
            if (this.length >= this.nextLength) {
                if (this.direction != EnumFacing.UP) {
                    this.nextLength += this.sampleSpace;
                    this.direction = this.direction.func_176746_e();
                } else {
                    this.direction = EnumFacing.NORTH;
                }
                this.length = 0;
            }
        }
        if (this.hasWork()) {
            return true;
        }
        this.finish(false);
        return false;
    }

    private void finish(boolean found) {
        if (found) {
            NaturesCompass.logger.info("Search succeeded: " + this.getRadius() + " radius, " + this.samples + " samples");
            ((ItemNaturesCompass)this.stack.func_77973_b()).setFound(this.stack, this.x, this.z, this.samples, this.player);
        } else {
            NaturesCompass.logger.info("Search failed: " + this.getRadius() + " radius, " + this.samples + " samples");
            ((ItemNaturesCompass)this.stack.func_77973_b()).setNotFound(this.stack, this.player, this.getRadius(), this.samples);
        }
        this.finished = true;
    }

    private int getRadius() {
        return (int)this.startPos.func_185332_f(this.x, this.startPos.func_177956_o(), this.z);
    }
}

