/*
 * Decompiled with CFR 0.152.
 */
package at.feldim2425.moreoverlays.api.lightoverlay;

import at.feldim2425.moreoverlays.api.lightoverlay.ILightScanner;
import at.feldim2425.moreoverlays.config.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import org.apache.commons.lang3.tuple.Pair;

public abstract class LightScannerBase
implements ILightScanner {
    protected List<Pair<BlockPos, Byte>> overlayCache = new ArrayList<Pair<BlockPos, Byte>>();

    @Override
    public void update(EntityPlayer player) {
        int px = (int)Math.floor(player.field_70165_t);
        int py = (int)Math.floor(player.field_70163_u);
        int pz = (int)Math.floor(player.field_70161_v);
        int y1 = py - Config.light_DownRange;
        int y2 = py + Config.light_UpRange;
        this.overlayCache.clear();
        for (int xo = -Config.light_HRange; xo <= Config.light_HRange; ++xo) {
            for (int zo = -Config.light_HRange; zo <= Config.light_HRange; ++zo) {
                BlockPos pos1 = new BlockPos(px + xo, py, pz + zo);
                if (!this.shouldCheck(pos1, player.field_70170_p)) continue;
                for (int y = y1; y <= y2; ++y) {
                    BlockPos pos = new BlockPos(px + xo, y, pz + zo);
                    byte mode = this.getSpawnModeAt(pos, player.field_70170_p);
                    if (mode == 0) continue;
                    this.overlayCache.add((Pair<BlockPos, Byte>)Pair.of((Object)pos, (Object)mode));
                }
            }
        }
    }

    @Override
    public void clear() {
        this.overlayCache.clear();
    }

    @Override
    public List<Pair<BlockPos, Byte>> getLightModes() {
        return this.overlayCache;
    }

    public boolean shouldCheck(BlockPos pos, World world) {
        if (Config.light_IgnoreSpawn) {
            return true;
        }
        Biome biome = world.func_180494_b(pos);
        return biome.func_76741_f() > 0.0f && !biome.func_76747_a(EnumCreatureType.MONSTER).isEmpty();
    }

    public abstract byte getSpawnModeAt(BlockPos var1, World var2);
}

