/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.minerva.common.network;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.tuple.Pair;
import zabi.minecraft.minerva.common.utils.annotation.Ignore;

public class SimpleMessage<REQ extends SimpleMessage>
implements IMessage,
IMessageHandler<REQ, IMessage> {
    private static final HashMap<String, Pair<Reader, Writer>> handlers = new HashMap();
    private static final HashMap<String, Field[]> fieldCache = new HashMap();

    private static Field[] getClassFields(Class<?> clazz) {
        if (fieldCache.containsKey(clazz.getCanonicalName())) {
            return fieldCache.get(clazz.getCanonicalName());
        }
        Field[] afields = clazz.getFields();
        Arrays.sort(afields, (f1, f2) -> f1.getName().compareTo(f2.getName()));
        ArrayList flist = Lists.newArrayList();
        for (Field f : afields) {
            if (!SimpleMessage.acceptField(f)) continue;
            flist.add(f);
        }
        Field[] fields = new Field[flist.size()];
        for (int i = 0; i < flist.size(); ++i) {
            fields[i] = (Field)flist.get(i);
        }
        fieldCache.put(clazz.getCanonicalName(), fields);
        return fields;
    }

    private static Pair<Reader, Writer> getHandler(Class<?> clazz) {
        Pair<Reader, Writer> pair = handlers.get(clazz.getCanonicalName());
        if (pair == null) {
            throw new SerializationException("No R/W handler for  " + clazz);
        }
        return pair;
    }

    private static boolean acceptField(Field f) {
        int mods = f.getModifiers();
        if (Modifier.isFinal(mods) || Modifier.isStatic(mods) || Modifier.isTransient(mods) || f.isAnnotationPresent(Ignore.class)) {
            return false;
        }
        return handlers.containsKey(f.getType().getCanonicalName());
    }

    private static <T> void map(Class<T> type, Reader<T> reader, Writer<T> writer) {
        handlers.put(type.getCanonicalName(), (Pair<Reader, Writer>)Pair.of(reader, writer));
    }

    public static byte readByte(ByteBuf buf) {
        return buf.readByte();
    }

    public static void writeByte(byte b, ByteBuf buf) {
        buf.writeByte((int)b);
    }

    public static short readShort(ByteBuf buf) {
        return buf.readShort();
    }

    public static void writeShort(short s, ByteBuf buf) {
        buf.writeShort((int)s);
    }

    public static int readInt(ByteBuf buf) {
        return buf.readInt();
    }

    public static void writeInt(int i, ByteBuf buf) {
        buf.writeInt(i);
    }

    public static long readLong(ByteBuf buf) {
        return buf.readLong();
    }

    public static void writeLong(long l, ByteBuf buf) {
        buf.writeLong(l);
    }

    public static float readFloat(ByteBuf buf) {
        return buf.readFloat();
    }

    public static void writeFloat(float f, ByteBuf buf) {
        buf.writeFloat(f);
    }

    public static double readDouble(ByteBuf buf) {
        return buf.readDouble();
    }

    public static void writeDouble(double d, ByteBuf buf) {
        buf.writeDouble(d);
    }

    public static boolean readBoolean(ByteBuf buf) {
        return buf.readBoolean();
    }

    public static void writeBoolean(boolean b, ByteBuf buf) {
        buf.writeBoolean(b);
    }

    public static void writeUUID(UUID id, ByteBuf buf) {
        if (id == null) {
            buf.writeLong(0L);
            buf.writeLong(0L);
        } else {
            buf.writeLong(id.getMostSignificantBits());
            buf.writeLong(id.getLeastSignificantBits());
        }
    }

    public static UUID readUUID(ByteBuf buf) {
        long msb = buf.readLong();
        long lsb = buf.readLong();
        if (msb == 0L && lsb == 0L) {
            return null;
        }
        return new UUID(msb, lsb);
    }

    public static char readChar(ByteBuf buf) {
        return buf.readChar();
    }

    public static void writeChar(char c, ByteBuf buf) {
        buf.writeChar((int)c);
    }

    public static String readString(ByteBuf buf) {
        return ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public static void writeString(String s, ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)s);
    }

    public static NBTTagCompound readNBT(ByteBuf buf) {
        return ByteBufUtils.readTag((ByteBuf)buf);
    }

    public static void writeNBT(NBTTagCompound cmp, ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)cmp);
    }

    public static ItemStack readItemStack(ByteBuf buf) {
        return ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public static void writeItemStack(ItemStack stack, ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack);
    }

    public static BlockPos readBlockPos(ByteBuf buf) {
        return BlockPos.func_177969_a((long)buf.readLong());
    }

    public static void writeBlockPos(BlockPos pos, ByteBuf buf) {
        buf.writeLong(pos.func_177986_g());
    }

    public static Vec3d readVec3d(ByteBuf buf) {
        return new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public static void writeVec3d(Vec3d vec, ByteBuf buf) {
        buf.writeDouble(vec.field_72450_a);
        buf.writeDouble(vec.field_72448_b);
        buf.writeDouble(vec.field_72449_c);
    }

    public static void writeResourceLocation(ResourceLocation rl, ByteBuf buf) {
        SimpleMessage.writeString(rl.toString(), buf);
    }

    public static ResourceLocation readResourceLocation(ByteBuf buf) {
        return new ResourceLocation(SimpleMessage.readString(buf));
    }

    public IMessage handleMessage(MessageContext context) {
        return null;
    }

    public final IMessage onMessage(REQ message, MessageContext context) {
        return ((SimpleMessage)message).handleMessage(context);
    }

    public final void fromBytes(ByteBuf buf) {
        try {
            Field[] clFields;
            Class<?> clazz = this.getClass();
            for (Field f : clFields = SimpleMessage.getClassFields(clazz)) {
                Class<?> type = f.getType();
                this.readField(f, type, buf);
            }
        }
        catch (Exception e) {
            throw new SerializationException("Error at reading packet " + this, (Throwable)e);
        }
    }

    public final void toBytes(ByteBuf buf) {
        try {
            Field[] clFields;
            Class<?> clazz = this.getClass();
            for (Field f : clFields = SimpleMessage.getClassFields(clazz)) {
                Class<?> type = f.getType();
                this.writeField(f, type, buf);
            }
        }
        catch (Exception e) {
            throw new SerializationException("Error at writing packet " + this, (Throwable)e);
        }
    }

    private final void writeField(Field f, Class clazz, ByteBuf buf) throws IllegalArgumentException, IllegalAccessException {
        Pair<Reader, Writer> handler = SimpleMessage.getHandler(clazz);
        ((Writer)handler.getRight()).write(f.get(this), buf);
    }

    private final void readField(Field f, Class clazz, ByteBuf buf) throws IllegalArgumentException, IllegalAccessException {
        Pair<Reader, Writer> handler = SimpleMessage.getHandler(clazz);
        f.set(this, ((Reader)handler.getLeft()).read(buf));
    }

    static {
        SimpleMessage.map(Byte.TYPE, SimpleMessage::readByte, SimpleMessage::writeByte);
        SimpleMessage.map(Short.TYPE, SimpleMessage::readShort, SimpleMessage::writeShort);
        SimpleMessage.map(Integer.TYPE, SimpleMessage::readInt, SimpleMessage::writeInt);
        SimpleMessage.map(Long.TYPE, SimpleMessage::readLong, SimpleMessage::writeLong);
        SimpleMessage.map(Float.TYPE, SimpleMessage::readFloat, SimpleMessage::writeFloat);
        SimpleMessage.map(Double.TYPE, SimpleMessage::readDouble, SimpleMessage::writeDouble);
        SimpleMessage.map(Boolean.TYPE, SimpleMessage::readBoolean, SimpleMessage::writeBoolean);
        SimpleMessage.map(Character.TYPE, SimpleMessage::readChar, SimpleMessage::writeChar);
        SimpleMessage.map(String.class, SimpleMessage::readString, SimpleMessage::writeString);
        SimpleMessage.map(NBTTagCompound.class, SimpleMessage::readNBT, SimpleMessage::writeNBT);
        SimpleMessage.map(ItemStack.class, SimpleMessage::readItemStack, SimpleMessage::writeItemStack);
        SimpleMessage.map(BlockPos.class, SimpleMessage::readBlockPos, SimpleMessage::writeBlockPos);
        SimpleMessage.map(UUID.class, SimpleMessage::readUUID, SimpleMessage::writeUUID);
        SimpleMessage.map(Vec3d.class, SimpleMessage::readVec3d, SimpleMessage::writeVec3d);
        SimpleMessage.map(ResourceLocation.class, SimpleMessage::readResourceLocation, SimpleMessage::writeResourceLocation);
    }

    public static interface Reader<T> {
        public T read(ByteBuf var1);
    }

    public static interface Writer<T> {
        public void write(T var1, ByteBuf var2);
    }
}

