/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.render.item;

import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.client.render.item.ItemLayerWrapper;
import mekanism.client.render.item.SubTypeItemRenderer;
import mekanism.generators.client.render.item.RenderAdvancedSolarGeneratorItem;
import mekanism.generators.client.render.item.RenderBioGeneratorItem;
import mekanism.generators.client.render.item.RenderGasGeneratorItem;
import mekanism.generators.client.render.item.RenderSolarGeneratorItem;
import mekanism.generators.client.render.item.RenderWindGeneratorItem;
import mekanism.generators.common.block.states.BlockStateGenerator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderGeneratorItem
extends SubTypeItemRenderer<BlockStateGenerator.GeneratorType> {
    public static Map<BlockStateGenerator.GeneratorType, ItemLayerWrapper> modelMap = new EnumMap<BlockStateGenerator.GeneratorType, ItemLayerWrapper>(BlockStateGenerator.GeneratorType.class);

    protected boolean earlyExit() {
        return true;
    }

    protected void renderBlockSpecific(@Nonnull ItemStack stack, ItemCameraTransforms.TransformType transformType) {
        BlockStateGenerator.GeneratorType generatorType = BlockStateGenerator.GeneratorType.get(stack);
        if (generatorType != null) {
            if (generatorType == BlockStateGenerator.GeneratorType.BIO_GENERATOR) {
                RenderBioGeneratorItem.renderStack(stack, transformType);
            } else if (generatorType == BlockStateGenerator.GeneratorType.ADVANCED_SOLAR_GENERATOR) {
                RenderAdvancedSolarGeneratorItem.renderStack(stack, transformType);
            } else if (generatorType == BlockStateGenerator.GeneratorType.SOLAR_GENERATOR) {
                RenderSolarGeneratorItem.renderStack(stack, transformType);
            } else if (generatorType == BlockStateGenerator.GeneratorType.GAS_GENERATOR) {
                RenderGasGeneratorItem.renderStack(stack, transformType);
            } else if (generatorType == BlockStateGenerator.GeneratorType.WIND_GENERATOR) {
                RenderWindGeneratorItem.renderStack(stack, transformType);
            }
        }
    }

    protected void renderItemSpecific(@Nonnull ItemStack stack, ItemCameraTransforms.TransformType transformType) {
    }

    @Nullable
    protected ItemLayerWrapper getModel(BlockStateGenerator.GeneratorType generatorType) {
        return modelMap.get((Object)generatorType);
    }

    @Nullable
    protected BlockStateGenerator.GeneratorType getType(@Nonnull ItemStack stack) {
        return BlockStateGenerator.GeneratorType.get(stack);
    }
}

