/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui.element;

import mekanism.api.Coord4D;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.tab.GuiTabElementType;
import mekanism.client.gui.element.tab.TabType;
import mekanism.common.Mekanism;
import mekanism.common.network.PacketSimpleGui;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiTurbineTab
extends GuiTabElementType<TileEntityTurbineCasing, TurbineTab> {
    public GuiTurbineTab(IGuiWrapper gui, TileEntityTurbineCasing tile, TurbineTab type, ResourceLocation def) {
        super(gui, (TileEntity)tile, (Enum)type, def);
    }

    public static enum TurbineTab implements TabType
    {
        MAIN("GuiGasesTab.png", 6, "gui.main"),
        STAT("GuiStatsTab.png", 7, "gui.stats");

        private final String description;
        private final String path;
        private final int guiId;

        private TurbineTab(String path, int id, String desc) {
            this.path = path;
            this.guiId = id;
            this.description = desc;
        }

        public ResourceLocation getResource() {
            return MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI_ELEMENT, (String)this.path);
        }

        public void openGui(TileEntity tile) {
            Mekanism.packetHandler.sendToServer((IMessage)new PacketSimpleGui.SimpleGuiMessage(Coord4D.get((TileEntity)tile), 1, this.guiId));
        }

        public String getDesc() {
            return LangUtils.localize((String)this.description);
        }

        public int getYPos() {
            return 6;
        }
    }
}

