/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import io.netty.buffer.ByteBuf;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.block.states.BlockStateTransmitter;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.tier.BaseTier;
import mekanism.common.tier.TubeTier;
import mekanism.common.tile.transmitter.TileEntitySidedPipe;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.transmitters.grid.GasNetwork;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.GasUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class TileEntityPressurizedTube
extends TileEntityTransmitter<IGasHandler, GasNetwork, GasStack>
implements IGasHandler {
    public TubeTier tier = TubeTier.BASIC;
    public float currentScale;
    public GasTank buffer = new GasTank(this.getCapacity());
    public GasStack lastWrite;
    private final IGasHandler nullHandler = new IGasHandler(){

        @Override
        public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
            return 0;
        }

        @Override
        public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
            return null;
        }

        @Override
        public boolean canReceiveGas(EnumFacing side, Gas type) {
            return false;
        }

        @Override
        public boolean canDrawGas(EnumFacing side, Gas type) {
            return false;
        }

        @Override
        @Nonnull
        public GasTankInfo[] getTankInfo() {
            return TileEntityPressurizedTube.this.getTankInfo();
        }
    };

    @Override
    public BaseTier getBaseTier() {
        return this.tier.getBaseTier();
    }

    @Override
    public void setBaseTier(BaseTier baseTier) {
        this.tier = TubeTier.get(baseTier);
        this.buffer.setMaxGas(this.getCapacity());
    }

    @Override
    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.updateShare();
            IGasHandler[] connectedAcceptors = GasUtils.getConnectedAcceptors(this.func_174877_v(), this.func_145831_w());
            for (EnumFacing side : this.getConnections(TileEntitySidedPipe.ConnectionType.PULL)) {
                GasStack received;
                IGasHandler container = connectedAcceptors[side.ordinal()];
                if (container == null || (received = container.drawGas(side.func_176734_d(), this.getAvailablePull(), false)) == null || received.amount == 0 || this.takeGas(received, false) != received.amount) continue;
                container.drawGas(side.func_176734_d(), this.takeGas(received, true), true);
            }
        } else {
            float targetScale;
            float f = targetScale = this.getTransmitter().hasTransmitterNetwork() ? ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).gasScale : (float)this.buffer.getStored() / (float)this.buffer.getMaxGas();
            if ((double)Math.abs(this.currentScale - targetScale) > 0.01) {
                this.currentScale = (9.0f * this.currentScale + targetScale) / 10.0f;
            }
        }
        super.func_73660_a();
    }

    public int getAvailablePull() {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            return Math.min(this.tier.getTubePullAmount(), ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).getGasNeeded());
        }
        return Math.min(this.tier.getTubePullAmount(), this.buffer.getNeeded());
    }

    @Override
    public void updateShare() {
        GasStack last;
        if (this.getTransmitter().hasTransmitterNetwork() && this.getTransmitter().getTransmitterNetworkSize() > 0 && ((last = this.getSaveShare()) != null && (this.lastWrite == null || this.lastWrite.amount != last.amount || this.lastWrite.getGas() != last.getGas()) || last == null && this.lastWrite != null)) {
            this.lastWrite = last;
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
        }
    }

    private GasStack getSaveShare() {
        if (this.getTransmitter().hasTransmitterNetwork() && ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).buffer != null) {
            int remain = ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount % ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).transmittersSize();
            int toSave = ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount / ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).transmittersSize();
            if (((GasNetwork)this.getTransmitter().getTransmitterNetwork()).firstTransmitter().equals(this.getTransmitter())) {
                toSave += remain;
            }
            return new GasStack(((GasNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.getGas(), toSave);
        }
        return null;
    }

    @Override
    public void onChunkUnload() {
        if (!this.func_145831_w().field_72995_K && this.getTransmitter().hasTransmitterNetwork() && this.lastWrite != null && ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).buffer != null) {
            ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount -= this.lastWrite.amount;
            if (((GasNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount <= 0) {
                ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).buffer = null;
            }
        }
        super.onChunkUnload();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        if (nbtTags.func_74764_b("tier")) {
            this.tier = TubeTier.values()[nbtTags.func_74762_e("tier")];
        }
        this.buffer.setMaxGas(this.getCapacity());
        if (nbtTags.func_74764_b("cacheGas")) {
            this.buffer.setGas(GasStack.readFromNBT(nbtTags.func_74775_l("cacheGas")));
        } else {
            this.buffer.setGas(null);
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        if (this.lastWrite != null && this.lastWrite.amount > 0) {
            nbtTags.func_74782_a("cacheGas", (NBTBase)this.lastWrite.write(new NBTTagCompound()));
        } else {
            nbtTags.func_82580_o("cacheGas");
        }
        nbtTags.func_74768_a("tier", this.tier.ordinal());
        return nbtTags;
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.GAS;
    }

    @Override
    public BlockStateTransmitter.TransmitterType getTransmitterType() {
        return BlockStateTransmitter.TransmitterType.PRESSURIZED_TUBE;
    }

    @Override
    public boolean isValidAcceptor(TileEntity tile, EnumFacing side) {
        return GasUtils.isValidAcceptorOnSide(tile, side);
    }

    @Override
    public boolean isValidTransmitter(TileEntity tileEntity) {
        if (!super.isValidTransmitter(tileEntity)) {
            return false;
        }
        if (!(tileEntity instanceof TileEntityPressurizedTube)) {
            return true;
        }
        GasStack buffer = (GasStack)this.getBufferWithFallback();
        GasStack otherBuffer = (GasStack)((TileEntityPressurizedTube)tileEntity).getBufferWithFallback();
        return buffer == null || otherBuffer == null || buffer.isGasEqual(otherBuffer);
    }

    @Override
    public GasNetwork createNewNetwork() {
        return new GasNetwork();
    }

    @Override
    public GasNetwork createNetworkByMerging(Collection<GasNetwork> networks) {
        return new GasNetwork(networks);
    }

    @Override
    protected boolean canHaveIncompatibleNetworks() {
        return true;
    }

    @Override
    public int getCapacity() {
        return this.tier.getTubeCapacity();
    }

    @Override
    @Nullable
    public GasStack getBuffer() {
        if (this.buffer == null) {
            return null;
        }
        GasStack gas = this.buffer.getGas();
        return gas == null || gas.amount == 0 ? null : gas;
    }

    @Override
    public void takeShare() {
        if (this.getTransmitter().hasTransmitterNetwork() && ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).buffer != null && this.lastWrite != null) {
            ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).buffer.amount -= this.lastWrite.amount;
            this.buffer.setGas(this.lastWrite);
        }
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.getConnectionType(side) == TileEntitySidedPipe.ConnectionType.NORMAL || this.getConnectionType(side) == TileEntitySidedPipe.ConnectionType.PULL) {
            return this.takeGas(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        return null;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return this.getConnectionType(side) == TileEntitySidedPipe.ConnectionType.NORMAL || this.getConnectionType(side) == TileEntitySidedPipe.ConnectionType.PULL;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return false;
    }

    public int takeGas(GasStack gasStack, boolean doEmit) {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            return ((GasNetwork)this.getTransmitter().getTransmitterNetwork()).emit(gasStack, doEmit);
        }
        return this.buffer.receive(gasStack, doEmit);
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        if (this.getTransmitter().hasTransmitterNetwork()) {
            GasNetwork network = (GasNetwork)this.getTransmitter().getTransmitterNetwork();
            GasTank networkTank = new GasTank(network.getCapacity());
            networkTank.setGas(network.getBuffer());
            return new GasTankInfo[]{networkTank};
        }
        return new GasTankInfo[]{this.buffer};
    }

    @Override
    public IGasHandler getCachedAcceptor(EnumFacing side) {
        TileEntity tile = this.getCachedTile(side);
        if (CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.GAS_HANDLER_CAPABILITY, side.func_176734_d())) {
            return CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.GAS_HANDLER_CAPABILITY, side.func_176734_d());
        }
        return null;
    }

    @Override
    public boolean upgrade(int tierOrdinal) {
        if (this.tier.ordinal() < BaseTier.ULTIMATE.ordinal() && tierOrdinal == this.tier.ordinal() + 1) {
            this.tier = TubeTier.values()[this.tier.ordinal() + 1];
            this.markDirtyTransmitters();
            this.sendDesc = true;
            return true;
        }
        return false;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) throws Exception {
        this.tier = TubeTier.values()[dataStream.readInt()];
        super.handlePacketData(dataStream);
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        data.add(this.tier.ordinal());
        super.getNetworkedData(data);
        return data;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            if (side == null) {
                return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this.nullHandler);
            }
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }
}

