/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.IConfigurable;
import mekanism.api.TileNetworkList;
import mekanism.common.Upgrade;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISustainedTank;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.tile.prefab.TileEntityElectricBlock;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import mekanism.common.util.TileUtils;
import mekanism.tools.YLevelPriorityQueue;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityFluidicPlenisher
extends TileEntityElectricBlock
implements IConfigurable,
IFluidHandlerWrapper,
ISustainedTank,
ISecurityTile,
IUpgradeTile,
IRedstoneControl {
    private Set<BlockPos> visited = new HashSet<BlockPos>();
    private YLevelPriorityQueue airQueue = new YLevelPriorityQueue();
    public FluidTank fluidTank = new FluidTank(10000);
    public boolean active = true;
    public double BASE_ENERGY_PER_TICK;
    public double energyPerTick = this.BASE_ENERGY_PER_TICK = BlockStateMachine.MachineType.FLUIDIC_PLENISHER.getUsage();
    public int BASE_TICKS_REQUIRED;
    public int ticksRequired = this.BASE_TICKS_REQUIRED = 20;
    public int operatingTicks;
    private int counter = 0;
    private int maxActions = 50000;
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public TileComponentUpgrade upgradeComponent = new TileComponentUpgrade(this, 3);
    public TileComponentSecurity securityComponent = new TileComponentSecurity(this);

    public boolean isRunning() {
        return this.active;
    }

    public TileEntityFluidicPlenisher() {
        super("FluidicPlenisher", BlockStateMachine.MachineType.FLUIDIC_PLENISHER.getStorage());
        this.inventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    }

    private void fluidFiller() {
        ItemStack fluidContainer = (ItemStack)this.inventory.get(0);
        if (!fluidContainer.func_190926_b()) {
            ItemStack singleContainer = fluidContainer.func_77946_l();
            singleContainer.func_190920_e(1);
            FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)singleContainer, (IFluidHandler)this.fluidTank, (int)1000, null, (boolean)true);
            if (result.isSuccess()) {
                this.inventory.set(0, (Object)result.result);
                this.func_70296_d();
            }
        }
    }

    @Override
    public void onUpdate() {
        boolean hasLiquid;
        if (this.field_145850_b.field_72995_K || !this.active) {
            return;
        }
        ChargeUtils.discharge(2, this);
        this.fluidFiller();
        boolean hasEnergy = this.getEnergy() >= this.energyPerTick;
        boolean bl = hasLiquid = this.fluidTank.getFluid() != null && this.fluidTank.getFluidAmount() >= 1000;
        if (!(MekanismUtils.canFunction(this) && hasEnergy && hasLiquid)) {
            return;
        }
        if (this.operatingTicks + 1 < this.ticksRequired) {
            ++this.operatingTicks;
            return;
        }
        this.operatingTicks = 0;
        Boolean didWork = this.bfsAirSearch();
        if (didWork.booleanValue()) {
            this.setEnergy(this.getEnergy() - this.energyPerTick);
            this.fluidTank.drain(1000, true);
        }
    }

    private boolean bfsAirSearch() {
        if (this.airQueue.isEmpty()) {
            BlockPos initialPos = this.findInitialFillingPosition();
            if (initialPos == null) {
                this.active = false;
                return false;
            }
            this.airQueue.add(initialPos);
        }
        while (!this.airQueue.isEmpty()) {
            BlockPos current = this.airQueue.poll();
            if (!this.canPlaceFluid(current) || this.visited.contains(current)) continue;
            this.field_145850_b.func_180501_a(current, this.fluidTank.getFluid().getFluid().getBlock().func_176223_P(), 3);
            this.visited.add(current);
            ++this.counter;
            if (this.counter > this.maxActions) {
                this.active = false;
                return false;
            }
            this.addEligibleNeighbors(current);
            return true;
        }
        return false;
    }

    private void addEligibleNeighbors(BlockPos current) {
        for (EnumFacing direction : EnumFacing.values()) {
            BlockPos neighbor;
            if (direction == EnumFacing.UP && current.func_177956_o() >= this.field_174879_c.func_177956_o() - 1 || this.visited.contains(neighbor = current.func_177972_a(direction)) || !this.canPlaceFluid(neighbor)) continue;
            this.airQueue.add(neighbor);
        }
    }

    private BlockPos findInitialFillingPosition() {
        BlockPos start = this.field_174879_c.func_177977_b();
        while (start.func_177956_o() > 0 && this.canPlaceFluid(start)) {
            BlockPos below = start.func_177977_b();
            if (!this.canPlaceFluid(below)) {
                return start;
            }
            start = below;
        }
        return null;
    }

    private boolean canPlaceFluid(BlockPos pos) {
        if (!this.field_145850_b.func_175667_e(pos) || this.visited.contains(pos) || pos.func_177956_o() >= this.field_174879_c.func_177956_o()) {
            return false;
        }
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == Blocks.field_150355_j || block == Blocks.field_150358_i && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
            return false;
        }
        return this.field_145850_b.func_175623_d(pos) || state.func_185904_a().func_76222_j();
    }

    @Override
    public EnumActionResult onSneakRightClick(EntityPlayer player, EnumFacing side) {
        this.visited.clear();
        this.airQueue.clear();
        this.active = true;
        player.func_145747_a((ITextComponent)new TextComponentString("Plenisher calculation reset."));
        return EnumActionResult.SUCCESS;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.active = dataStream.readBoolean();
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            TileUtils.readTankData(dataStream, this.fluidTank);
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.active);
        data.add(this.controlType.ordinal());
        TileUtils.addTankData(data, this.fluidTank);
        return data;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("operatingTicks", this.operatingTicks);
        nbtTags.func_74757_a("active", this.active);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        if (this.fluidTank.getFluid() != null) {
            nbtTags.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        }
        return nbtTags;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.operatingTicks = nbtTags.func_74762_e("operatingTicks");
        this.active = nbtTags.func_74767_n("active");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        if (nbtTags.func_74764_b("fluidTank")) {
            this.fluidTank.readFromNBT(nbtTags.func_74775_l("fluidTank"));
        }
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        switch (slotID) {
            case 0: {
                return FluidUtil.getFluidContained((ItemStack)itemstack) != null && FluidUtil.getFluidContained((ItemStack)itemstack).getFluid().canBePlacedInWorld();
            }
            case 2: {
                return ChargeUtils.canBeDischarged(itemstack);
            }
        }
        return false;
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 2) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return false;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.CONFIGURABLE_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.CONFIGURABLE_CAPABILITY) {
            return (T)Capabilities.CONFIGURABLE_CAPABILITY.cast((Object)this);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandlerWrapper(this, side));
        }
        return super.getCapability(capability, side);
    }

    @Override
    public int fill(EnumFacing from, @Nonnull FluidStack resource, boolean doFill) {
        if (from == EnumFacing.UP && resource.getFluid().canBePlacedInWorld()) {
            return this.fluidTank.fill(resource, doFill);
        }
        return 0;
    }

    @Override
    public boolean canFill(EnumFacing from, @Nonnull FluidStack fluid) {
        return from == EnumFacing.UP && fluid.getFluid().canBePlacedInWorld();
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing direction) {
        if (direction == EnumFacing.UP) {
            return new FluidTankInfo[]{this.fluidTank.getInfo()};
        }
        return PipeUtils.EMPTY;
    }

    @Override
    public FluidTankInfo[] getAllTanks() {
        return this.getTankInfo(EnumFacing.UP);
    }

    @Override
    public void setFluidStack(FluidStack fluidStack, Object ... data) {
        this.fluidTank.setFluid(fluidStack);
    }

    @Override
    public FluidStack getFluidStack(Object ... data) {
        return this.fluidTank.getFluid();
    }

    @Override
    public boolean hasTank(Object ... data) {
        return true;
    }

    @Override
    public boolean sideIsConsumer(EnumFacing side) {
        return this.facing.func_176734_d() == side;
    }

    @Override
    public boolean canSetFacing(@Nonnull EnumFacing facing) {
        return facing != EnumFacing.DOWN && facing != EnumFacing.UP;
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        if (side == EnumFacing.UP) {
            return new int[]{0};
        }
        if (side == EnumFacing.DOWN) {
            return new int[]{1};
        }
        return new int[]{2};
    }

    @Override
    public EnumActionResult onRightClick(EntityPlayer player, EnumFacing side) {
        return EnumActionResult.PASS;
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        switch (upgrade) {
            case SPEED: {
                this.ticksRequired = MekanismUtils.getTicks(this, this.BASE_TICKS_REQUIRED);
            }
            case ENERGY: {
                this.energyPerTick = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK);
                this.maxEnergy = MekanismUtils.getMaxEnergy(this, this.BASE_MAX_ENERGY);
                this.setEnergy(Math.min(this.getMaxEnergy(), this.getEnergy()));
            }
        }
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }
}

