/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import java.util.List;
import mekanism.common.OreDictCache;
import mekanism.common.util.StackUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public abstract class Finder {
    public abstract boolean modifies(ItemStack var1);

    public static class ModIDFinder
    extends Finder {
        public String modID;

        public ModIDFinder(String mod) {
            this.modID = mod;
        }

        @Override
        public boolean modifies(ItemStack stack) {
            if (stack.func_190926_b()) {
                return false;
            }
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            return this.modID.equals(stack.func_82833_r());
        }
    }

    public static class MaterialFinder
    extends Finder {
        public Material materialType;

        public MaterialFinder(Material type) {
            this.materialType = type;
        }

        @Override
        public boolean modifies(ItemStack stack) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBlock)) {
                return false;
            }
            return Block.func_149634_a((Item)stack.func_77973_b()).func_176203_a(stack.func_77952_i()).func_185904_a() == this.materialType;
        }
    }

    public static class ItemStackFinder
    extends Finder {
        public ItemStack itemType;

        public ItemStackFinder(ItemStack type) {
            this.itemType = type;
        }

        @Override
        public boolean modifies(ItemStack stack) {
            return this.itemType.func_77981_g() ? StackUtils.equalsWildcard(this.itemType, stack) : this.itemType.func_77973_b() == stack.func_77973_b();
        }
    }

    public static class OreDictFinder
    extends Finder {
        public String oreDictName;

        public OreDictFinder(String name) {
            this.oreDictName = name;
        }

        @Override
        public boolean modifies(ItemStack stack) {
            List<String> oreKeys = OreDictCache.getOreDictName(stack);
            if (oreKeys.isEmpty()) {
                return false;
            }
            for (String oreKey : oreKeys) {
                if (this.oreDictName.equals(oreKey) || this.oreDictName.equals("*")) {
                    return true;
                }
                if (!(this.oreDictName.endsWith("*") && !this.oreDictName.startsWith("*") ? oreKey.startsWith(this.oreDictName.substring(0, this.oreDictName.length() - 1)) : (this.oreDictName.startsWith("*") && !this.oreDictName.endsWith("*") ? oreKey.endsWith(this.oreDictName.substring(1)) : this.oreDictName.startsWith("*") && this.oreDictName.endsWith("*") && oreKey.contains(this.oreDictName.substring(1, this.oreDictName.length() - 1))))) continue;
                return true;
            }
            return false;
        }
    }

    public static class FirstFinder
    extends Finder {
        @Override
        public boolean modifies(ItemStack stack) {
            return true;
        }
    }
}

