/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.command;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import javax.annotation.Nonnull;
import mekanism.api.MekanismAPI;
import mekanism.common.command.CommandChunk;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandGameRule;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.server.command.CommandTreeBase;

public class CommandMek
extends CommandTreeBase {
    private final Map<UUID, Stack<BlockPos>> tpStack = new HashMap<UUID, Stack<BlockPos>>();

    public CommandMek() {
        this.addSubcommand((ICommand)new Cmd("debug", "cmd.mek.debug", this::toggleDebug));
        this.addSubcommand((ICommand)new Cmd("testrules", "cmd.mek.testrules", this::setupTestRules));
        this.addSubcommand((ICommand)new Cmd("tp", "cmd.mek.tp", this::teleportPush));
        this.addSubcommand((ICommand)new Cmd("tpop", "cmd.mek.tpop", this::teleportPop));
        this.addSubcommand((ICommand)new CommandChunk());
    }

    public static void register(FMLServerStartingEvent event) {
        CommandMek cmd = new CommandMek();
        event.registerServerCommand((ICommand)cmd);
        event.registerServerCommand((ICommand)new Cmd("mtp", "cmd.mek.tp", cmd::teleportPush));
        event.registerServerCommand((ICommand)new Cmd("mtpop", "cmd.mek.tpop", cmd::teleportPop));
    }

    @Nonnull
    public String func_71517_b() {
        return "mek";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "cmd.mek.usage";
    }

    public void toggleDebug(MinecraftServer server, ICommandSender sender, String[] args) {
        MekanismAPI.debug = !MekanismAPI.debug;
        CommandBase.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"cmd.mek.debug", (Object[])new Object[]{MekanismAPI.debug});
    }

    public void setupTestRules(MinecraftServer server, ICommandSender sender, String[] args) {
        GameRules rules = server.func_130014_f_().func_82736_K();
        rules.func_82764_b("doMobSpawning", "false");
        rules.func_82764_b("doDaylightCycle", "false");
        rules.func_82764_b("doWeatherCycle", "false");
        server.func_130014_f_().func_72877_b(2000L);
        CommandGameRule.func_184898_a((GameRules)rules, (String)"", (MinecraftServer)server);
        CommandBase.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"cmd.mek.testrules", (Object[])new Object[0]);
    }

    public void teleportPush(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 3) {
            CommandMek.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"cmd.mek.tp.missing.args", (Object[])new Object[0]);
            return;
        }
        CommandBase.CoordinateArg xArg = CommandMek.func_175770_a((double)10.0, (String)args[0], (boolean)true);
        CommandBase.CoordinateArg yArg = CommandMek.func_175770_a((double)10.0, (String)args[1], (boolean)true);
        CommandBase.CoordinateArg zArg = CommandMek.func_175770_a((double)10.0, (String)args[2], (boolean)true);
        UUID player = sender.func_174793_f().func_110124_au();
        Stack<BlockPos> playerLocations = this.tpStack.getOrDefault(player, new Stack());
        playerLocations.push(sender.func_180425_c());
        this.tpStack.put(player, playerLocations);
        this.teleport(sender.func_174793_f(), xArg.func_179628_a(), yArg.func_179628_a(), zArg.func_179628_a());
        CommandMek.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"cmd.mek.tp", (Object[])new Object[]{args[0], args[1], args[2]});
    }

    public void teleportPop(MinecraftServer server, ICommandSender sender, String[] args) {
        UUID player = sender.func_174793_f().func_110124_au();
        Stack playerLocations = this.tpStack.getOrDefault(player, new Stack());
        if (!playerLocations.isEmpty()) {
            BlockPos lastPos = (BlockPos)playerLocations.pop();
            this.tpStack.put(player, playerLocations);
            this.teleport(sender.func_174793_f(), lastPos.func_177958_n(), lastPos.func_177956_o(), lastPos.func_177952_p());
            CommandMek.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"cmd.mek.tpop", (Object[])new Object[]{lastPos.func_177958_n(), lastPos.func_177956_o(), lastPos.func_177952_p(), playerLocations.size()});
        } else {
            CommandMek.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"cmd.mek.tpop.empty.stack", (Object[])new Object[0]);
        }
    }

    private void teleport(Entity player, double x, double y, double z) {
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP mp = (EntityPlayerMP)player;
            mp.field_71135_a.func_147364_a(x, y, z, mp.field_70177_z, mp.field_70125_A);
        } else {
            EntityPlayerSP sp = (EntityPlayerSP)player;
            sp.func_70012_b(x, y, z, sp.field_70177_z, sp.field_70125_A);
        }
    }

    static interface CmdExecute {
        public void execute(MinecraftServer var1, ICommandSender var2, String[] var3) throws CommandException;
    }

    public static class Cmd
    extends CommandBase {
        private final String name;
        private final String usage;
        private final CmdExecute ex;

        Cmd(String name, String usage, CmdExecute ex) {
            this.name = name;
            this.usage = usage;
            this.ex = ex;
        }

        @Nonnull
        public String func_71517_b() {
            return this.name;
        }

        @Nonnull
        public String func_71518_a(@Nonnull ICommandSender sender) {
            return this.usage + ".usage";
        }

        public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
            this.ex.execute(server, sender, args);
        }
    }
}

