/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.command;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.common.command.CommandMek;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.server.command.CommandTreeBase;

public class CommandChunk
extends CommandTreeBase {
    private final Set<Long> chunkWatchers = new HashSet<Long>();

    public CommandChunk() {
        this.addSubcommand((ICommand)new CommandMek.Cmd("watch", "cmd.mek.chunk.watch", this::addWatcher));
        this.addSubcommand((ICommand)new CommandMek.Cmd("unwatch", "cmd.mek.chunk.unwatch", this::removeWatcher));
        this.addSubcommand((ICommand)new CommandMek.Cmd("clear", "cmd.mek.chunk.clear", this::clearWatchers));
        this.addSubcommand((ICommand)new CommandMek.Cmd("flush", "cmd.mek.chunk.flush", this::flushChunks));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Nonnull
    public String func_71517_b() {
        return "chunk";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "cmd.mek.chunk.usage";
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load event) {
        this.handleChunkEvent((ChunkEvent)event, "Loaded");
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        this.handleChunkEvent((ChunkEvent)event, "Unloaded");
    }

    private void handleChunkEvent(ChunkEvent event, String direction) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        ChunkPos pos = event.getChunk().func_76632_l();
        long key = ChunkPos.func_77272_a((int)pos.field_77276_a, (int)pos.field_77275_b);
        if (this.chunkWatchers.contains(key)) {
            String msg = String.format("%s chunk %d, %d", direction, pos.field_77276_a, pos.field_77275_b);
            MinecraftServer server = event.getWorld().func_73046_m();
            if (server != null) {
                server.func_184103_al().func_148539_a((ITextComponent)new TextComponentString(msg));
            }
        }
    }

    public void addWatcher(MinecraftServer server, ICommandSender sender, String[] args) {
        ChunkPos cpos = new ChunkPos(sender.func_180425_c());
        this.chunkWatchers.add(ChunkPos.func_77272_a((int)cpos.field_77276_a, (int)cpos.field_77275_b));
        CommandBase.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"cmd.mek.chunk.watch", (Object[])new Object[]{cpos.field_77276_a, cpos.field_77275_b});
    }

    public void removeWatcher(MinecraftServer server, ICommandSender sender, String[] args) {
        ChunkPos cpos = new ChunkPos(sender.func_180425_c());
        this.chunkWatchers.remove(ChunkPos.func_77272_a((int)cpos.field_77276_a, (int)cpos.field_77275_b));
        CommandBase.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"cmd.mek.chunk.unwatch", (Object[])new Object[]{cpos.field_77276_a, cpos.field_77275_b});
    }

    public void clearWatchers(MinecraftServer server, ICommandSender sender, String[] args) {
        int count = this.chunkWatchers.size();
        this.chunkWatchers.clear();
        CommandBase.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"cmd.mek.chunk.clear", (Object[])new Object[]{count});
    }

    public void flushChunks(MinecraftServer server, ICommandSender sender, String[] args) {
        if (sender.func_130014_f_().field_72995_K) {
            return;
        }
        ChunkProviderServer sp = (ChunkProviderServer)sender.func_130014_f_().func_72863_F();
        int startCount = sp.func_73152_e();
        sp.func_73240_a();
        sp.func_73156_b();
        CommandChunk.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"cmd.mek.chunk.flush", (Object[])new Object[]{startCount - sp.func_73152_e()});
    }
}

