/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import javax.annotation.Nonnull;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.block.BlockMekanismContainer;
import mekanism.common.block.states.BlockStateCardboardBox;
import mekanism.common.item.ItemBlockCardboardBox;
import mekanism.common.tile.TileEntityCardboardBox;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BlockCardboardBox
extends BlockMekanismContainer {
    private static boolean testingPlace = false;

    public BlockCardboardBox() {
        super(Material.field_151580_n);
        this.func_149647_a(Mekanism.tabMekanism);
        this.func_149711_c(0.5f);
        this.func_149752_b(1.0f);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateCardboardBox(this);
    }

    @Nonnull
    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockStateCardboardBox.storageProperty, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BlockStateCardboardBox.storageProperty) != false ? 1 : 0;
    }

    public boolean func_176200_f(IBlockAccess world, @Nonnull BlockPos pos) {
        return testingPlace;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityplayer, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && entityplayer.func_70093_af()) {
            TileEntityCardboardBox tileEntity = (TileEntityCardboardBox)world.func_175625_s(pos);
            if (tileEntity.storedData != null) {
                BlockData data = tileEntity.storedData;
                testingPlace = true;
                if (!data.block.func_176196_c(world, pos)) {
                    testingPlace = false;
                    return true;
                }
                testingPlace = false;
                if (data.block != null) {
                    IBlockState newstate = data.block.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, data.meta, (EntityLivingBase)entityplayer, hand);
                    data.meta = newstate.func_177230_c().func_176201_c(newstate);
                }
                world.func_180501_a(pos, data.block.func_176203_a(data.meta), 3);
                if (data.tileTag != null && world.func_175625_s(pos) != null) {
                    data.updateLocation(pos);
                    world.func_175625_s(pos).func_145839_a(data.tileTag);
                }
                if (data.block != null) {
                    data.block.func_180633_a(world, pos, data.block.func_176203_a(data.meta), (EntityLivingBase)entityplayer, new ItemStack(data.block, 1, data.meta));
                }
                BlockCardboardBox.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(MekanismBlocks.CardboardBox));
            }
        }
        return entityplayer.func_70093_af();
    }

    @Nonnull
    @Deprecated
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public TileEntity func_149915_a(@Nonnull World world, int meta) {
        return new TileEntityCardboardBox();
    }

    @Override
    @Nonnull
    protected ItemStack getDropItem(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        TileEntityCardboardBox tileEntity = (TileEntityCardboardBox)world.func_175625_s(pos);
        Item item = Item.func_150898_a((Block)state.func_177230_c());
        ItemStack itemStack = new ItemStack(item, 1, state.func_177230_c().func_176201_c(state));
        if (tileEntity.storedData != null) {
            ((ItemBlockCardboardBox)item).setBlockData(itemStack, tileEntity.storedData);
        }
        return itemStack;
    }

    @SubscribeEvent
    public void rightClickEvent(PlayerInteractEvent.RightClickBlock blockEvent) {
        if (blockEvent.getEntityPlayer().func_70093_af() && blockEvent.getWorld().func_180495_p(blockEvent.getPos()).func_177230_c() == this) {
            blockEvent.setUseBlock(Event.Result.ALLOW);
            blockEvent.setUseItem(Event.Result.DENY);
        }
    }

    public static class BlockData {
        public Block block;
        public int meta;
        public NBTTagCompound tileTag;

        public BlockData(Block b, int j, NBTTagCompound nbtTags) {
            this.block = b;
            this.meta = j;
            this.tileTag = nbtTags;
        }

        public BlockData() {
        }

        public static BlockData read(NBTTagCompound nbtTags) {
            BlockData data = new BlockData();
            data.block = Block.func_149729_e((int)nbtTags.func_74762_e("id"));
            data.meta = nbtTags.func_74762_e("meta");
            if (nbtTags.func_74764_b("tileTag")) {
                data.tileTag = nbtTags.func_74775_l("tileTag");
            }
            return data;
        }

        public void updateLocation(BlockPos pos) {
            if (this.tileTag != null) {
                this.tileTag.func_74768_a("x", pos.func_177958_n());
                this.tileTag.func_74768_a("y", pos.func_177956_o());
                this.tileTag.func_74768_a("z", pos.func_177952_p());
            }
        }

        public NBTTagCompound write(NBTTagCompound nbtTags) {
            nbtTags.func_74768_a("id", Block.func_149682_b((Block)this.block));
            nbtTags.func_74768_a("meta", this.meta);
            if (this.tileTag != null) {
                nbtTags.func_74782_a("tileTag", (NBTBase)this.tileTag);
            }
            return nbtTags;
        }
    }
}

