/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base;

import javax.annotation.Nullable;
import mekanism.common.tile.TileEntityMultiblock;
import mekanism.common.util.MekanismUtils;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public abstract class MultiblockFluidTank<MULTIBLOCK extends TileEntityMultiblock>
implements IFluidTank {
    protected final MULTIBLOCK multiblock;

    protected MultiblockFluidTank(MULTIBLOCK multiblock) {
        this.multiblock = multiblock;
    }

    public abstract void setFluid(FluidStack var1);

    protected abstract void updateValveData();

    public int fill(@Nullable FluidStack resource, boolean doFill) {
        if (((TileEntityMultiblock)this.multiblock).structure != null && !this.multiblock.func_145831_w().field_72995_K) {
            if (resource == null) {
                return 0;
            }
            FluidStack fluidStack = this.getFluid();
            if (fluidStack != null && !fluidStack.isFluidEqual(resource)) {
                return 0;
            }
            if (fluidStack == null) {
                if (resource.amount <= this.getCapacity()) {
                    if (doFill) {
                        fluidStack = resource.copy();
                        this.setFluid(fluidStack);
                        if (resource.amount > 0) {
                            MekanismUtils.saveChunk(this.multiblock);
                            this.updateValveData();
                        }
                    }
                    return resource.amount;
                }
                if (doFill) {
                    fluidStack = resource.copy();
                    this.setFluid(fluidStack);
                    fluidStack.amount = this.getCapacity();
                    if (this.getCapacity() > 0) {
                        MekanismUtils.saveChunk(this.multiblock);
                        this.updateValveData();
                    }
                }
                return this.getCapacity();
            }
            int needed = this.getCapacity() - fluidStack.amount;
            if (resource.amount <= needed) {
                if (doFill) {
                    fluidStack.amount += resource.amount;
                    if (resource.amount > 0) {
                        MekanismUtils.saveChunk(this.multiblock);
                        this.updateValveData();
                    }
                }
                return resource.amount;
            }
            if (doFill) {
                fluidStack.amount = this.getCapacity();
                if (needed > 0) {
                    MekanismUtils.saveChunk(this.multiblock);
                    this.updateValveData();
                }
            }
            return needed;
        }
        return 0;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (((TileEntityMultiblock)this.multiblock).structure != null && !this.multiblock.func_145831_w().field_72995_K) {
            FluidStack fluidStack = this.getFluid();
            if (fluidStack == null || fluidStack.amount <= 0) {
                return null;
            }
            int used = maxDrain;
            if (fluidStack.amount < used) {
                used = fluidStack.amount;
            }
            if (doDrain) {
                fluidStack.amount -= used;
            }
            FluidStack drained = new FluidStack(fluidStack, used);
            if (fluidStack.amount <= 0) {
                this.setFluid(null);
            }
            if (drained.amount > 0 && doDrain) {
                MekanismUtils.saveChunk(this.multiblock);
                ((TileEntityMultiblock)this.multiblock).sendPacketToRenderer();
            }
            return drained;
        }
        return null;
    }

    public int getFluidAmount() {
        if (((TileEntityMultiblock)this.multiblock).structure != null) {
            FluidStack fluid = this.getFluid();
            return fluid == null ? 0 : fluid.amount;
        }
        return 0;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }
}

