/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.SideData;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.tile.component.TileComponentConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderConfigurableMachine<S extends TileEntity>
extends TileEntitySpecialRenderer<S> {
    private final Minecraft mc = FMLClientHandler.instance().getClient();
    private final Map<EnumFacing, Map<TransmissionType, MekanismRenderer.DisplayInteger>> cachedOverlays = new EnumMap<EnumFacing, Map<TransmissionType, MekanismRenderer.DisplayInteger>>(EnumFacing.class);

    public RenderConfigurableMachine() {
        this.field_147501_a = TileEntityRendererDispatcher.field_147556_a;
    }

    public void func_192841_a(S configurable, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        RayTraceResult pos;
        ItemStack itemStack = this.mc.field_71439_g.field_71071_by.func_70448_g();
        Item item = itemStack.func_77973_b();
        if (!itemStack.func_190926_b() && item instanceof ItemConfigurator && ((ItemConfigurator)item).getState(itemStack).isConfigurating() && (pos = this.mc.field_71439_g.func_174822_a(8.0, 1.0f)) != null) {
            SideData data;
            BlockPos bp = pos.func_178782_a();
            TransmissionType type = Objects.requireNonNull(((ItemConfigurator)item).getState(itemStack).getTransmission(), "Configurating state requires transmission type");
            if (((ISideConfiguration)configurable).getConfig().supports(type) && bp.equals((Object)configurable.func_174877_v()) && (data = ((ISideConfiguration)configurable).getConfig().getOutput(type, pos.field_178784_b, ((ISideConfiguration)configurable).getOrientation())) != TileComponentConfig.EMPTY) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179089_o();
                GlStateManager.func_179140_f();
                MekanismRenderer.GlowInfo glowInfo = MekanismRenderer.enableGlow();
                GlStateManager.func_179103_j((int)7425);
                GlStateManager.func_179118_c();
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                MekanismRenderer.color(data.color, 0.6f);
                this.func_147499_a(TextureMap.field_110575_b);
                GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
                int display = this.getOverlayDisplay((EnumFacing)pos.field_178784_b, (TransmissionType)type).display;
                GlStateManager.func_179148_o((int)display);
                MekanismRenderer.resetColor();
                GlStateManager.func_179084_k();
                GlStateManager.func_179141_d();
                MekanismRenderer.disableGlow(glowInfo);
                GlStateManager.func_179145_e();
                GlStateManager.func_179129_p();
                GlStateManager.func_179121_F();
            }
        }
    }

    private MekanismRenderer.DisplayInteger getOverlayDisplay(EnumFacing side, TransmissionType type) {
        if (this.cachedOverlays.containsKey(side) && this.cachedOverlays.get(side).containsKey((Object)type)) {
            return this.cachedOverlays.get(side).get((Object)type);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Blocks.field_150348_b;
        toReturn.setTexture(MekanismRenderer.overlays.get((Object)type));
        MekanismRenderer.DisplayInteger display = MekanismRenderer.DisplayInteger.createAndStart();
        if (this.cachedOverlays.containsKey(side)) {
            this.cachedOverlays.get(side).put(type, display);
        } else {
            EnumMap<TransmissionType, MekanismRenderer.DisplayInteger> map = new EnumMap<TransmissionType, MekanismRenderer.DisplayInteger>(TransmissionType.class);
            map.put(type, display);
            this.cachedOverlays.put(side, map);
        }
        switch (side) {
            case DOWN: {
                toReturn.minY = -0.01;
                toReturn.maxY = -0.001;
                toReturn.minX = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case UP: {
                toReturn.minY = 1.001;
                toReturn.maxY = 1.01;
                toReturn.minX = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case NORTH: {
                toReturn.minZ = -0.01;
                toReturn.maxZ = -0.001;
                toReturn.minX = 0.0;
                toReturn.minY = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxY = 1.0;
                break;
            }
            case SOUTH: {
                toReturn.minZ = 1.001;
                toReturn.maxZ = 1.01;
                toReturn.minX = 0.0;
                toReturn.minY = 0.0;
                toReturn.maxX = 1.0;
                toReturn.maxY = 1.0;
                break;
            }
            case WEST: {
                toReturn.minX = -0.01;
                toReturn.maxX = -0.001;
                toReturn.minY = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxY = 1.0;
                toReturn.maxZ = 1.0;
                break;
            }
            case EAST: {
                toReturn.minX = 1.001;
                toReturn.maxX = 1.01;
                toReturn.minY = 0.0;
                toReturn.minZ = 0.0;
                toReturn.maxY = 1.0;
                toReturn.maxZ = 1.0;
            }
        }
        MekanismRenderer.renderObject(toReturn);
        MekanismRenderer.DisplayInteger.endList();
        return display;
    }
}

