/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei;

import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.GasStackHelper;
import mekanism.client.jei.GuiElementHandler;
import mekanism.client.jei.RecipeRegistryHelper;
import mekanism.client.jei.gas.GasStackRenderer;
import mekanism.client.jei.machine.AdvancedMachineRecipeCategory;
import mekanism.client.jei.machine.ChanceMachineRecipeCategory;
import mekanism.client.jei.machine.DoubleMachineRecipeCategory;
import mekanism.client.jei.machine.MachineRecipeCategory;
import mekanism.client.jei.machine.chemical.ChemicalCrystallizerRecipeCategory;
import mekanism.client.jei.machine.chemical.ChemicalDissolutionChamberRecipeCategory;
import mekanism.client.jei.machine.chemical.ChemicalInfuserRecipeCategory;
import mekanism.client.jei.machine.chemical.ChemicalOxidizerRecipeCategory;
import mekanism.client.jei.machine.chemical.ChemicalWasherRecipeCategory;
import mekanism.client.jei.machine.other.ElectrolyticSeparatorRecipeCategory;
import mekanism.client.jei.machine.other.MetallurgicInfuserRecipeCategory;
import mekanism.client.jei.machine.other.PRCRecipeCategory;
import mekanism.client.jei.machine.other.RotaryCondensentratorRecipeCategory;
import mekanism.client.jei.machine.other.SolarNeutronRecipeCategory;
import mekanism.client.jei.machine.other.ThermalEvaporationRecipeCategory;
import mekanism.common.MekanismBlocks;
import mekanism.common.MekanismItems;
import mekanism.common.base.IFactory;
import mekanism.common.base.ITierItem;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.inventory.container.robit.ContainerRobitInventory;
import mekanism.common.item.ItemBlockEnergyCube;
import mekanism.common.item.ItemBlockGasTank;
import mekanism.common.recipe.RecipeHandler;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class MekanismJEI
implements IModPlugin {
    public static final IIngredientType<GasStack> TYPE_GAS = () -> GasStack.class;
    public static final ISubtypeRegistry.ISubtypeInterpreter NBT_INTERPRETER = itemStack -> {
        GasStack gasStack;
        IFactory.RecipeType recipeType;
        String ret = Integer.toString(itemStack.func_77960_j());
        if (itemStack.func_77973_b() instanceof ITierItem) {
            ret = ret + ":" + ((ITierItem)itemStack.func_77973_b()).getBaseTier(itemStack).getSimpleName();
        }
        if (itemStack.func_77973_b() instanceof IFactory && (recipeType = ((IFactory)itemStack.func_77973_b()).getRecipeTypeOrNull(itemStack)) != null) {
            ret = ret + ":" + recipeType.func_176610_l();
        }
        if (itemStack.func_77973_b() instanceof ItemBlockGasTank && (gasStack = ((ItemBlockGasTank)itemStack.func_77973_b()).getGas(itemStack)) != null) {
            ret = ret + ":" + gasStack.getGas().getName();
        }
        if (itemStack.func_77973_b() instanceof ItemBlockEnergyCube) {
            ret = ret + ":" + (((ItemBlockEnergyCube)itemStack.func_77973_b()).getEnergy(itemStack) > 0.0 ? "filled" : "empty");
        }
        return ret.toLowerCase(Locale.ROOT);
    };

    public void registerItemSubtypes(ISubtypeRegistry registry) {
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.EnergyCube), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.MachineBlock), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.MachineBlock2), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.MachineBlock3), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.BasicBlock), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.BasicBlock2), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.GasTank), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.CardboardBox), NBT_INTERPRETER);
        registry.registerSubtypeInterpreter(Item.func_150898_a((Block)MekanismBlocks.Transmitter), NBT_INTERPRETER);
    }

    public void registerIngredients(IModIngredientRegistration registry) {
        List list = GasRegistry.getRegisteredGasses().stream().filter(Gas::isVisible).map(g -> new GasStack((Gas)g, 1000)).collect(Collectors.toList());
        registry.register(TYPE_GAS, list, (IIngredientHelper)new GasStackHelper(), (IIngredientRenderer)new GasStackRenderer());
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        this.addRecipeCategory(registry, BlockStateMachine.MachineType.CHEMICAL_CRYSTALLIZER, new ChemicalCrystallizerRecipeCategory(guiHelper));
        this.addRecipeCategory(registry, BlockStateMachine.MachineType.CHEMICAL_DISSOLUTION_CHAMBER, new ChemicalDissolutionChamberRecipeCategory(guiHelper));
        this.addRecipeCategory(registry, BlockStateMachine.MachineType.CHEMICAL_INFUSER, new ChemicalInfuserRecipeCategory(guiHelper));
        this.addRecipeCategory(registry, BlockStateMachine.MachineType.CHEMICAL_OXIDIZER, new ChemicalOxidizerRecipeCategory(guiHelper));
        this.addRecipeCategory(registry, BlockStateMachine.MachineType.CHEMICAL_WASHER, new ChemicalWasherRecipeCategory(guiHelper));
        this.addRecipeCategory(registry, BlockStateMachine.MachineType.ELECTROLYTIC_SEPARATOR, new ElectrolyticSeparatorRecipeCategory(guiHelper));
        this.addRecipeCategory(registry, BlockStateMachine.MachineType.METALLURGIC_INFUSER, new MetallurgicInfuserRecipeCategory(guiHelper));
        this.addRecipeCategory(registry, BlockStateMachine.MachineType.PRESSURIZED_REACTION_CHAMBER, new PRCRecipeCategory(guiHelper));
        this.addRecipeCategory(registry, BlockStateMachine.MachineType.ROTARY_CONDENSENTRATOR, new RotaryCondensentratorRecipeCategory(guiHelper, true));
        this.addRecipeCategory(registry, BlockStateMachine.MachineType.ROTARY_CONDENSENTRATOR, new RotaryCondensentratorRecipeCategory(guiHelper, false));
        this.addRecipeCategory(registry, BlockStateMachine.MachineType.SOLAR_NEUTRON_ACTIVATOR, new SolarNeutronRecipeCategory(guiHelper));
        this.addRecipeCategory(registry, BlockStateMachine.MachineType.COMBINER, new DoubleMachineRecipeCategory(guiHelper, RecipeHandler.Recipe.COMBINER.getJEICategory(), "tile.MachineBlock.Combiner.name", GuiProgress.ProgressBar.STONE));
        this.addRecipeCategory(registry, BlockStateMachine.MachineType.PURIFICATION_CHAMBER, new AdvancedMachineRecipeCategory(guiHelper, RecipeHandler.Recipe.PURIFICATION_CHAMBER.getJEICategory(), "tile.MachineBlock.PurificationChamber.name", GuiProgress.ProgressBar.RED));
        this.addRecipeCategory(registry, BlockStateMachine.MachineType.OSMIUM_COMPRESSOR, new AdvancedMachineRecipeCategory(guiHelper, RecipeHandler.Recipe.OSMIUM_COMPRESSOR.getJEICategory(), "tile.MachineBlock.OsmiumCompressor.name", GuiProgress.ProgressBar.RED));
        this.addRecipeCategory(registry, BlockStateMachine.MachineType.CHEMICAL_INJECTION_CHAMBER, new AdvancedMachineRecipeCategory(guiHelper, RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER.getJEICategory(), "tile.MachineBlock2.ChemicalInjectionChamber.name", GuiProgress.ProgressBar.YELLOW));
        this.addRecipeCategory(registry, BlockStateMachine.MachineType.PRECISION_SAWMILL, new ChanceMachineRecipeCategory(guiHelper, RecipeHandler.Recipe.PRECISION_SAWMILL.getJEICategory(), "tile.MachineBlock2.PrecisionSawmill.name", GuiProgress.ProgressBar.PURPLE));
        this.addRecipeCategory(registry, BlockStateMachine.MachineType.ENRICHMENT_CHAMBER, new MachineRecipeCategory(guiHelper, RecipeHandler.Recipe.ENRICHMENT_CHAMBER.getJEICategory(), "tile.MachineBlock.EnrichmentChamber.name", GuiProgress.ProgressBar.BLUE));
        this.addRecipeCategory(registry, BlockStateMachine.MachineType.CRUSHER, new MachineRecipeCategory(guiHelper, RecipeHandler.Recipe.CRUSHER.getJEICategory(), "tile.MachineBlock.Crusher.name", GuiProgress.ProgressBar.CRUSH));
        this.addRecipeCategory(registry, BlockStateMachine.MachineType.ENERGIZED_SMELTER, new MachineRecipeCategory(guiHelper, RecipeHandler.Recipe.ENERGIZED_SMELTER.getJEICategory(), "tile.MachineBlock.EnergizedSmelter.name", GuiProgress.ProgressBar.BLUE));
        registry.addRecipeCategories(new IRecipeCategory[]{new ThermalEvaporationRecipeCategory(guiHelper)});
    }

    private void addRecipeCategory(IRecipeCategoryRegistration registry, BlockStateMachine.MachineType type, BaseRecipeCategory category) {
        if (type.isEnabled()) {
            registry.addRecipeCategories(new IRecipeCategory[]{category});
        }
    }

    public void register(IModRegistry registry) {
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new GuiElementHandler()});
        IIngredientBlacklist ingredientBlacklist = registry.getJeiHelpers().getIngredientBlacklist();
        ingredientBlacklist.addIngredientToBlacklist((Object)new ItemStack(MekanismItems.ItemProxy));
        ingredientBlacklist.addIngredientToBlacklist((Object)new ItemStack(MekanismBlocks.BoundingBlock));
        RecipeRegistryHelper.registerEnrichmentChamber(registry);
        RecipeRegistryHelper.registerCrusher(registry);
        RecipeRegistryHelper.registerCombiner(registry);
        RecipeRegistryHelper.registerPurification(registry);
        RecipeRegistryHelper.registerCompressor(registry);
        RecipeRegistryHelper.registerInjection(registry);
        RecipeRegistryHelper.registerSawmill(registry);
        RecipeRegistryHelper.registerMetallurgicInfuser(registry);
        RecipeRegistryHelper.registerCrystallizer(registry);
        RecipeRegistryHelper.registerDissolution(registry);
        RecipeRegistryHelper.registerChemicalInfuser(registry);
        RecipeRegistryHelper.registerOxidizer(registry);
        RecipeRegistryHelper.registerWasher(registry);
        RecipeRegistryHelper.registerNeutronActivator(registry);
        RecipeRegistryHelper.registerSeparator(registry);
        RecipeRegistryHelper.registerEvaporationPlant(registry);
        RecipeRegistryHelper.registerReactionChamber(registry);
        RecipeRegistryHelper.registerCondensentrator(registry);
        RecipeRegistryHelper.registerSmelter(registry);
        RecipeRegistryHelper.registerFormulaicAssemblicator(registry);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerRobitInventory.class, "minecraft.crafting", 1, 9, 10, 36);
    }
}

