/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.util;

import com.barribob.MaelstromMod.Main;
import com.barribob.MaelstromMod.config.ModConfig;
import com.barribob.MaelstromMod.entity.entities.EntityLeveledMob;
import com.barribob.MaelstromMod.entity.entities.EntityMaelstromHealer;
import com.barribob.MaelstromMod.entity.entities.EntityMaelstromMob;
import com.barribob.MaelstromMod.entity.particleSpawners.ParticleSpawnerSwordSwing;
import com.barribob.MaelstromMod.entity.projectile.Projectile;
import com.barribob.MaelstromMod.entity.tileentity.MobSpawnerLogic;
import com.barribob.MaelstromMod.entity.util.IPitch;
import com.barribob.MaelstromMod.packets.MessageModParticles;
import com.barribob.MaelstromMod.particle.EnumModParticles;
import com.barribob.MaelstromMod.util.Element;
import com.barribob.MaelstromMod.util.IElement;
import com.barribob.MaelstromMod.util.ModDamageSource;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.handlers.LevelHandler;
import com.google.common.collect.Sets;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigRenderOptions;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import openblocks.OpenBlocks;

public final class ModUtils {
    public static char AZURE_SYMBOL = (char)934;
    public static char GOLDEN_SYMBOL = (char)937;
    public static char CRIMSON_SYMBOL = (char)931;
    public static byte PARTICLE_BYTE = (byte)12;
    public static byte SECOND_PARTICLE_BYTE = (byte)14;
    public static byte THIRD_PARTICLE_BYTE = (byte)15;
    public static byte FOURTH_PARTICLE_BYTE = (byte)16;
    public static Vec3d X_AXIS = new Vec3d(1.0, 0.0, 0.0);
    public static Vec3d Y_AXIS = new Vec3d(0.0, 1.0, 0.0);
    public static Vec3d Z_AXIS = new Vec3d(0.0, 0.0, 1.0);
    public static byte MAELSTROM_PARTICLE_BYTE = (byte)17;
    public static final String LANG_DESC = "mm.desc.";
    public static final String LANG_CHAT = "mm.dialog.";
    public static final DecimalFormat DF_0 = new DecimalFormat("0.0");
    public static final DecimalFormat ROUND = new DecimalFormat("0");
    public static final ResourceLocation PARTICLE = new ResourceLocation("mm:textures/particle/particles.png");

    public static Consumer<String> getPlayerAreaMessager(Entity entity) {
        return message -> {
            if (message != "") {
                for (EntityPlayer player : entity.field_70170_p.func_175661_b(EntityPlayer.class, p -> p.func_70068_e(entity) < 100.0)) {
                    player.func_145747_a(new TextComponentString(TextFormatting.DARK_PURPLE + entity.func_145748_c_().func_150254_d() + ": " + TextFormatting.WHITE).func_150257_a((ITextComponent)new TextComponentTranslation(LANG_CHAT + message, new Object[0])));
                }
            }
        };
    }

    public static String translateDesc(String key, Object ... params) {
        return I18n.func_135052_a((String)(LANG_DESC + key), (Object[])params);
    }

    public static String translateDialog(String key) {
        return I18n.func_135052_a((String)(LANG_CHAT + key), (Object[])new Object[0]);
    }

    public static String getDisplayLevel(float level) {
        return ModUtils.translateDesc("level", "" + TextFormatting.DARK_PURPLE + Math.round(level));
    }

    public static String getElementalTooltip(Element element) {
        return ModUtils.translateDesc("elemental_damage_desc", "x" + DF_0.format(ModConfig.balance.elemental_factor), element.textColor + element.symbol + TextFormatting.GRAY);
    }

    public static boolean chunksGenerated(StructureBoundingBox box, World world) {
        return world.func_190526_b(box.field_78897_a >> 4, box.field_78896_c >> 4) || world.func_190526_b(box.field_78897_a >> 4, box.field_78892_f >> 4) || world.func_190526_b(box.field_78893_d >> 4, box.field_78896_c >> 4) || world.func_190526_b(box.field_78893_d >> 4, box.field_78892_f >> 4);
    }

    public static void performNTimes(int n, Consumer<Integer> func) {
        for (int i = 0; i < n; ++i) {
            func.accept(i);
        }
    }

    public static List<EntityLivingBase> getEntitiesInBox(Entity entity, AxisAlignedBB bb) {
        List list = entity.field_70170_p.func_72839_b(entity, bb);
        Predicate<Entity> isInstance = i -> i instanceof EntityLivingBase;
        Function<Entity, EntityLivingBase> cast = i -> (EntityLivingBase)i;
        return list.stream().filter(isInstance).map(cast).collect(Collectors.toList());
    }

    public static Vec3d entityPos(Entity entity) {
        return new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public static void generateN(World worldIn, Random rand, BlockPos pos, int n, int baseY, int randY, WorldGenerator gen) {
        randY = randY > 0 ? randY : 1;
        for (int i = 0; i < n; ++i) {
            int x = rand.nextInt(16) + 8;
            int y = rand.nextInt(randY) + baseY;
            int z = rand.nextInt(16) + 8;
            gen.func_180709_b(worldIn, rand, pos.func_177982_a(x, y, z));
        }
    }

    public static BlockPos posToChunk(BlockPos pos) {
        return new BlockPos((double)((float)pos.func_177958_n() / 16.0f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() / 16.0f));
    }

    public static Vec3d getVectorForRotation(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static Vec3d yVec(double heightAboveGround) {
        return new Vec3d(0.0, heightAboveGround, 0.0);
    }

    public static void handleAreaImpact(float radius, Function<Entity, Float> maxDamage, Entity source, Vec3d pos, DamageSource damageSource) {
        ModUtils.handleAreaImpact(radius, maxDamage, source, pos, damageSource, 1.0f, 0);
    }

    public static void handleAreaImpact(float radius, Function<Entity, Float> maxDamage, Entity source, Vec3d pos, DamageSource damageSource, float knockbackFactor, int fireFactor) {
        ModUtils.handleAreaImpact(radius, maxDamage, source, pos, damageSource, knockbackFactor, fireFactor, true);
    }

    private static Vec3d getCenter(AxisAlignedBB box) {
        return new Vec3d(box.field_72340_a + (box.field_72336_d - box.field_72340_a) * 0.5, box.field_72338_b + (box.field_72337_e - box.field_72338_b) * 0.5, box.field_72339_c + (box.field_72334_f - box.field_72339_c) * 0.5);
    }

    public static void handleAreaImpact(float radius, Function<Entity, Float> maxDamage, Entity source, Vec3d pos, DamageSource damageSource, float knockbackFactor, int fireFactor, boolean damageDecay) {
        if (source == null) {
            return;
        }
        List list = source.field_70170_p.func_72839_b(source, new AxisAlignedBB(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c).func_186662_g((double)radius));
        Predicate<Entity> isInstance = i -> i instanceof EntityLivingBase || i instanceof MultiPartEntityPart || i.func_70067_L();
        double radiusSq = Math.pow(radius, 2.0);
        list.stream().filter(isInstance).forEach(entity -> {
            double avgEntitySize = entity.func_174813_aQ().func_72320_b() * 0.75;
            double distance = Math.min(Math.min(ModUtils.getCenter(entity.func_174813_aQ()).func_72438_d(pos), entity.func_174791_d().func_178787_e(ModUtils.yVec(entity.func_70047_e())).func_72438_d(pos)), entity.func_174791_d().func_72438_d(pos));
            double adjustedDistance = Math.max(distance - avgEntitySize, 0.0);
            double adjustedDistanceSq = Math.pow(adjustedDistance, 2.0);
            double damageFactor = damageDecay ? Math.max(0.0, Math.min(1.0, (radiusSq - adjustedDistanceSq) / radiusSq)) : 1.0;
            double damageFactorSq = Math.pow(damageFactor, 2.0);
            double damage = (double)((Float)maxDamage.apply((Entity)entity)).floatValue() * damageFactorSq;
            if (damage > 0.0 && adjustedDistanceSq < radiusSq) {
                entity.func_70015_d((int)((double)fireFactor * damageFactorSq));
                if (entity.func_70097_a(damageSource, (float)damage)) {
                    double entitySizeFactor = avgEntitySize == 0.0 ? 1.0 : Math.max(0.5, Math.min(1.0, 1.0 / avgEntitySize));
                    double entitySizeFactorSq = Math.pow(entitySizeFactor, 2.0);
                    Vec3d velocity = ModUtils.getCenter(entity.func_174813_aQ()).func_178788_d(pos).func_72432_b().func_186678_a(damageFactorSq).func_186678_a((double)knockbackFactor).func_186678_a(entitySizeFactorSq);
                    entity.func_70024_g(velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
                }
            }
        });
    }

    public static void handleBulletImpact(Entity hitEntity, Projectile projectile, float damage, DamageSource damageSource) {
        ModUtils.handleBulletImpact(hitEntity, projectile, damage, damageSource, 0);
    }

    public static void handleBulletImpact(Entity hitEntity, Projectile projectile, float damage, DamageSource damageSource, int knockback) {
        ModUtils.handleBulletImpact(hitEntity, projectile, damage, damageSource, knockback, (p, e) -> {}, (p, e) -> {});
    }

    public static void handleBulletImpact(Entity hitEntity, Projectile projectile, float damage, DamageSource damageSource, int knockback, BiConsumer<Projectile, Entity> beforeHit, BiConsumer<Projectile, Entity> afterHit) {
        ModUtils.handleBulletImpact(hitEntity, projectile, damage, damageSource, knockback, beforeHit, afterHit, true);
    }

    public static void handleBulletImpact(Entity hitEntity, Projectile projectile, float damage, DamageSource damageSource, int knockback, BiConsumer<Projectile, Entity> beforeHit, BiConsumer<Projectile, Entity> afterHit, Boolean resetHurtTime) {
        if (hitEntity != null && projectile != null && projectile.shootingEntity != null && hitEntity != projectile.shootingEntity) {
            float f1;
            beforeHit.accept(projectile, hitEntity);
            if (projectile.func_70027_ad() && !(hitEntity instanceof EntityEnderman)) {
                hitEntity.func_70015_d(5);
            }
            if (resetHurtTime.booleanValue()) {
                hitEntity.field_70172_ad = 0;
            }
            hitEntity.func_70097_a(damageSource, damage);
            if (knockback > 0 && (f1 = MathHelper.func_76133_a((double)(projectile.field_70159_w * projectile.field_70159_w + projectile.field_70179_y * projectile.field_70179_y))) > 0.0f) {
                hitEntity.func_70024_g(projectile.field_70159_w * (double)knockback * (double)0.6f / (double)f1, 0.1, projectile.field_70179_y * (double)knockback * (double)0.6f / (double)f1);
            }
            afterHit.accept(projectile, hitEntity);
        }
    }

    public static Vec3d getRelativeOffset(EntityLivingBase actor, Vec3d offset) {
        Vec3d look = ModUtils.getVectorForRotation(0.0f, actor.field_70761_aq);
        Vec3d side = look.func_178785_b(1.5707964f);
        return look.func_186678_a(offset.field_72450_a).func_178787_e(ModUtils.yVec((float)offset.field_72448_b)).func_178787_e(side.func_186678_a(offset.field_72449_c));
    }

    public static Vec3d getAxisOffset(Vec3d axis, Vec3d offset) {
        Vec3d forward = axis.func_72432_b();
        Vec3d side = axis.func_72431_c(new Vec3d(0.0, 1.0, 0.0)).func_72432_b();
        Vec3d up = axis.func_72431_c(side).func_72432_b();
        return forward.func_186678_a(offset.field_72450_a).func_178787_e(side.func_186678_a(offset.field_72449_c)).func_178787_e(up.func_186678_a(offset.field_72448_b));
    }

    public static void throwProjectile(EntityLivingBase actor, EntityLivingBase target, Projectile projectile) {
        ModUtils.throwProjectile(actor, target, projectile, 12.0f, 1.6f);
    }

    public static void throwProjectile(EntityLivingBase actor, Vec3d target, Projectile projectile, float inaccuracy, float velocity, Vec3d offset) {
        Vec3d pos = projectile.func_174791_d().func_178787_e(offset);
        projectile.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        ModUtils.throwProjectile(actor, target, projectile, inaccuracy, velocity);
    }

    public static void throwProjectile(EntityLivingBase actor, EntityLivingBase target, Projectile projectile, float inaccuracy, float velocity, Vec3d offset) {
        Vec3d pos = projectile.func_174791_d().func_178787_e(offset);
        projectile.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        ModUtils.throwProjectile(actor, target, projectile, inaccuracy, velocity);
    }

    public static void throwProjectile(EntityLivingBase actor, EntityLivingBase target, Projectile projectile, float inaccuracy, float velocity) {
        double d0 = target.field_70163_u + (double)target.func_70047_e() - 0.9;
        ModUtils.throwProjectile(actor, new Vec3d(target.field_70165_t, d0, target.field_70161_v), projectile, inaccuracy, velocity);
    }

    public static void throwProjectile(EntityLivingBase actor, Vec3d target, Projectile projectile, float inaccuracy, float velocity) {
        ModUtils.throwProjectileNoSpawn(target, projectile, inaccuracy, velocity);
        actor.field_70170_p.func_72838_d((Entity)projectile);
    }

    public static void throwProjectileNoSpawn(Vec3d target, Projectile projectile, float inaccuracy, float velocity) {
        double d0 = target.field_72448_b;
        double d1 = target.field_72450_a - projectile.field_70165_t;
        double d2 = d0 - projectile.field_70163_u;
        double d3 = target.field_72449_c - projectile.field_70161_v;
        float f = projectile.func_189652_ae() ? 0.0f : MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.2f;
        projectile.func_70186_c(d1, d2 + (double)f, d3, velocity, inaccuracy);
    }

    public static void walkOnWater(EntityLivingBase entity, World world) {
        BlockPos pos = new BlockPos(entity.field_70165_t, Math.floor(entity.func_174813_aQ().field_72338_b), entity.field_70161_v);
        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(pos).func_177230_c() == Blocks.field_150358_i) {
            if (entity.field_70181_x < 0.0) {
                entity.field_70163_u += -entity.field_70181_x;
                entity.field_70181_x = 0.0;
            }
            entity.field_70143_R = 0.0f;
            entity.field_70122_E = true;
        }
    }

    public static float getMobDamage(double baseAttackDamage, double healthScaledAttackFactor, float maxHealth, float health, float level, Element element) {
        double leveledAttack = baseAttackDamage * (double)LevelHandler.getMultiplierFromLevel(level) * (double)ModConfig.balance.mob_damage;
        double healthScaledAttack = leveledAttack * healthScaledAttackFactor * (((double)maxHealth * 0.5 - (double)health) / (double)maxHealth);
        double elementalScale = element != Element.NONE ? (double)ModConfig.balance.elemental_factor : 1.0;
        return (float)((healthScaledAttack + leveledAttack) * elementalScale);
    }

    public static boolean isBetween(int a, int b, int v) {
        if (a > b) {
            int t = a;
            a = b;
            b = t;
        }
        return v >= a && v < b;
    }

    public static int calculateGenerationHeight(World world, int x, int z) {
        return world.func_175672_r(new BlockPos(x, 0, z)).func_177956_o();
    }

    public static int getAverageGroundHeight(World world, int x, int z, int sizeX, int sizeZ, int maxVariation) {
        int min;
        int corner4;
        sizeX = x + sizeX;
        sizeZ = z + sizeZ;
        int corner1 = ModUtils.calculateGenerationHeight(world, x, z);
        int corner2 = ModUtils.calculateGenerationHeight(world, sizeX, z);
        int corner3 = ModUtils.calculateGenerationHeight(world, x, sizeZ);
        int max = Math.max(Math.max(corner3, corner4 = ModUtils.calculateGenerationHeight(world, sizeX, sizeZ)), Math.max(corner1, corner2));
        if (max - (min = Math.min(Math.min(corner3, corner4), Math.min(corner1, corner2))) > maxVariation) {
            return -1;
        }
        return min;
    }

    public static String getDamageTooltip(float damage) {
        return ModUtils.translateDesc("damage_tooltip", "" + TextFormatting.BLUE + DF_0.format(damage) + TextFormatting.GRAY);
    }

    public static String getCooldownTooltip(float cooldown) {
        return ModUtils.translateDesc("gun_reload_time", TextFormatting.BLUE + "" + DF_0.format((double)cooldown * 0.05) + TextFormatting.GRAY);
    }

    public static float getEnchantedDamage(ItemStack stack, float level, float damage) {
        return damage * 2.0f * LevelHandler.getMultiplierFromLevel(level);
    }

    public static int getGunAmmoUse(float level) {
        return Math.round(LevelHandler.getMultiplierFromLevel(level));
    }

    public static float calculateElementalDamage(Element mobElement, Element damageElement, float amount) {
        if (mobElement.matchesElement(damageElement)) {
            return amount * 1.5f;
        }
        return amount;
    }

    public static void doSweepAttack(EntityPlayer player, @Nullable EntityLivingBase target, Element element, Consumer<EntityLivingBase> perEntity) {
        ModUtils.doSweepAttack(player, target, element, perEntity, 9.0f, 1.0f);
    }

    public static void doSweepAttack(EntityPlayer player, @Nullable EntityLivingBase target, Element element, Consumer<EntityLivingBase> perEntity, float maxDistanceSq, float areaSize) {
        AxisAlignedBB box;
        float attackDamage = (float)player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        float sweepDamage = Math.min(0.15f + EnchantmentHelper.func_191527_a((EntityLivingBase)player), 1.0f) * attackDamage;
        if (target != null) {
            box = target.func_174813_aQ();
        } else {
            Vec3d center = ModUtils.getAxisOffset(player.func_70040_Z(), new Vec3d((double)areaSize * 1.5, 0.0, 0.0)).func_178787_e(player.func_174824_e(1.0f));
            box = ModUtils.makeBox(center, center).func_72314_b((double)areaSize * 0.5, (double)areaSize, (double)areaSize * 0.5);
        }
        for (EntityLivingBase entitylivingbase : player.field_70170_p.func_72872_a(EntityLivingBase.class, box.func_72314_b((double)areaSize, 0.25, (double)areaSize))) {
            if (entitylivingbase == player || entitylivingbase == target || player.func_184191_r((Entity)entitylivingbase) || !(player.func_70068_e((Entity)entitylivingbase) < (double)maxDistanceSq)) continue;
            entitylivingbase.func_70653_a((Entity)player, 0.4f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
            entitylivingbase.func_70097_a(ModDamageSource.causeElementalPlayerDamage(player, element), sweepDamage);
            perEntity.accept(entitylivingbase);
        }
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187730_dW, player.func_184176_by(), 1.0f, 0.9f);
        if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayerMP) {
            Main.network.sendTo((IMessage)new MessageModParticles(EnumModParticles.SWEEP_ATTACK, ModUtils.getCenter(box), Vec3d.field_186680_a, element.sweepColor), (EntityPlayerMP)player);
        }
        ParticleSpawnerSwordSwing particle = new ParticleSpawnerSwordSwing(player.field_70170_p);
        ModUtils.setEntityPosition(particle, ModUtils.getCenter(box));
        player.field_70170_p.func_72838_d((Entity)particle);
    }

    public static void circleCallback(float radius, int points, Consumer<Vec3d> particleSpawner) {
        float degrees = 360.0f / (float)points;
        for (int i = 0; i < points; ++i) {
            double radians = Math.toRadians((float)i * degrees);
            Vec3d offset = new Vec3d(Math.sin(radians), Math.cos(radians), 0.0).func_186678_a((double)radius);
            particleSpawner.accept(offset);
        }
    }

    public static List<Vec3d> circlePoints(float radius, int numPoints) {
        ArrayList<Vec3d> points = new ArrayList<Vec3d>();
        ModUtils.circleCallback(radius, numPoints, points::add);
        return points;
    }

    public static float getArmoredDamage(DamageSource source, float amount, float level, Element element) {
        amount *= ModConfig.balance.mob_armor;
        if (!source.func_76363_c()) {
            if (element != Element.NONE) {
                amount /= ModConfig.balance.elemental_factor;
            }
            amount *= LevelHandler.getArmorFromLevel(level);
        }
        if (source instanceof IElement) {
            amount = ModUtils.calculateElementalDamage(element, ((IElement)source).getElement(), amount);
        }
        return amount;
    }

    public static void leapTowards(EntityLivingBase entity, Vec3d target, float horzVel, float yVel) {
        Vec3d dir = target.func_178788_d(entity.func_174791_d()).func_72432_b();
        Vec3d leap = new Vec3d(dir.field_72450_a, 0.0, dir.field_72449_c).func_72432_b().func_186678_a((double)horzVel).func_178787_e(ModUtils.yVec(yVel));
        entity.field_70159_w += leap.field_72450_a;
        if (entity.field_70181_x < 0.1) {
            entity.field_70181_x += leap.field_72448_b;
        }
        entity.field_70179_y += leap.field_72449_c;
        double horzMag = Math.sqrt(Math.pow(entity.field_70159_w, 2.0) + Math.pow(entity.field_70179_y, 2.0));
        double scale = (double)horzVel / horzMag;
        if (scale < 1.0) {
            entity.field_70159_w *= scale;
            entity.field_70179_y *= scale;
        }
    }

    public static void lineCallback(Vec3d start, Vec3d end, int points, BiConsumer<Vec3d, Integer> callback) {
        Vec3d dir = end.func_178788_d(start).func_186678_a((double)(1.0f / (float)(points - 1)));
        Vec3d pos = start;
        for (int i = 0; i < points; ++i) {
            callback.accept(pos, i);
            pos = pos.func_178787_e(dir);
        }
    }

    public static int tryParseInt(String s, int defaultValue) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static float clamp(double value, double min, double max) {
        return (float)Math.max(min, Math.min(max, value));
    }

    public static Vec3d findEntityGroupCenter(Entity mob, double d) {
        Vec3d groupCenter = mob.func_174791_d();
        float numMobs = 1.0f;
        for (EntityLivingBase entity : ModUtils.getEntitiesInBox(mob, new AxisAlignedBB(mob.func_180425_c()).func_186662_g(d))) {
            if (!(entity instanceof EntityMaelstromMob) || entity instanceof EntityMaelstromHealer) continue;
            groupCenter = groupCenter.func_178787_e(entity.func_174791_d());
            numMobs += 1.0f;
        }
        return groupCenter.func_186678_a((double)(1.0f / numMobs));
    }

    public static boolean isAirBelow(World world, BlockPos pos, int blocksBelow) {
        boolean hasGround = false;
        for (int i = 0; i >= -blocksBelow; --i) {
            if (world.func_175623_d(pos.func_177971_a((Vec3i)new BlockPos(0, i, 0)))) continue;
            hasGround = true;
        }
        return !hasGround;
    }

    public static void facePosition(Vec3d pos, Entity entity, float maxYawIncrease, float maxPitchIncrease) {
        double d0 = pos.field_72450_a - entity.field_70165_t;
        double d2 = pos.field_72449_c - entity.field_70161_v;
        double d1 = pos.field_72448_b - entity.field_70163_u;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
        float f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
        entity.field_70125_A = ModUtils.updateRotation(entity.field_70125_A, f1, maxPitchIncrease);
        entity.field_70177_z = ModUtils.updateRotation(entity.field_70177_z, f, maxYawIncrease);
    }

    private static float updateRotation(float angle, float targetAngle, float maxIncrease) {
        float f = MathHelper.func_76142_g((float)(targetAngle - angle));
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }

    @Deprecated
    public static Vec3d rotateVector(Vec3d vec, Vec3d axis, double degrees) {
        double theta = Math.toRadians(degrees);
        double x = vec.field_72450_a;
        double y = vec.field_72448_b;
        double z = vec.field_72449_c;
        double u = axis.field_72450_a;
        double v = axis.field_72448_b;
        double w = axis.field_72449_c;
        double xPrime = u * (u * x + v * y + w * z) * (1.0 - Math.cos(theta)) + x * Math.cos(theta) + (-w * y + v * z) * Math.sin(theta);
        double yPrime = v * (u * x + v * y + w * z) * (1.0 - Math.cos(theta)) + y * Math.cos(theta) + (w * x - u * z) * Math.sin(theta);
        double zPrime = w * (u * x + v * y + w * z) * (1.0 - Math.cos(theta)) + z * Math.cos(theta) + (-v * x + u * y) * Math.sin(theta);
        return new Vec3d(xPrime, yPrime, zPrime).func_72432_b();
    }

    public static Vec3d rotateVector2(Vec3d v, Vec3d k, double degrees) {
        double theta = Math.toRadians(degrees);
        k = k.func_72432_b();
        return v.func_186678_a(Math.cos(theta)).func_178787_e(k.func_72431_c(v).func_186678_a(Math.sin(theta))).func_178787_e(k.func_186678_a(k.func_72430_b(v)).func_186678_a(1.0 - Math.cos(theta)));
    }

    public static double unsignedAngle(Vec3d a, Vec3d b) {
        double dot = a.func_72430_b(b);
        double cos = dot / (a.func_72433_c() * b.func_72433_c());
        return Math.acos(cos);
    }

    public static double toPitch(Vec3d vec) {
        double angleBetweenYAxis = Math.toDegrees(ModUtils.unsignedAngle(vec, Y_AXIS.func_186678_a(-1.0)));
        return angleBetweenYAxis - 90.0;
    }

    public static void destroyBlocksInAABB(AxisAlignedBB box, World world, Entity entity) {
        int i = MathHelper.func_76128_c((double)box.field_72340_a);
        int j = MathHelper.func_76128_c((double)box.field_72338_b);
        int k = MathHelper.func_76128_c((double)box.field_72339_c);
        int l = MathHelper.func_76128_c((double)box.field_72336_d);
        int i1 = MathHelper.func_76128_c((double)box.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)box.field_72334_f);
        for (int x = i; x <= l; ++x) {
            for (int y = j; y <= i1; ++y) {
                for (int z = k; z <= j1; ++z) {
                    BlockPos blockpos = new BlockPos(x, y, z);
                    IBlockState iblockstate = world.func_180495_p(blockpos);
                    Block block = iblockstate.func_177230_c();
                    if (block.isAir(iblockstate, (IBlockAccess)world, blockpos) || iblockstate.func_185904_a() == Material.field_151581_o || !ForgeEventFactory.getMobGriefingEvent((World)world, (Entity)entity) || block == Blocks.field_150483_bI || block == Blocks.field_185776_dc || block == Blocks.field_185777_dd || block == Blocks.field_150357_h || block == OpenBlocks.Blocks.grave || block instanceof BlockLiquid) continue;
                    if (world.func_184137_a((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), 20.0, false) != null) {
                        world.func_175655_b(blockpos, false);
                        continue;
                    }
                    world.func_175698_g(blockpos);
                }
            }
        }
    }

    public static Vec3d getLookVec(float pitch, float yaw) {
        Vec3d yawVec = ModUtils.rotateVector2(Z_AXIS, Y_AXIS, -yaw);
        return ModUtils.rotateVector2(yawVec, yawVec.func_72431_c(Y_AXIS), pitch);
    }

    public static List<Entity> findEntitiesInLine(Vec3d start, Vec3d end, World world, @Nullable Entity toExclude) {
        return world.func_175674_a(toExclude, new AxisAlignedBB(start.field_72450_a, start.field_72448_b, start.field_72449_c, end.field_72450_a, end.field_72448_b, end.field_72449_c), e -> {
            RayTraceResult raytraceresult = e.func_174813_aQ().func_72327_a(start, end);
            return raytraceresult != null;
        });
    }

    public static void handleElytraTravel(EntityLivingBase entity) {
        if ((entity.func_70613_aW() || entity.func_184186_bw()) && (!entity.func_70090_H() || entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75100_b) && (!entity.func_180799_ab() || entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75100_b)) {
            double d11;
            double d3;
            float f5;
            if (entity.field_70181_x > -0.5) {
                entity.field_70143_R = 1.0f;
            }
            Vec3d vec3d = entity.func_70040_Z();
            float f = entity.field_70125_A * ((float)Math.PI / 180);
            double d6 = Math.sqrt(vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c);
            double d8 = Math.sqrt(entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y);
            double d1 = vec3d.func_72433_c();
            float f4 = MathHelper.func_76134_b((float)f);
            f4 = (float)((double)f4 * (double)f4 * Math.min(1.0, d1 / 0.4));
            entity.field_70181_x += -0.08 + (double)f4 * 0.06;
            if (entity.field_70181_x < 0.0 && d6 > 0.0) {
                double d2 = entity.field_70181_x * -0.1 * (double)f4;
                entity.field_70181_x += d2;
                entity.field_70159_w += vec3d.field_72450_a * d2 / d6;
                entity.field_70179_y += vec3d.field_72449_c * d2 / d6;
            }
            if (f < 0.0f) {
                double d10 = d8 * (double)(-MathHelper.func_76126_a((float)f)) * 0.04;
                entity.field_70181_x += d10 * 3.2;
                entity.field_70159_w -= vec3d.field_72450_a * d10 / d6;
                entity.field_70179_y -= vec3d.field_72449_c * d10 / d6;
            }
            if (d6 > 0.0) {
                entity.field_70159_w += (vec3d.field_72450_a / d6 * d8 - entity.field_70159_w) * 0.1;
                entity.field_70179_y += (vec3d.field_72449_c / d6 * d8 - entity.field_70179_y) * 0.1;
            }
            entity.field_70159_w *= (double)0.99f;
            entity.field_70181_x *= (double)0.98f;
            entity.field_70179_y *= (double)0.99f;
            entity.func_70091_d(MoverType.SELF, entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
            if (entity.field_70123_F && !entity.field_70170_p.field_72995_K && (f5 = (float)((d3 = d8 - (d11 = Math.sqrt(entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y))) * 10.0 - 3.0)) > 0.0f) {
                entity.func_184185_a(SoundEvents.field_187804_ed, 1.0f, 1.0f);
                entity.func_70097_a(DamageSource.field_188406_j, f5);
            }
        }
    }

    @Nullable
    public static EntityLeveledMob spawnMob(World world, BlockPos pos, float level, Config algorithmConfig) {
        return ModUtils.spawnMob(world, pos, level, algorithmConfig, true);
    }

    @Nullable
    public static EntityLeveledMob spawnMob(World world, BlockPos pos, float level, Config algorithmConfig, boolean findGround) {
        List configs = algorithmConfig.getConfigList("mobs");
        BlockPos spawnRange = new BlockPos(algorithmConfig.getInt("spawning_area.width"), algorithmConfig.getInt("spawning_area.height"), algorithmConfig.getInt("spawning_area.width"));
        int[] mobWeights = ModUtils.getMobsThatCanSpawn(world, pos, algorithmConfig);
        Function<Config, int[]> getElementalWeights = config -> config.getConfigList("elements").stream().mapToInt(c -> c.getInt("weight")).toArray();
        Function<Config, Element[]> getElementalIds = config -> (Element[])config.getConfigList("elements").stream().mapToInt(c -> c.getInt("id")).mapToObj(Element::getElementFromId).toArray(Element[]::new);
        MobSpawnerLogic.MobSpawnData[] data = (MobSpawnerLogic.MobSpawnData[])configs.stream().map(config -> {
            MobSpawnerLogic.MobSpawnData newSpawnData;
            if (config.hasPath("elements")) {
                int[] elementWeights = (int[])getElementalWeights.apply((Config)config);
                Element[] elementIds = (Element[])getElementalIds.apply((Config)config);
                newSpawnData = new MobSpawnerLogic.MobSpawnData(config.getString("entity_id"), elementIds, elementWeights, 1);
            } else {
                newSpawnData = new MobSpawnerLogic.MobSpawnData(config.getString("entity_id"), Element.NONE);
            }
            if (config.hasPath("nbt_spawn_data")) {
                NBTTagCompound spawnData = ModUtils.parseNBTFromConfig(config.getConfig("nbt_spawn_data"));
                spawnData.func_74778_a("id", config.getString("entity_id"));
                newSpawnData.addMobNBT(spawnData);
            }
            return newSpawnData;
        }).toArray(MobSpawnerLogic.MobSpawnData[]::new);
        return ModUtils.spawnMob(world, pos, level, data, mobWeights, spawnRange, findGround);
    }

    private static int[] getMobsThatCanSpawn(World world, BlockPos pos, Config algorithmConfig) {
        List configs = algorithmConfig.getConfigList("mobs");
        BlockPos mobDetectionRange = new BlockPos(algorithmConfig.getInt("mob_cap_detection_area.width"), algorithmConfig.getInt("mob_cap_detection_area.height"), algorithmConfig.getInt("mob_cap_detection_area.width"));
        AxisAlignedBB detectionArea = new AxisAlignedBB(pos).func_72314_b((double)mobDetectionRange.func_177958_n() * 0.5, (double)mobDetectionRange.func_177956_o() * 0.5, (double)mobDetectionRange.func_177952_p() * 0.5);
        Function<String, Integer> getCountOfMobsById = mobId -> (int)world.func_72872_a(EntityLivingBase.class, detectionArea).stream().filter(e -> {
            EntityEntry registry = EntityRegistry.getEntry(e.getClass());
            if (registry != null) {
                return registry.getRegistryName() != null && registry.getRegistryName().toString().equals(mobId);
            }
            return false;
        }).count();
        Function<Config, Integer> filterOutMobsOverCap = config -> {
            if (config.hasPath("max_nearby") && (Integer)getCountOfMobsById.apply(config.getString("entity_id")) > config.getInt("max_nearby")) {
                return 0;
            }
            return config.hasPath("spawn_weight") ? config.getInt("spawn_weight") : 1;
        };
        return configs.stream().map(filterOutMobsOverCap).mapToInt(x -> x).toArray();
    }

    @Nullable
    private static EntityLeveledMob spawnMob(World world, BlockPos pos, float level, MobSpawnerLogic.MobSpawnData[] mobs, int[] weights, BlockPos range, boolean findGround) {
        Random random = new Random();
        if (weights.length == 0 || Arrays.stream(weights).reduce(Integer::sum).getAsInt() == 0) {
            return null;
        }
        MobSpawnerLogic.MobSpawnData data = ModRandom.choice(mobs, random, weights).next();
        int tries = 100;
        for (int i = 0; i < tries; ++i) {
            boolean noLiquid;
            Entity mob;
            int x = pos.func_177958_n() + ModRandom.range(-range.func_177958_n(), range.func_177958_n());
            int y = pos.func_177956_o() + ModRandom.range(-range.func_177956_o(), range.func_177956_o());
            int z = pos.func_177952_p() + ModRandom.range(-range.func_177952_p(), range.func_177952_p());
            BlockPos spawnPos = new BlockPos(x, y, z);
            if (findGround) {
                spawnPos = ModUtils.findGroundBelow(world, spawnPos).func_177984_a();
                int lowestY = pos.func_177956_o() - range.func_177956_o();
                if (spawnPos.func_177956_o() < lowestY) continue;
            }
            if (findGround && !world.func_180495_p(spawnPos.func_177977_b()).isSideSolid((IBlockAccess)world, spawnPos.func_177977_b(), EnumFacing.UP) || !((mob = ModUtils.createMobFromSpawnData(data, world, (double)x + 0.5, spawnPos.func_177956_o(), (double)z + 0.5)) instanceof EntityLeveledMob)) continue;
            boolean notNearPlayer = !world.func_175636_b((double)x, (double)spawnPos.func_177956_o(), (double)z, 3.0);
            boolean clearAroundHitbox = world.func_184144_a(mob, mob.func_174813_aQ()).isEmpty();
            boolean bl = noLiquid = !world.func_72953_d(mob.func_174813_aQ());
            if (!notNearPlayer || !clearAroundHitbox || !noLiquid) continue;
            EntityLeveledMob leveledMob = (EntityLeveledMob)mob;
            world.func_72838_d((Entity)leveledMob);
            leveledMob.func_180482_a(world.func_175649_E(new BlockPos(mob)), null);
            leveledMob.func_70656_aK();
            leveledMob.setElement(ModRandom.choice(data.possibleElements, random, data.elementalWeights).next());
            leveledMob.setLevel(level);
            return leveledMob;
        }
        return null;
    }

    @Nullable
    public static Entity createMobFromSpawnData(MobSpawnerLogic.MobSpawnData data, World world, double x, double y, double z) {
        Entity entity = data.mobData != null ? AnvilChunkLoader.func_186054_a((NBTTagCompound)data.mobData, (World)world, (double)x, (double)y, (double)z, (boolean)true) : EntityList.func_188429_b((ResourceLocation)new ResourceLocation(data.mobId), (World)world);
        if (entity == null) {
            System.out.println("Failed to spawn entity with id " + data.mobId);
            return null;
        }
        entity.func_70012_b(x, y, z, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        return entity;
    }

    public static void setEntityPosition(Entity entity, Vec3d vec) {
        entity.func_70107_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public static void setEntityVelocity(Entity entity, Vec3d vec) {
        entity.field_70159_w = vec.field_72450_a;
        entity.field_70181_x = vec.field_72448_b;
        entity.field_70179_y = vec.field_72449_c;
    }

    public static void addEntityVelocity(Entity entity, Vec3d vec) {
        entity.func_70024_g(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public static Vec3d getEntityVelocity(Entity entity) {
        return new Vec3d(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
    }

    public static <T extends EntityAIBase> void removeTaskOfType(EntityAITasks tasks, Class<T> clazz) {
        HashSet toRemove = Sets.newHashSet();
        for (EntityAITasks.EntityAITaskEntry entry : tasks.field_75782_a) {
            if (!clazz.isInstance(entry.field_75733_a)) continue;
            toRemove.add(entry.field_75733_a);
        }
        for (EntityAIBase ai : toRemove) {
            tasks.func_85156_a(ai);
        }
    }

    public static BlockPos findGroundBelow(World world, BlockPos pos) {
        for (int i = pos.func_177956_o(); i > 0; --i) {
            BlockPos tempPos = new BlockPos(pos.func_177958_n(), i, pos.func_177952_p());
            if (!world.func_180495_p(tempPos).isSideSolid((IBlockAccess)world, tempPos, EnumFacing.UP)) continue;
            return tempPos;
        }
        return new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p());
    }

    public static AxisAlignedBB makeBox(Vec3d pos1, Vec3d pos2) {
        return new AxisAlignedBB(pos1.field_72450_a, pos1.field_72448_b, pos1.field_72449_c, pos2.field_72450_a, pos2.field_72448_b, pos2.field_72449_c);
    }

    public static boolean canEntityBeSeen(Entity viewer, Entity target) {
        RayTraceResult result = viewer.field_70170_p.func_147447_a(viewer.func_174824_e(1.0f), target.func_174824_e(1.0f), false, true, false);
        if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
            IBlockState blockState = viewer.field_70170_p.func_180495_p(result.func_178782_a());
            return !blockState.func_185917_h();
        }
        return true;
    }

    @Nullable
    public static EntityLivingBase getLivingEntity(@Nullable Entity entity) {
        if (entity instanceof EntityLivingBase) {
            return (EntityLivingBase)entity;
        }
        if (entity instanceof MultiPartEntityPart && ((MultiPartEntityPart)entity).field_70259_a instanceof EntityLivingBase) {
            return (EntityLivingBase)((MultiPartEntityPart)entity).field_70259_a;
        }
        return null;
    }

    @Nullable
    public static EntityLivingBase closestEntityExcluding(@Nullable Entity entityToExclude, AxisAlignedBB box, Predicate<EntityLivingBase> condition) {
        EntityLivingBase closestEntity = null;
        for (EntityLivingBase entity : ModUtils.getEntitiesInBox(entityToExclude, box)) {
            if (!condition.test(entity) || closestEntity != null && !(entity.func_70032_d(entityToExclude) < closestEntity.func_70032_d(entityToExclude))) continue;
            closestEntity = entity;
        }
        return closestEntity;
    }

    public static double mag(double ... values) {
        double sum = 0.0;
        for (double value : values) {
            sum += Math.pow(value, 2.0);
        }
        return Math.sqrt(sum);
    }

    public static int minutesToTicks(int minutes) {
        return minutes * 60 * 20;
    }

    public static int secondsToTicks(int seconds) {
        return seconds * 20;
    }

    public static NBTTagCompound parseNBTFromConfig(Config config) {
        try {
            return JsonToNBT.func_180713_a((String)config.root().render(ConfigRenderOptions.concise()));
        }
        catch (NBTException e) {
            Main.log.error("Malformed NBT tag", (Throwable)e);
            return new NBTTagCompound();
        }
    }

    public static boolean canBlockDamageSource(DamageSource damageSourceIn, EntityLivingBase entity) {
        Vec3d vec3d;
        if (!damageSourceIn.func_76363_c() && entity.func_184585_cz() && (vec3d = damageSourceIn.func_188404_v()) != null) {
            Vec3d vec3d1 = entity.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v)).func_72432_b();
            vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
            return vec3d2.func_72430_b(vec3d1) < 0.0;
        }
        return false;
    }

    public static List<Vec3d> cubePoints(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax) {
        ArrayList<Vec3d> points = new ArrayList<Vec3d>();
        for (int x = xMin; x < xMax; ++x) {
            for (int y = yMin; y < yMax; ++y) {
                for (int z = zMin; z < zMax; ++z) {
                    points.add(new Vec3d((double)x, (double)y, (double)z));
                }
            }
        }
        return points;
    }

    public static void aerialTravel(EntityLivingBase entity, float strafe, float vertical, float forward) {
        if (entity.func_70090_H()) {
            entity.func_191958_b(strafe, vertical, forward, 0.02f);
            entity.func_70091_d(MoverType.SELF, entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
            entity.field_70159_w *= (double)0.8f;
            entity.field_70181_x *= (double)0.8f;
            entity.field_70179_y *= (double)0.8f;
        } else if (entity.func_180799_ab()) {
            entity.func_191958_b(strafe, vertical, forward, 0.02f);
            entity.func_70091_d(MoverType.SELF, entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
            entity.field_70159_w *= 0.5;
            entity.field_70181_x *= 0.5;
            entity.field_70179_y *= 0.5;
        } else {
            float f = 0.91f;
            if (entity.field_70122_E) {
                BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)entity.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)entity.field_70161_v));
                IBlockState underState = entity.field_70170_p.func_180495_p(underPos);
                f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)entity.field_70170_p, underPos, (Entity)entity) * 0.91f;
            }
            float f1 = 0.16277136f / (f * f * f);
            entity.func_191958_b(strafe, vertical, forward, entity.field_70122_E ? 0.1f * f1 : 0.02f);
            f = 0.91f;
            if (entity.field_70122_E) {
                BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)entity.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)entity.field_70161_v));
                IBlockState underState = entity.field_70170_p.func_180495_p(underPos);
                f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)entity.field_70170_p, underPos, (Entity)entity) * 0.91f;
            }
            entity.func_70091_d(MoverType.SELF, entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
            entity.field_70159_w *= (double)f;
            entity.field_70181_x *= (double)f;
            entity.field_70179_y *= (double)f;
        }
        entity.field_184618_aE = entity.field_70721_aZ;
        double d1 = entity.field_70165_t - entity.field_70169_q;
        double d0 = entity.field_70161_v - entity.field_70166_s;
        float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        entity.field_70721_aZ += (f2 - entity.field_70721_aZ) * 0.4f;
        entity.field_184619_aG += entity.field_70721_aZ;
    }

    public static boolean attemptTeleport(Vec3d pos, EntityLivingBase entity) {
        double d0 = entity.field_70165_t;
        double d1 = entity.field_70163_u;
        double d2 = entity.field_70161_v;
        ModUtils.setEntityPosition((Entity)entity, pos);
        boolean flag = false;
        BlockPos blockpos = new BlockPos((Entity)entity);
        World world = entity.field_70170_p;
        Random random = entity.func_70681_au();
        if (world.func_175667_e(blockpos)) {
            entity.func_70634_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (world.func_184144_a((Entity)entity, entity.func_174813_aQ()).isEmpty() && !world.func_72953_d(entity.func_174813_aQ())) {
                flag = true;
            }
        }
        if (!flag) {
            entity.func_70634_a(d0, d1, d2);
            return false;
        }
        for (int j = 0; j < 128; ++j) {
            double d6 = (double)j / 127.0;
            float f = (random.nextFloat() - 0.5f) * 0.2f;
            float f1 = (random.nextFloat() - 0.5f) * 0.2f;
            float f2 = (random.nextFloat() - 0.5f) * 0.2f;
            double d3 = d0 + (entity.field_70165_t - d0) * d6 + (random.nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
            double d4 = d1 + (entity.field_70163_u - d1) * d6 + random.nextDouble() * (double)entity.field_70131_O;
            double d5 = d2 + (entity.field_70161_v - d2) * d6 + (random.nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
            world.func_175688_a(EnumParticleTypes.PORTAL, d3, d4, d5, (double)f, (double)f1, (double)f2, new int[0]);
        }
        if (entity instanceof EntityCreature) {
            ((EntityCreature)entity).func_70661_as().func_75499_g();
        }
        return true;
    }

    public static Vec3d planeProject(Vec3d vec, Vec3d plane) {
        return ModUtils.rotateVector2(vec.func_72431_c(plane), plane, 90.0);
    }

    public static boolean mobGriefing(World world, Entity entity) {
        return ForgeEventFactory.getMobGriefingEvent((World)world, (Entity)entity);
    }

    public static AxisAlignedBB vecBox(Vec3d vec1, Vec3d vec2) {
        return new AxisAlignedBB(vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c, vec2.field_72450_a, vec2.field_72448_b, vec2.field_72449_c);
    }

    public static SoundEvent getConfiguredSound(SoundEvent sound, SoundEvent fallback) {
        if (Main.soundsConfig.getBoolean(sound.field_187506_b.func_110623_a())) {
            return sound;
        }
        return fallback;
    }

    public static Vec2f getPitchYaw(Vec3d look) {
        double d3 = MathHelper.func_76133_a((double)(look.field_72450_a * look.field_72450_a + look.field_72449_c * look.field_72449_c));
        float yaw = (float)(MathHelper.func_181159_b((double)look.field_72449_c, (double)look.field_72450_a) * 57.29577951308232) - 90.0f;
        float pitch = (float)(-(MathHelper.func_181159_b((double)look.field_72448_b, (double)d3) * 57.29577951308232));
        return new Vec2f(pitch, yaw);
    }

    public static void avoidOtherEntities(Entity entity, double speed, int detectionSize, Predicate<? super Entity> filter) {
        double boundingBoxEdgeLength = entity.func_174813_aQ().func_72320_b() * 0.5;
        double distanceSq = Math.pow((double)detectionSize + boundingBoxEdgeLength, 2.0);
        BiFunction<Vec3d, Entity, Vec3d> accumulator = (vec, e) -> vec.func_178787_e(entity.func_174791_d().func_178788_d(e.func_174791_d()).func_72432_b()).func_186678_a((distanceSq - entity.func_70068_e(e)) / distanceSq);
        Vec3d avoid = entity.field_70170_p.func_175674_a(entity, entity.func_174813_aQ().func_186662_g((double)detectionSize), filter::test).parallelStream().reduce(Vec3d.field_186680_a, accumulator, Vec3d::func_178787_e).func_186678_a(speed);
        ModUtils.addEntityVelocity(entity, avoid);
    }

    public static void homeToPosition(Entity entity, double speed, Vec3d target) {
        Vec3d velocityChange = ModUtils.getVelocityToTarget(entity, target).func_186678_a(speed);
        ModUtils.addEntityVelocity(entity, velocityChange);
    }

    private static Vec3d getVelocityToTarget(Entity entity, Vec3d target) {
        Vec3d velocityDirection = ModUtils.getEntityVelocity(entity).func_72432_b();
        Vec3d desiredDirection = target.func_178788_d(entity.func_174791_d()).func_72432_b();
        return desiredDirection.func_178788_d(velocityDirection).func_72432_b();
    }

    public static List<Vec3d> getBoundingBoxCorners(AxisAlignedBB box) {
        return new ArrayList<Vec3d>(Arrays.asList(new Vec3d(box.field_72336_d, box.field_72337_e, box.field_72334_f), new Vec3d(box.field_72336_d, box.field_72337_e, box.field_72339_c), new Vec3d(box.field_72336_d, box.field_72338_b, box.field_72334_f), new Vec3d(box.field_72336_d, box.field_72338_b, box.field_72339_c), new Vec3d(box.field_72340_a, box.field_72337_e, box.field_72334_f), new Vec3d(box.field_72340_a, box.field_72337_e, box.field_72339_c), new Vec3d(box.field_72340_a, box.field_72338_b, box.field_72334_f), new Vec3d(box.field_72340_a, box.field_72338_b, box.field_72339_c)));
    }

    public static Vec3d direction(Vec3d from, Vec3d to) {
        return to.func_178788_d(from).func_72432_b();
    }

    public static void faceDirection(EntityLiving entity, Vec3d target, int maxDegreeIncrease) {
        ModUtils.facePosition(target, (Entity)entity, 15.0f, 15.0f);
        entity.func_70671_ap().func_75650_a(target.field_72450_a, target.field_72448_b, target.field_72449_c, 15.0f, 15.0f);
        if (entity instanceof IPitch) {
            ((IPitch)entity).setPitch(target.func_178788_d(entity.func_174824_e(1.0f)));
        }
    }

    static {
        DF_0.setRoundingMode(RoundingMode.HALF_EVEN);
        ROUND.setRoundingMode(RoundingMode.HALF_EVEN);
    }
}

