/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.util;

import com.barribob.MaelstromMod.util.ModColors;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;

public enum Element {
    AZURE(new Vec3d(0.5, 0.5, 1.0), ModColors.AZURE, "\u03a6", TextFormatting.AQUA, 0),
    GOLDEN(new Vec3d(1.0, 1.0, 0.5), ModColors.YELLOW, "\u03a9", TextFormatting.YELLOW, 1),
    CRIMSON(new Vec3d(1.0, 0.5, 0.5), ModColors.RED, "\u03a3", TextFormatting.RED, 2),
    NONE(ModColors.WHITE, ModColors.MAELSTROM, " ", TextFormatting.WHITE, 3);

    public Vec3d sweepColor;
    public Vec3d particleColor;
    public String symbol;
    public TextFormatting textColor;
    public int id;
    private static final Map<Integer, Element> FROM_ID;

    private Element(Vec3d sweepColor, Vec3d particleColor, String symbol, TextFormatting textColor, int id) {
        this.sweepColor = sweepColor;
        this.particleColor = particleColor;
        this.symbol = symbol;
        this.textColor = textColor;
        this.id = id;
    }

    public boolean matchesElement(Element e) {
        return this == e && e != NONE && this != NONE;
    }

    public static Element getElementFromId(int id) {
        return FROM_ID.get(id);
    }

    static {
        FROM_ID = Maps.newHashMap();
        for (Element element : Element.values()) {
            FROM_ID.put(element.id, element);
        }
    }
}

