/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.test;

import com.barribob.MaelstromMod.entity.entities.EntityGoldenBoss;
import com.barribob.MaelstromMod.entity.entities.EntityLeveledMob;
import com.barribob.MaelstromMod.entity.entities.EntityMaelstromIllager;
import com.barribob.MaelstromMod.entity.entities.EntityMaelstromStatueOfNirvana;
import com.barribob.MaelstromMod.entity.entities.EntityShade;
import com.barribob.MaelstromMod.test.TestUtils;
import com.barribob.MaelstromMod.util.Element;
import com.barribob.MaelstromMod.util.ModUtils;
import com.typesafe.config.Config;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class InGameTests {
    public static void runAllTests(MinecraftServer server, ICommandSender sender) throws Exception {
        InGameTests.spawnAlgorithm(server.func_130014_f_(), sender.func_180425_c());
        InGameTests.defaultScout(server.func_130014_f_(), sender.func_180425_c());
        InGameTests.defaultIllager(server.func_130014_f_(), sender.func_180425_c());
        InGameTests.defaultGoldenBoss(server.func_130014_f_(), sender.func_180425_c());
        InGameTests.defaultMaelstromStatueOfNirvana(server.func_130014_f_(), sender.func_180425_c());
    }

    public static void runSingleTest(MinecraftServer server, ICommandSender sender, String testName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        InGameTests.class.getMethod(testName, World.class, BlockPos.class).invoke(null, server.func_130014_f_(), sender.func_180425_c());
    }

    public static void spawnAlgorithm(World world, BlockPos pos) throws Exception {
        Config config = TestUtils.testingConfig().getConfig("spawning_algorithm");
        EntityLeveledMob entity = ModUtils.spawnMob(world, pos, 0.0f, config);
        assert (entity != null);
        NBTTagCompound compound = new NBTTagCompound();
        entity.func_189511_e(compound);
        TestUtils.AssertTrue(entity.func_145748_c_().func_150254_d().contains("Maelstrom Scout"), "Mob display names do not match");
        TestUtils.AssertEquals((Object)Element.AZURE, (Object)entity.getElement());
        TestUtils.AssertEquals(1000, compound.func_74762_e("experienceValue"));
        TestUtils.AssertEquals(Float.valueOf(1.0f), Float.valueOf(entity.func_110143_aJ()));
        TestUtils.AssertEquals(Float.valueOf(1.0f), Float.valueOf(entity.func_110138_aP()));
        TestUtils.AssertEquals(12.0, entity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b());
        TestUtils.AssertEquals(64.0, entity.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111125_b());
        TestUtils.AssertEquals(0.4, entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111125_b());
        TestUtils.AssertEquals(0.27, entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b());
    }

    public static void defaultScout(World world, BlockPos pos) throws Exception {
        EntityShade scout = new EntityShade(world);
        world.func_72838_d((Entity)scout);
        ModUtils.setEntityPosition((Entity)scout, new Vec3d((Vec3i)pos));
        NBTTagCompound compound = new NBTTagCompound();
        scout.func_189511_e(compound);
        TestUtils.AssertEquals(10, compound.func_74762_e("experienceValue"));
        TestUtils.AssertEquals(Float.valueOf(25.0f), Float.valueOf(scout.func_110143_aJ()));
        TestUtils.AssertEquals(Float.valueOf(25.0f), Float.valueOf(scout.func_110138_aP()));
        TestUtils.AssertAlmostEquals(6.0, scout.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b(), 3.0);
        TestUtils.AssertAlmostEquals(0.26, scout.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b(), 3.0);
        TestUtils.AssertAlmostEquals(0.3, scout.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111125_b(), 3.0);
    }

    public static void defaultIllager(World world, BlockPos pos) throws Exception {
        EntityMaelstromIllager entity = new EntityMaelstromIllager(world);
        NBTTagCompound compound = new NBTTagCompound();
        entity.func_189511_e(compound);
        TestUtils.AssertEquals(1000, compound.func_74762_e("experienceValue"));
        TestUtils.AssertEquals(Float.valueOf(300.0f), Float.valueOf(entity.func_110143_aJ()));
        TestUtils.AssertEquals(Float.valueOf(300.0f), Float.valueOf(entity.func_110138_aP()));
        TestUtils.AssertAlmostEquals(8.0, entity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b(), 3.0);
    }

    public static void defaultGoldenBoss(World world, BlockPos pos) throws Exception {
        EntityGoldenBoss entity = new EntityGoldenBoss(world);
        NBTTagCompound compound = new NBTTagCompound();
        entity.func_189511_e(compound);
        TestUtils.AssertEquals(0, compound.func_74762_e("experienceValue"));
        TestUtils.AssertEquals(Float.valueOf(450.0f), Float.valueOf(entity.func_110143_aJ()));
        TestUtils.AssertEquals(Float.valueOf(450.0f), Float.valueOf(entity.func_110138_aP()));
        TestUtils.AssertAlmostEquals(9.0, entity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b(), 3.0);
        TestUtils.AssertAlmostEquals(40.0, entity.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111125_b(), 3.0);
    }

    public static void defaultMaelstromStatueOfNirvana(World world, BlockPos pos) throws Exception {
        EntityMaelstromStatueOfNirvana entity = new EntityMaelstromStatueOfNirvana(world);
        NBTTagCompound compound = new NBTTagCompound();
        entity.func_189511_e(compound);
        TestUtils.AssertEquals(1000, compound.func_74762_e("experienceValue"));
        TestUtils.AssertEquals(Float.valueOf(150.0f), Float.valueOf(entity.func_110143_aJ()));
        TestUtils.AssertEquals(Float.valueOf(150.0f), Float.valueOf(entity.func_110138_aP()));
        TestUtils.AssertAlmostEquals(10.0, entity.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b(), 3.0);
        TestUtils.AssertAlmostEquals(40.0, entity.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111125_b(), 3.0);
    }
}

