/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.renderer;

import com.barribob.MaelstromMod.event_handlers.FogHandler;
import com.barribob.MaelstromMod.util.ModColors;
import java.nio.ByteBuffer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;

public class CliffCloudRenderer
extends IRenderHandler
implements ISelectiveResourceReloadListener {
    private VertexBuffer vbo;
    private int displayList = -1;
    private static final VertexFormat FORMAT = DefaultVertexFormats.field_181709_i;
    private int renderDistance = -1;
    private final Minecraft mc = Minecraft.func_71410_x();
    private final ResourceLocation texture = new ResourceLocation("mm:textures/environment/cliff_swamp_fog.png");
    private static final int TOP_SECTIONS = 12;
    private static final float PX_SIZE = 0.00390625f;
    private static final float ALPHA = 0.7f;
    private int texW;
    private int texH;
    private static final boolean WIREFRAME = false;
    private DynamicTexture COLOR_TEX = null;

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        Entity entity = mc.func_175606_aa();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        for (int i = 0; i < 8; ++i) {
            float y = FogHandler.CLIFF_FOG_HEIGHT + (float)i;
            int maxAlpha = 80;
            double entityHeight = entity.func_174824_e((float)partialTicks).field_72448_b;
            double distanceFromPlane = entityHeight - (double)(y + entity.func_70047_e());
            double alpha = (double)maxAlpha * MathHelper.func_151237_a((double)(distanceFromPlane / 5.0), (double)0.0, (double)1.0);
            this.renderPlane(partialTicks, world, mc, y, ModColors.SWAMP_FOG.func_186678_a(255.0), (int)alpha);
        }
        GlStateManager.func_179092_a((int)516, (float)0.1f);
    }

    public void renderPlane(float partialTicks, WorldClient world, Minecraft mc, float height, Vec3d colorTweak, int alpha) {
        int i;
        if (!this.isBuilt()) {
            this.reloadTextures();
        }
        this.checkSettings();
        Entity entity = mc.func_175606_aa();
        double totalOffset = partialTicks + (float)entity.field_70173_aa;
        double x = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks + totalOffset * 0.01;
        double y = (double)(height + entity.func_70047_e()) - (entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks);
        double z = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
        int scale = this.getScale();
        int offU = this.fullCoord(x, scale);
        int offV = this.fullCoord(z, scale);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)((double)(offU * scale) - x), (double)y, (double)((double)(offV * scale) - z));
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179109_b((float)((float)(offU %= this.texW) * 0.00390625f), (float)((float)(offV %= this.texH) * 0.00390625f), (float)0.0f);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        if (this.COLOR_TEX == null) {
            this.COLOR_TEX = new DynamicTexture(1, 1);
        }
        this.COLOR_TEX.func_110565_c()[0] = alpha << 24 | (int)colorTweak.field_72450_a << 16 | (int)colorTweak.field_72448_b << 8 | (int)colorTweak.field_72449_c;
        this.COLOR_TEX.func_110564_a();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179144_i((int)this.COLOR_TEX.func_110552_b());
        GlStateManager.func_179098_w();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        mc.field_71446_o.func_110577_a(this.texture);
        ByteBuffer buffer = Tessellator.func_178181_a().func_178180_c().func_178966_f();
        if (OpenGlHelper.func_176075_f()) {
            this.vbo.func_177359_a();
            int stride = FORMAT.func_177338_f();
            GlStateManager.func_187420_d((int)3, (int)5126, (int)stride, (int)0);
            GlStateManager.func_187410_q((int)32884);
            GlStateManager.func_187405_c((int)2, (int)5126, (int)stride, (int)12);
            GlStateManager.func_187410_q((int)32888);
            GlStateManager.func_187406_e((int)4, (int)5121, (int)stride, (int)20);
            GlStateManager.func_187410_q((int)32886);
        } else {
            buffer.limit(FORMAT.func_177338_f());
            for (i = 0; i < FORMAT.func_177345_h(); ++i) {
                ((VertexFormatElement)FORMAT.func_177343_g().get(i)).func_177375_c().preDraw(FORMAT, i, FORMAT.func_177338_f(), buffer);
            }
            buffer.position(0);
        }
        GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        if (OpenGlHelper.func_176075_f()) {
            this.vbo.func_177358_a(7);
        } else {
            GlStateManager.func_179148_o((int)this.displayList);
        }
        if (!mc.field_71474_y.field_74337_g) {
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        } else {
            switch (EntityRenderer.field_78515_b) {
                case 0: {
                    GlStateManager.func_179135_a((boolean)false, (boolean)true, (boolean)true, (boolean)true);
                    break;
                }
                case 1: {
                    GlStateManager.func_179135_a((boolean)true, (boolean)false, (boolean)false, (boolean)true);
                }
            }
        }
        if (OpenGlHelper.func_176075_f()) {
            this.vbo.func_177358_a(7);
            this.vbo.func_177361_b();
        } else {
            GlStateManager.func_179148_o((int)this.displayList);
        }
        buffer.limit(0);
        for (i = 0; i < FORMAT.func_177345_h(); ++i) {
            ((VertexFormatElement)FORMAT.func_177343_g().get(i)).func_177375_c().postDraw(FORMAT, i, FORMAT.func_177338_f(), buffer);
        }
        buffer.position(0);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }

    public void checkSettings() {
        this.renderDistance = this.mc.field_71474_y.field_151451_c;
        if (this.isBuilt() && this.mc.field_71474_y.field_151451_c != this.renderDistance) {
            this.dispose();
        }
        if (!this.isBuilt()) {
            this.build();
        }
    }

    private void dispose() {
        if (this.vbo != null) {
            this.vbo.func_177362_c();
            this.vbo = null;
        }
        if (this.displayList >= 0) {
            GLAllocation.func_74523_b((int)this.displayList);
            this.displayList = -1;
        }
    }

    private boolean isBuilt() {
        return OpenGlHelper.func_176075_f() ? this.vbo != null : this.displayList >= 0;
    }

    private void build() {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buffer = tess.func_178180_c();
        if (OpenGlHelper.func_176075_f()) {
            this.vbo = new VertexBuffer(FORMAT);
        } else {
            this.displayList = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)this.displayList, (int)4864);
        }
        this.vertices(buffer);
        if (OpenGlHelper.func_176075_f()) {
            buffer.func_178977_d();
            buffer.func_178965_a();
            this.vbo.func_181722_a(buffer.func_178966_f());
        } else {
            tess.func_78381_a();
            GlStateManager.func_187415_K();
        }
    }

    private int getScale() {
        return 8;
    }

    private float ceilToScale(float value) {
        float scale = this.getScale();
        return (float)MathHelper.func_76123_f((float)(value / scale)) * scale;
    }

    private void vertices(BufferBuilder buffer) {
        float sectX0;
        float scale = this.getScale();
        float bCol = 1.0f;
        float sectEnd = this.ceilToScale(this.renderDistance * 2 * 16);
        float sectStart = -sectEnd;
        float sectStep = this.ceilToScale(sectEnd * 2.0f / 12.0f);
        float sectPx = 0.00390625f / scale;
        buffer.func_181668_a(7, FORMAT);
        float sectX1 = sectX0 = sectStart;
        while (sectX1 < sectEnd) {
            float sectZ0;
            if ((sectX1 += sectStep) > sectEnd) {
                sectX1 = sectEnd;
            }
            float sectZ1 = sectZ0 = sectStart;
            while (sectZ1 < sectEnd) {
                if ((sectZ1 += sectStep) > sectEnd) {
                    sectZ1 = sectEnd;
                }
                float u0 = sectX0 * sectPx;
                float u1 = sectX1 * sectPx;
                float v0 = sectZ0 * sectPx;
                float v1 = sectZ1 * sectPx;
                buffer.func_181662_b((double)sectX0, 0.0, (double)sectZ0).func_187315_a((double)u0, (double)v0).func_181666_a(bCol, bCol, bCol, 0.7f).func_181675_d();
                buffer.func_181662_b((double)sectX1, 0.0, (double)sectZ0).func_187315_a((double)u1, (double)v0).func_181666_a(bCol, bCol, bCol, 0.7f).func_181675_d();
                buffer.func_181662_b((double)sectX1, 0.0, (double)sectZ1).func_187315_a((double)u1, (double)v1).func_181666_a(bCol, bCol, bCol, 0.7f).func_181675_d();
                buffer.func_181662_b((double)sectX0, 0.0, (double)sectZ1).func_187315_a((double)u0, (double)v1).func_181666_a(bCol, bCol, bCol, 0.7f).func_181675_d();
                sectZ0 = sectZ1;
            }
            sectX0 = sectX1;
        }
    }

    private int fullCoord(double coord, int scale) {
        return (int)coord / scale - (coord < 0.0 ? 1 : 0);
    }

    private void reloadTextures() {
        if (this.mc.field_71446_o != null) {
            this.mc.field_71446_o.func_110577_a(this.texture);
            this.texW = GlStateManager.func_187411_c((int)3553, (int)0, (int)4096);
            this.texH = GlStateManager.func_187411_c((int)3553, (int)0, (int)4097);
        }
    }

    public void onResourceManagerReload(@Nonnull IResourceManager resourceManager, @Nonnull Predicate<IResourceType> resourcePredicate) {
        this.reloadTextures();
    }
}

