/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.util;

import com.barribob.MaelstromMod.entity.action.IAction;
import com.barribob.MaelstromMod.entity.animation.Animation;
import com.barribob.MaelstromMod.entity.animation.AnimationNone;
import com.barribob.MaelstromMod.entity.entities.EntityLeveledMob;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ComboAttack {
    private final HashMap<Byte, IAction> actions = new HashMap();
    @SideOnly(value=Side.CLIENT)
    private HashMap<Byte, Supplier<Animation>> animations;
    private byte currentAttack;

    public void setCurrentAttack(byte b) {
        this.currentAttack = b;
    }

    public byte getCurrentAttack() {
        return this.currentAttack;
    }

    public IAction getCurrentAttackAction() {
        return this.getAction(this.currentAttack);
    }

    @SideOnly(value=Side.CLIENT)
    public void setAttack(byte b, IAction action, Supplier<Animation> anim) {
        if (this.animations == null) {
            this.animations = new HashMap();
        }
        this.setAttack(b, action);
        this.animations.put(b, anim);
    }

    public void setAttack(byte b, final BiConsumer<EntityLeveledMob, EntityLivingBase> action) {
        this.actions.put(b, new IAction(){

            @Override
            public void performAction(EntityLeveledMob actor, EntityLivingBase target) {
                action.accept(actor, target);
            }
        });
    }

    public void setAttack(byte b, IAction action) {
        this.actions.put(b, action);
    }

    @SideOnly(value=Side.CLIENT)
    public Animation getAnimation(byte b) {
        if (this.animations == null) {
            return new AnimationNone();
        }
        if (!this.animations.containsKey(b)) {
            throw new IllegalArgumentException("The byte " + b + " does not correspond to an attack");
        }
        return this.animations.get(b).get();
    }

    private IAction getAction(byte b) {
        if (!this.actions.containsKey(b)) {
            throw new IllegalArgumentException("The byte " + b + " does not correspond to an attack");
        }
        return this.actions.get(b);
    }
}

