/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.tileentity;

import com.barribob.MaelstromMod.entity.entities.EntityLeveledMob;
import com.barribob.MaelstromMod.util.Element;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class MobSpawnerLogic {
    protected int spawnDelay = 20;
    protected int maxNearbyEntities = 6;
    protected int activatingRangeFromPlayer = 16;
    protected int maxCount = 4;
    protected int count = 0;
    protected int spawnRange = 4;
    protected Supplier<World> world;
    protected Supplier<BlockPos> pos;
    protected Block block;
    protected float level;
    protected MobSpawnData[] mobs = new MobSpawnData[]{new MobSpawnData("mm:dream_elk", Element.NONE)};
    protected int[] mobWeights = new int[]{1};

    public MobSpawnerLogic(Supplier<World> world, Supplier<BlockPos> pos, Block block) {
        this.world = world;
        this.pos = pos;
        this.block = block;
    }

    public void setData(String mob, int maxCount, float level, int activationRange) {
        this.setData(new MobSpawnData(mob, Element.NONE, 1), maxCount, level, activationRange);
    }

    public void setData(MobSpawnData mob, int maxCount, float level, int activationRange) {
        this.setData(new MobSpawnData[]{mob}, new int[]{1}, maxCount, level, activationRange);
    }

    public void setData(MobSpawnData[] mobs, int[] mobWeights, int maxCount, float level, int activationRange) {
        if (mobs.length != mobWeights.length) {
            throw new IllegalArgumentException("Mobs and weight arrays for spawner not the same length.");
        }
        this.mobs = mobs;
        this.mobWeights = mobWeights;
        this.activatingRangeFromPlayer = activationRange;
        this.maxCount = maxCount;
        this.level = level;
    }

    public abstract void updateSpawner();

    protected boolean tooManyEntities(World world, Entity entity, BlockPos blockpos) {
        int k = world.func_72872_a(entity.getClass(), new AxisAlignedBB((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), (double)(blockpos.func_177958_n() + 1), (double)(blockpos.func_177956_o() + 1), (double)(blockpos.func_177952_p() + 1)).func_186662_g((double)this.spawnRange)).size();
        return k >= this.maxNearbyEntities;
    }

    protected boolean tryToSpawnEntity() {
        MobSpawnData data = this.getEntityData();
        int x = this.pos.get().func_177958_n() + MathHelper.func_76136_a((Random)this.world.get().field_73012_v, (int)0, (int)this.spawnRange) * MathHelper.func_76136_a((Random)this.world.get().field_73012_v, (int)-1, (int)1);
        int y = this.pos.get().func_177956_o() + MathHelper.func_76136_a((Random)this.world.get().field_73012_v, (int)0, (int)this.spawnRange) * MathHelper.func_76136_a((Random)this.world.get().field_73012_v, (int)-1, (int)1);
        int z = this.pos.get().func_177952_p() + MathHelper.func_76136_a((Random)this.world.get().field_73012_v, (int)0, (int)this.spawnRange) * MathHelper.func_76136_a((Random)this.world.get().field_73012_v, (int)-1, (int)1);
        if (this.world.get().func_180495_p(new BlockPos(x, y - 1, z)).isSideSolid((IBlockAccess)this.world.get(), new BlockPos(x, y - 1, z), EnumFacing.UP)) {
            Entity entity = ModUtils.createMobFromSpawnData(data, this.world.get(), x, y, z);
            if (entity == null) {
                return false;
            }
            if (this.world.get().func_72917_a(entity.func_174813_aQ(), entity) && this.world.get().func_184144_a(entity, entity.func_174813_aQ()).isEmpty() && !this.world.get().func_72953_d(entity.func_174813_aQ()) && !this.tooManyEntities(this.world.get(), entity, this.pos.get())) {
                EntityLiving entityliving;
                EntityLiving entityLiving = entityliving = entity instanceof EntityLiving ? (EntityLiving)entity : null;
                if (entityliving != null) {
                    this.world.get().func_72838_d(entity);
                    this.world.get().func_175718_b(2004, this.pos.get(), 0);
                    entityliving.func_70656_aK();
                    if (entity instanceof EntityLeveledMob) {
                        EntityLeveledMob leveledMob = (EntityLeveledMob)entity;
                        leveledMob.setElement(ModRandom.choice(data.possibleElements, this.world.get().field_73012_v, data.elementalWeights).next());
                        leveledMob.setLevel(this.level);
                    }
                    this.count += data.count;
                    return true;
                }
            }
        }
        return false;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.spawnDelay = nbt.func_74765_d("Delay");
        if (nbt.func_74764_b("MobWeights")) {
            this.mobWeights = nbt.func_74759_k("MobWeights");
        }
        if (nbt.func_74764_b("MaxCount")) {
            this.maxCount = nbt.func_74765_d("MaxCount");
        }
        if (nbt.func_74764_b("Level")) {
            this.level = nbt.func_74760_g("Level");
        }
        if (nbt.func_150297_b("MaxNearbyEntities", 99)) {
            this.maxNearbyEntities = nbt.func_74765_d("MaxNearbyEntities");
            this.activatingRangeFromPlayer = nbt.func_74765_d("RequiredPlayerRange");
        }
        if (nbt.func_150297_b("SpawnRange", 99)) {
            this.spawnRange = nbt.func_74765_d("SpawnRange");
        }
        if (nbt.func_74764_b("MobSpawnData")) {
            NBTTagList nbttaglist = nbt.func_150295_c("MobSpawnData", 10);
            this.mobs = new MobSpawnData[nbttaglist.func_74745_c()];
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound compound = nbttaglist.func_150305_b(i);
                int[] elementIds = compound.func_74759_k("Elements");
                Element[] elements = new Element[elementIds.length];
                for (int j = 0; j < elementIds.length; ++j) {
                    elements[j] = Element.getElementFromId(elementIds[j]);
                }
                MobSpawnData spawnData = new MobSpawnData(compound.func_74779_i("EntityId"), elements, compound.func_74759_k("ElementWeights"), compound.func_74762_e("Count"));
                if (compound.func_74764_b("SpawnData")) {
                    spawnData.mobData = compound.func_74775_l("SpawnData");
                }
                this.mobs[i] = spawnData;
            }
        }
        if (this.mobs.length != this.mobWeights.length) {
            System.err.println("Error loading spawner tile entity data.");
            MobSpawnData[] brokenMobs = new MobSpawnData[]{new MobSpawnData("minecraft:pig", Element.NONE)};
            int[] brokenMobWeights = new int[]{1};
            this.mobs = brokenMobs;
            this.mobWeights = brokenMobWeights;
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        if (this.mobs == null) {
            return compound;
        }
        compound.func_74783_a("MobWeights", this.mobWeights);
        compound.func_74777_a("Delay", (short)this.spawnDelay);
        compound.func_74777_a("MaxNearbyEntities", (short)this.maxNearbyEntities);
        compound.func_74777_a("RequiredPlayerRange", (short)this.activatingRangeFromPlayer);
        compound.func_74777_a("SpawnRange", (short)this.spawnRange);
        compound.func_74777_a("MaxCount", (short)this.maxCount);
        compound.func_74776_a("Level", this.level);
        NBTTagList nbttaglist = new NBTTagList();
        for (MobSpawnData data : this.mobs) {
            NBTTagCompound dataCompound = new NBTTagCompound();
            if (data.mobData != null) {
                dataCompound.func_74782_a("SpawnData", (NBTBase)data.mobData);
            }
            int[] elements = new int[data.possibleElements.length];
            for (int i = 0; i < data.possibleElements.length; ++i) {
                elements[i] = data.possibleElements[i].id;
            }
            dataCompound.func_74783_a("Elements", elements);
            dataCompound.func_74783_a("ElementWeights", data.elementalWeights);
            dataCompound.func_74778_a("EntityId", data.mobId);
            dataCompound.func_74768_a("Count", data.count);
            nbttaglist.func_74742_a((NBTBase)dataCompound);
        }
        compound.func_74782_a("MobSpawnData", (NBTBase)nbttaglist);
        return compound;
    }

    protected MobSpawnData getEntityData() {
        return ModRandom.choice(this.mobs, this.world.get().field_73012_v, this.mobWeights).next();
    }

    public void broadcastEvent(int id) {
        this.world.get().func_175641_c(this.pos.get(), this.block, id, 0);
    }

    public static class MobSpawnData {
        public String mobId;
        int count;
        public Element[] possibleElements;
        public int[] elementalWeights;
        public NBTTagCompound mobData;

        public MobSpawnData(NBTTagCompound entityData) {
            this(entityData.func_74779_i("id"), Element.NONE);
            this.mobData = entityData;
        }

        public MobSpawnData(String mobId, Element element) {
            this(mobId, element, 1);
        }

        public MobSpawnData(String mobId, Element element, int count) {
            this(mobId, new Element[]{element}, new int[]{1}, count);
        }

        public MobSpawnData(String mobId, Element[] possibleElements, int[] elementalWeights, int count) {
            this.mobId = mobId;
            if (possibleElements.length != elementalWeights.length) {
                throw new IllegalArgumentException("Element and weight arrays not the same length.");
            }
            this.possibleElements = possibleElements;
            this.elementalWeights = elementalWeights;
            this.count = count;
        }

        public void addMobNBT(NBTTagCompound mobData) {
            this.mobData = mobData;
        }
    }
}

