/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.projectile;

import com.barribob.MaelstromMod.entity.projectile.ProjectileGun;
import com.barribob.MaelstromMod.util.Element;
import com.barribob.MaelstromMod.util.ModDamageSource;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.ParticleManager;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class ProjectileQuake
extends ProjectileGun {
    protected static final float AREA_FACTOR = 0.5f;
    protected int updates = 5;

    public ProjectileQuake(World worldIn, EntityLivingBase throwerIn, float baseDamage, ItemStack stack) {
        super(worldIn, throwerIn, baseDamage, stack);
        this.func_189654_d(true);
    }

    public ProjectileQuake(World worldIn) {
        super(worldIn);
    }

    public ProjectileQuake(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    @Override
    protected void spawnParticles() {
        IBlockState block = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v));
        if (block.func_185917_h()) {
            for (int i = 0; i < 5; ++i) {
                ParticleManager.spawnBreak(this.field_70170_p, this.func_174791_d().func_178787_e(ModRandom.randVec().func_186678_a(1.0).func_178787_e(ModUtils.yVec(0.75))), Item.func_150898_a((Block)block.func_177230_c()), ModRandom.randVec().func_186678_a(0.1).func_178787_e(ModUtils.yVec(0.1f)));
            }
            if (this.getElement() != Element.NONE) {
                ParticleManager.spawnEffect(this.field_70170_p, this.func_174791_d().func_178787_e(ModUtils.yVec(0.5)).func_178787_e(ModRandom.randVec()), this.getElement().particleColor);
            }
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        for (int i = 0; i < this.updates; ++i) {
            if (!this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v)).func_185917_h()) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u - 0.25, this.field_70161_v);
                continue;
            }
            if (!this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v)).func_185917_h()) continue;
            this.func_70107_b(this.field_70165_t, this.field_70163_u + 0.25, this.field_70161_v);
        }
        this.playQuakeSound();
        this.onQuakeUpdate();
        if (!this.field_70170_p.field_72995_K && Math.abs(this.field_70159_w) + Math.abs(this.field_70179_y) < (double)0.01f) {
            this.func_70106_y();
        }
    }

    protected void onQuakeUpdate() {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_186662_g(0.5).func_72321_a(0.0, 0.25, 0.0));
        for (Entity entity : list) {
            float f1;
            if (!(entity instanceof EntityLivingBase) || this.shootingEntity == null || entity == this.shootingEntity) continue;
            int burnTime = this.func_70027_ad() ? 5 : 0;
            entity.func_70015_d(burnTime);
            DamageSource source = ModDamageSource.builder().type("mm:thrownMaelstrom").indirectEntity((Entity)this.shootingEntity).directEntity(this).element(this.getElement()).stoppedByArmorNotShields().build();
            entity.func_70097_a(source, this.getGunDamage(entity));
            if (this.getKnockback() <= 0 || !((f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f)) continue;
            entity.func_70024_g(this.field_70159_w * (double)this.getKnockback() * (double)0.6f / (double)f1, 0.1, this.field_70179_y * (double)this.getKnockback() * (double)0.6f / (double)f1);
        }
    }

    protected void playQuakeSound() {
        BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        if (state.func_185917_h()) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, state.func_177230_c().getSoundType(state, this.field_70170_p, pos, (Entity)this).func_185844_d(), SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    @Override
    protected void onHit(RayTraceResult result) {
    }
}

