/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.projectile;

import com.barribob.MaelstromMod.entity.projectile.ProjectileGun;
import com.barribob.MaelstromMod.util.ModDamageSource;
import com.barribob.MaelstromMod.util.ModRandom;
import com.barribob.MaelstromMod.util.ModUtils;
import com.barribob.MaelstromMod.util.handlers.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ProjectileMaelstromCannon
extends ProjectileGun {
    private static final int PARTICLE_AMOUNT = 1;
    private static final int IMPACT_PARTICLE_AMOUNT = 20;
    private static final int EXPOSION_AREA_FACTOR = 2;

    public ProjectileMaelstromCannon(World worldIn, EntityLivingBase throwerIn, float baseDamage, ItemStack stack) {
        super(worldIn, throwerIn, baseDamage, stack);
    }

    public ProjectileMaelstromCannon(World worldIn) {
        super(worldIn);
    }

    public ProjectileMaelstromCannon(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    @Override
    protected void spawnParticles() {
        for (int i = 0; i < 1; ++i) {
            ParticleManager.spawnMaelstromSmoke(this.field_70170_p, this.field_70146_Z, new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v), true);
        }
    }

    @Override
    protected void spawnImpactParticles() {
        for (int i = 0; i < 20; ++i) {
            Vec3d vec1 = ModRandom.randVec().func_186678_a(0.5).func_178787_e(this.func_174791_d());
            ParticleManager.spawnMaelstromExplosion(this.field_70170_p, this.field_70146_Z, vec1);
        }
    }

    @Override
    protected void onHit(RayTraceResult result) {
        float knockbackFactor = 1.0f + (float)this.getKnockback() * 0.4f;
        int fireFactor = this.func_70027_ad() ? 5 : 0;
        ModUtils.handleAreaImpact(2.0f, e -> Float.valueOf(this.getGunDamage((Entity)e)), (Entity)this.shootingEntity, this.func_174791_d(), ModDamageSource.causeElementalExplosionDamage(this.shootingEntity, this.getElement()), knockbackFactor, fireFactor);
        this.func_184185_a(SoundEvents.field_187539_bB, 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        super.onHit(result);
    }
}

