/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.projectile;

import com.barribob.MaelstromMod.entity.projectile.EntityModThrowable;
import com.barribob.MaelstromMod.init.ModItems;
import com.barribob.MaelstromMod.util.Element;
import com.barribob.MaelstromMod.util.IElement;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Projectile
extends EntityModThrowable
implements IElement {
    protected float travelRange;
    private final Vec3d startPos;
    protected static final byte IMPACT_PARTICLE_BYTE = 3;
    private static final byte PARTICLE_BYTE = 4;
    private float damage = 0.0f;
    protected static final DataParameter<Integer> ELEMENT = EntityDataManager.func_187226_a(Projectile.class, (DataSerializer)DataSerializers.field_187192_b);
    protected float maxAge = 400.0f;
    private Item itemToRender = ModItems.INVISIBLE;

    public Projectile(World worldIn, EntityLivingBase throwerIn, float damage) {
        super(worldIn, throwerIn);
        this.travelRange = 20.0f;
        this.setDamage(damage);
        this.startPos = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (throwerIn instanceof IElement) {
            this.setElement(((IElement)throwerIn).getElement());
        }
    }

    public Projectile(World worldIn) {
        super(worldIn);
        this.startPos = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public Projectile(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
        this.startPos = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    protected double getDistanceTraveled() {
        return this.func_70011_f(this.startPos.field_72450_a, this.startPos.field_72448_b, this.startPos.field_72449_c);
    }

    public void setTravelRange(float distance) {
        this.travelRange = distance;
    }

    protected void setDamage(float damage) {
        this.damage = damage;
    }

    protected float getDamage() {
        return this.damage;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        if (this.shootingEntity != null && this.getDistanceTraveled() > (double)this.travelRange) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
        if ((float)this.field_70173_aa > this.maxAge) {
            this.func_70106_y();
        }
    }

    @Override
    protected void onHit(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 3) {
            this.spawnImpactParticles();
        }
        if (id == 4) {
            this.spawnParticles();
        }
    }

    protected void spawnParticles() {
    }

    protected void spawnImpactParticles() {
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ELEMENT, (Object)Element.NONE.id);
    }

    @Override
    public Element getElement() {
        return this.field_70180_af == null ? Element.getElementFromId(Element.NONE.id) : Element.getElementFromId((Integer)this.field_70180_af.func_187225_a(ELEMENT));
    }

    public Projectile setElement(Element element) {
        this.field_70180_af.func_187227_b(ELEMENT, (Object)element.id);
        return this;
    }

    public Item getItemToRender() {
        return this.itemToRender;
    }

    public Projectile setItemToRender(Item itemToRender) {
        this.itemToRender = itemToRender;
        return this;
    }
}

