/*
 * Decompiled with CFR 0.152.
 */
package com.barribob.MaelstromMod.entity.projectile;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityModThrowable
extends Entity
implements IProjectile {
    private static final Predicate<Entity> ARROW_TARGETS = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, EntitySelectors.field_94557_a, new Predicate<Entity>(){

        public boolean apply(@Nullable Entity p_apply_1_) {
            return p_apply_1_.func_70067_L();
        }
    }});
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private Block inTile;
    protected boolean inGround;
    protected int timeInGround;
    public int throwableShake;
    public EntityLivingBase shootingEntity;
    private int ticksInGround;
    private int ticksInAir;

    public EntityModThrowable(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityModThrowable(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.func_70107_b(x, y, z);
    }

    public EntityModThrowable(World worldIn, EntityLivingBase shooter) {
        this(worldIn, shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e() - (double)0.1f, shooter.field_70161_v);
        this.shootingEntity = shooter;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntityModThrowable.func_184183_bd()) * d0;
    }

    public void shoot(Entity shooter, float pitch, float yaw, float p_184547_4_, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        this.field_70159_w += shooter.field_70159_w;
        this.field_70179_y += shooter.field_70179_y;
        if (!shooter.field_70122_E) {
            this.field_70181_x += shooter.field_70181_x;
        }
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.ticksInGround = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.29577951308232);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    public void func_70071_h_() {
        AxisAlignedBB axisalignedbb;
        super.func_70071_h_();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        BlockPos blockpos = new BlockPos(this.xTile, this.yTile, this.zTile);
        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        if (iblockstate.func_185904_a() != Material.field_151579_a && (axisalignedbb = iblockstate.func_185890_d((IBlockAccess)this.field_70170_p, blockpos)) != Block.field_185506_k && axisalignedbb.func_186670_a(blockpos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            this.inGround = true;
        }
        if (this.throwableShake > 0) {
            --this.throwableShake;
        }
        if (this.inGround) {
            if (this.field_70170_p.func_180495_p(new BlockPos(this.xTile, this.yTile, this.zTile)).func_177230_c() == this.inTile) {
                ++this.ticksInGround;
                if (this.ticksInGround == 1200) {
                    this.func_70106_y();
                }
                return;
            }
            this.inGround = false;
            this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.ticksInGround = 0;
            this.ticksInAir = 0;
        } else {
            Entity entity;
            this.timeInGround = 0;
            ++this.ticksInAir;
            Vec3d vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d1, vec3d, false, true, false);
            vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (raytraceresult != null) {
                vec3d = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
            }
            if ((entity = this.findEntityOnPath(vec3d1, vec3d)) != null) {
                raytraceresult = new RayTraceResult(entity);
            }
            if (raytraceresult != null && raytraceresult.field_72308_g instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)raytraceresult.field_72308_g;
                if (this.shootingEntity instanceof EntityPlayer && !((EntityPlayer)this.shootingEntity).func_96122_a(entityplayer)) {
                    raytraceresult = null;
                }
            }
            if (raytraceresult != null && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
                this.onHit(raytraceresult);
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float f4 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f4) * 57.29577951308232);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float f1 = 0.99f;
            float f2 = 0.05f;
            if (this.func_70090_H()) {
                for (int i = 0; i < 4; ++i) {
                    float f3 = 0.25f;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
                f1 = 0.6f;
            }
            if (this.func_70026_G()) {
                this.func_70066_B();
            }
            this.field_70159_w *= (double)f1;
            this.field_70181_x *= (double)f1;
            this.field_70179_y *= (double)f1;
            if (!this.func_189652_ae()) {
                this.field_70181_x -= (double)0.05f;
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
    }

    protected abstract void onHit(RayTraceResult var1);

    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x, y, z);
        if (this.inGround) {
            this.xTile = MathHelper.func_76128_c((double)this.field_70165_t);
            this.yTile = MathHelper.func_76128_c((double)this.field_70163_u);
            this.zTile = MathHelper.func_76128_c((double)this.field_70161_v);
        }
    }

    @Nullable
    protected Entity findEntityOnPath(Vec3d start, Vec3d end) {
        Entity entity = null;
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0), ARROW_TARGETS);
        double d0 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult;
            Entity entity1 = (Entity)list.get(i);
            if (entity1 == this.shootingEntity && this.ticksInAir < 5 || (raytraceresult = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(start, end)) == null || !((d1 = start.func_72436_e(raytraceresult.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity;
    }

    public static void registerFixesArrow(DataFixer fixer, String name) {
    }

    public static void registerFixesArrow(DataFixer fixer) {
        EntityModThrowable.registerFixesArrow(fixer, "Arrow");
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("xTile", this.xTile);
        compound.func_74768_a("yTile", this.yTile);
        compound.func_74768_a("zTile", this.zTile);
        compound.func_74777_a("life", (short)this.ticksInGround);
        ResourceLocation resourcelocation = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.inTile);
        compound.func_74778_a("inTile", resourcelocation == null ? "" : resourcelocation.toString());
        compound.func_74774_a("shake", (byte)this.throwableShake);
        compound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.xTile = compound.func_74762_e("xTile");
        this.yTile = compound.func_74762_e("yTile");
        this.zTile = compound.func_74762_e("zTile");
        this.ticksInGround = compound.func_74765_d("life");
        this.inTile = compound.func_150297_b("inTile", 8) ? Block.func_149684_b((String)compound.func_74779_i("inTile")) : Block.func_149729_e((int)(compound.func_74771_c("inTile") & 0xFF));
        this.throwableShake = compound.func_74771_c("shake") & 0xFF;
        this.inGround = compound.func_74771_c("inGround") == 1;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70075_an() {
        return false;
    }

    public float func_70047_e() {
        return 0.0f;
    }

    protected void func_70088_a() {
    }
}

